/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.DocumentChangedException;
import com.ibm.websphere.management.exception.DocumentLockedException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.RepositoryInputStream;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.util.ConfigLimits;
import com.ibm.ws.sm.workspace.ConflictResolution;
import com.ibm.ws.sm.workspace.ConflictState;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceFileState;
import com.ibm.ws.sm.workspace.WorkSpaceRepositoryAdapter;
import com.ibm.ws.sm.workspace.impl.FileAccessorUtil;
import com.ibm.ws.sm.workspace.impl.RepositoryContextImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMessage;
import com.ibm.ws.sm.workspace.impl.WorkSpaceResourceSet;
import com.ibm.ws.sm.workspace.merger.MergeUtilManager;
import com.ibm.ws.sm.workspace.merger.impl.ServerIndexMerger;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.configarchive.DefaultFileAccessor;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class WorkSpaceMasterRepositoryAdapter
implements WorkSpaceRepositoryAdapter,
WorkSpaceMessage,
WorkSpaceConstant {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(WorkSpaceMasterRepositoryAdapter.class);
    private boolean debugEnabled = tc.isDebugEnabled();
    private static final String SESSION_ID_FILE_PREFIX = ".workspace_";
    private static final String DIGEST_SUFFIX = ".workspace_save";
    private static final String ORIG_SUFFIX = ".copy";
    private static final String BACKUP_SUFFIX = ".backup";
    private static final String CURRENT_SUFFIX = ".current";
    private static final String WORKSPACE_REPOSITORY = ".repositoryContext";
    private static final String SERVER_INDEX_NAME = "serverindex.xml";
    private static final String CLUSTER_XML_NAME = "cluster.xml";
    private static final String WORKSPACE_MONITOR = "workspace_monitor";
    private static final String CONFIG_CONSISTENCY_CHECK = "config_consistency_check";
    private static ConfigRepository defaultRepository;
    private static boolean init;
    private static RepositoryMetaData defaultMetaData;
    private ConfigRepository configRepository = null;
    private Properties repositoryProp;

    private ConfigRepository getConfigRepository() throws WorkSpaceException {
        if (this.configRepository == null) {
            this.configRepository = this.repositoryProp != null && this.repositoryProp.getProperty("location") != null ? WorkSpaceMasterRepositoryAdapter.getRepository(this.repositoryProp) : WorkSpaceMasterRepositoryAdapter.getDefaultRepository();
            if (this.configRepository == null) {
                throw WorkSpaceLogger.createException(tc, "WKSP0007E Error getting ConfigRepository -{0}", new Object[]{null});
            }
        }
        return this.configRepository;
    }

    private RepositoryMetaData getDefaultMetaData() {
        if (defaultMetaData == null) {
            try {
                String string = (String)WorkSpaceMasterRepositoryAdapter.getDefaultRepository().getConfig().get("was.repository.root");
                if (string != null) {
                    string = string + File.separator + ".repository";
                }
                if (string == null || !new File(string).isDirectory()) {
                    throw WorkSpaceLogger.createException(tc, "WKSP0020E Error getting meta data root {0}", new Object[]{string});
                }
                defaultMetaData = RepositoryMetaDataFactory.getFactory().getMetaData(string);
            }
            catch (WorkSpaceException workSpaceException) {
                new RuntimeException(workSpaceException.getMessage());
            }
        }
        return defaultMetaData;
    }

    private static ConfigRepository getDefaultRepository() throws WorkSpaceException {
        if (defaultRepository == null) {
            Properties properties = new Properties();
            properties.setProperty("location", "local");
            defaultRepository = WorkSpaceMasterRepositoryAdapter.getRepository(properties);
        }
        return defaultRepository;
    }

    private static ConfigRepository getRepository(Properties properties) throws WorkSpaceException {
        try {
            return ConfigRepositoryClientFactory.getConfigRepositoryClient(properties);
        }
        catch (AdminException adminException) {
            throw WorkSpaceLogger.createException(tc, "WKSP0007E Error getting ConfigRepository -{0}", new Object[]{adminException}, adminException);
        }
    }

    public String[] getCatalog(WorkSpace workSpace, String string, int n, int n2) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCatalog ()", new Object[]{workSpace, string, new Integer(n), new Integer(n2)});
        }
        int n3 = 1;
        int n4 = n2;
        switch (n) {
            case 1: {
                n3 = 1;
                break;
            }
            case 0: {
                n3 = 2;
                break;
            }
            case 2: {
                n3 = 255;
            }
        }
        switch (n2) {
            case -1: {
                n4 = Integer.MAX_VALUE;
                break;
            }
            case 1: {
                n4 = 1;
                break;
            }
            case 0: {
                n4 = 0;
            }
        }
        String[] stringArray = this.getConfigRepository().listResourceNames(string, n3, n4);
        if (tc.isEntryEnabled()) {
            String string2 = "";
            if (string.length() > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = stringArray[i].substring(string.length() + 1);
                    if (i != 0) {
                        string2 = string2 + ", ";
                    }
                    string2 = string2 + stringArray[i];
                }
            }
            Tr.exit(tc, "getCatalog () return: [" + string2 + "]");
        } else if (string.length() > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].substring(string.length() + 1);
            }
        }
        return stringArray;
    }

    public boolean exist(WorkSpace workSpace, String string) throws WorkSpaceException {
        String[] stringArray = this.getConfigRepository().listResourceNames(string, 255, 0);
        return stringArray.length > 0;
    }

    /*
     * Unable to fully structure code
     */
    public Integer checkSynchState(WorkSpaceFile var1_1) throws WorkSpaceException {
        if (WorkSpaceMasterRepositoryAdapter.tc.isEntryEnabled()) {
            Tr.entry(WorkSpaceMasterRepositoryAdapter.tc, "checkSynchState (" + var1_1 + ")");
        }
        var2_2 = ConflictState.UN_MODIFIED;
        if (var1_1.getState() == WorkSpaceFileState.UPDATED || var1_1.getState() == WorkSpaceFileState.DELETED || var1_1.getState() == WorkSpaceFileState.EXTRACTED) {
            if (!this.exist(var1_1.getContext().getWorkSpace(), var1_1.getURI())) {
                if (this.debugEnabled) {
                    Tr.debug(WorkSpaceMasterRepositoryAdapter.tc, var1_1.getURI() + " has been removed in Master Repository");
                }
                var2_2 = ConflictState.REMOVED;
            } else {
                try {
                    var3_3 = this.getConfigRepository().getDigest(var1_1.getURI());
                    if (var3_3 == null || var3_3.equals(this.getDigest(var1_1))) ** GOTO lbl24
                    if (this.debugEnabled) {
                        Tr.debug(WorkSpaceMasterRepositoryAdapter.tc, var1_1.getURI() + " has been modified in Master Repository");
                    }
                    var2_2 = ConflictState.MODIFIED;
                    var2_2 = this.checkMerge(var1_1, var2_2);
                }
                catch (Exception var3_4) {
                    throw WorkSpaceLogger.createException(WorkSpaceMasterRepositoryAdapter.tc, "WKSP0008E RepositoryException while checking the state of {0} in the master repository --{1}", new Object[]{var1_1.getURI(), var3_4}, var3_4);
                }
            }
        } else if (var1_1.getState() == WorkSpaceFileState.ADDED && this.exist(var1_1.getContext().getWorkSpace(), var1_1.getURI())) {
            if (this.debugEnabled) {
                Tr.debug(WorkSpaceMasterRepositoryAdapter.tc, var1_1.getURI() + " has been added in Master Repository");
            }
            var2_2 = ConflictState.ADDED;
        }
lbl24:
        // 6 sources

        if (WorkSpaceMasterRepositoryAdapter.tc.isEntryEnabled()) {
            Tr.exit(WorkSpaceMasterRepositoryAdapter.tc, "checkSynchState (" + var1_1 + ") return: " + var2_2);
        }
        return var2_2;
    }

    /*
     * Unable to fully structure code
     */
    Integer checkSynchStateForRefresh(WorkSpaceFile var1_1) throws WorkSpaceException {
        if (WorkSpaceMasterRepositoryAdapter.tc.isEntryEnabled()) {
            Tr.entry(WorkSpaceMasterRepositoryAdapter.tc, "checkSynchStateForRefresh (" + var1_1 + ")");
        }
        var2_2 = ConflictState.UN_MODIFIED;
        if (var1_1.getState() == WorkSpaceFileState.UPDATED || var1_1.getState() == WorkSpaceFileState.DELETED || var1_1.getState() == WorkSpaceFileState.EXTRACTED) {
            if (!this.exist(var1_1.getContext().getWorkSpace(), var1_1.getURI())) {
                if (this.debugEnabled) {
                    Tr.debug(WorkSpaceMasterRepositoryAdapter.tc, var1_1.getURI() + " has been removed in Master Repository");
                }
                var2_2 = ConflictState.REMOVED;
            } else {
                try {
                    var3_3 = this.getConfigRepository().getDigest(var1_1.getURI());
                    if (var3_3 == null || var3_3.equals(this.getDigest(var1_1))) ** GOTO lbl24
                    if (this.debugEnabled) {
                        Tr.debug(WorkSpaceMasterRepositoryAdapter.tc, var1_1.getURI() + " has been modified in Master Repository");
                    }
                    var2_2 = ConflictState.MODIFIED;
                    var2_2 = this.checkMergeForRefresh(var1_1, var2_2);
                }
                catch (Exception var3_4) {
                    throw WorkSpaceLogger.createException(WorkSpaceMasterRepositoryAdapter.tc, "WKSP0008E RepositoryException while checking the state of {0} in the master repository --{1}", new Object[]{var1_1.getURI(), var3_4}, var3_4);
                }
            }
        } else if (var1_1.getState() == WorkSpaceFileState.ADDED && this.exist(var1_1.getContext().getWorkSpace(), var1_1.getURI())) {
            if (this.debugEnabled) {
                Tr.debug(WorkSpaceMasterRepositoryAdapter.tc, var1_1.getURI() + " has been added in Master Repository");
            }
            var2_2 = ConflictState.ADDED;
        }
lbl24:
        // 6 sources

        if (WorkSpaceMasterRepositoryAdapter.tc.isEntryEnabled()) {
            Tr.exit(WorkSpaceMasterRepositoryAdapter.tc, "checkSynchStateForRefresh (" + var1_1 + ") return: " + var2_2);
        }
        return var2_2;
    }

    boolean isSelfCorrection() {
        boolean bl = true;
        String string = null;
        String string2 = "DMGR";
        if (AdminServiceFactory.getAdminService() == null || !AdminServiceFactory.getAdminService().getProcessType().equals("DeploymentManager")) {
            string2 = "LocalMode or Non-DMGR";
            bl = false;
        } else {
            try {
                string = System.getProperty(CONFIG_CONSISTENCY_CHECK);
                if (string != null && string.equals("false")) {
                    bl = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isSelfCorrection return " + bl + ", processType = " + string2 + ", " + CONFIG_CONSISTENCY_CHECK + " = " + string);
        }
        return bl;
    }

    private void selfCorrect(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        if (workSpaceFile.getName().equalsIgnoreCase(SERVER_INDEX_NAME)) {
            ServerIndexMerger serverIndexMerger = (ServerIndexMerger)MergeUtilManager.getUtil(workSpaceFile);
            serverIndexMerger.selfCorrect(workSpaceFile);
        }
    }

    private DocumentDigest getDigest(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        DocumentDigest documentDigest = null;
        String string = null;
        RepositoryContext repositoryContext = workSpaceFile.getContext();
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)repositoryContext.getWorkSpace();
        FileAccessor fileAccessor = workSpaceImpl.getFileAccessor();
        if (this.needMerge(workSpaceFile) && !FileAccessorUtil.exist(fileAccessor, string = workSpaceFile.getURI() + CURRENT_SUFFIX + DIGEST_SUFFIX)) {
            string = null;
        }
        if (string == null) {
            string = workSpaceFile.getURI() + DIGEST_SUFFIX;
        }
        if (this.debugEnabled) {
            Tr.debug(tc, "Digest version: " + string);
        }
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(fileAccessor.load(string));
            documentDigest = (DocumentDigest)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            throw WorkSpaceLogger.createException(tc, "WKSP0016E Error get digest for {0} --{1}", new Object[]{string, exception}, exception);
        }
        return documentDigest;
    }

    private void validateFileLength(Map map) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateFileLength", map);
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator.next();
            String string = workSpaceFile.getURI();
            String string2 = string.replace('/', File.separatorChar);
            try {
                String string3;
                FileAccessor fileAccessor = ((WorkSpaceImpl)workSpaceFile.getContext().getWorkSpace()).getFileAccessor();
                String string4 = FileAccessorUtil.getFullPath(fileAccessor, string2);
                WorkSpaceMasterRepositoryAdapter.checkURILength(string4);
                if (!FileAccessorUtil.exist(fileAccessor, string)) {
                    string3 = "validateFileLength: File \"" + string4 + "\" does not exist in wstemp, and will not be updated to master repository.";
                    Tr.warning(tc, string3);
                    iterator.remove();
                    continue;
                }
                if (FileAccessorUtil.getLength(fileAccessor, string) != 0L) continue;
                string3 = File.separator + "applications" + File.separator;
                String string5 = "validateFileLength: File \"" + string4 + "\" is zero length.";
                if (string2.indexOf(string3) < 0) {
                    Tr.error(tc, string5);
                    throw new WorkSpaceException(string5);
                }
                Tr.warning(tc, string5);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.sm.workspace.impl.WorkSpaceMasterRepositoryAdapter.validateFileLength", "370", this);
                throw WorkSpaceLogger.createException(tc, "WKSP0022E File validation failed --{0}.", new Object[]{exception}, exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateFileLength");
        }
    }

    private void backupServerindex(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        RepositoryContext repositoryContext = workSpaceFile.getContext();
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)repositoryContext.getWorkSpace();
        FileAccessor fileAccessor = workSpaceImpl.getFileAccessor();
        String string = workSpaceFile.getURI();
        if (this.needMerge(workSpaceFile)) {
            if (this.debugEnabled) {
                Tr.debug(tc, "backupServerindex: " + workSpaceFile);
            }
            try {
                FileAccessorUtil.copyFile(fileAccessor, string, string + BACKUP_SUFFIX);
            }
            catch (IOException iOException) {
                throw WorkSpaceLogger.createException(tc, "WKSP0023E Unable to copy file {0} due to exception --{1}", new Object[]{string, iOException});
            }
        }
    }

    private void restoreServerindex(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        RepositoryContext repositoryContext = workSpaceFile.getContext();
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)repositoryContext.getWorkSpace();
        FileAccessor fileAccessor = workSpaceImpl.getFileAccessor();
        String string = workSpaceFile.getURI();
        if (this.needMerge(workSpaceFile)) {
            if (this.debugEnabled) {
                Tr.debug(tc, "restoreServerindex: " + workSpaceFile);
            }
            try {
                FileAccessorUtil.copyFile(fileAccessor, string + BACKUP_SUFFIX, string);
            }
            catch (IOException iOException) {
                throw WorkSpaceLogger.createException(tc, "WKSP0023E Unable to copy file {0} due to exception --{1}", new Object[]{string + BACKUP_SUFFIX, iOException});
            }
        }
    }

    public void update(Map[] mapArray) throws WorkSpaceException {
        WorkSpaceFile workSpaceFile;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "update", mapArray);
        }
        this.validateFileLength(mapArray[0]);
        this.validateFileLength(mapArray[1]);
        DocumentContentSource[] documentContentSourceArray = new DocumentContentSource[mapArray[0].size()];
        int n = 0;
        DocumentContentSource[] documentContentSourceArray2 = mapArray[0].keySet().iterator();
        while (documentContentSourceArray2.hasNext()) {
            workSpaceFile = (WorkSpaceFile)documentContentSourceArray2.next();
            documentContentSourceArray[n] = (DocumentContentSource)this.collectFile(workSpaceFile, (Integer)mapArray[0].get(workSpaceFile));
            if (this.isClusterFile(workSpaceFile)) {
                this.checkClusterConfigLimit(workSpaceFile);
            }
            if (this.debugEnabled) {
                Tr.debug(tc, documentContentSourceArray[n].getDocument().getURI() + " will be added to the Master Repository");
            }
            ++n;
        }
        documentContentSourceArray2 = new DocumentContentSource[mapArray[1].size()];
        n = 0;
        Document[] documentArray = mapArray[1].keySet().iterator();
        while (documentArray.hasNext()) {
            workSpaceFile = (WorkSpaceFile)documentArray.next();
            this.backupServerindex(workSpaceFile);
            if (this.isSelfCorrection()) {
                this.selfCorrect(workSpaceFile);
            }
            documentContentSourceArray2[n] = (DocumentContentSource)this.collectFile(workSpaceFile, (Integer)mapArray[1].get(workSpaceFile));
            if (this.debugEnabled) {
                Tr.debug(tc, documentContentSourceArray2[n].getDocument().getURI() + " will be updated to the Master Repository");
            }
            ++n;
        }
        documentArray = new Document[mapArray[2].size()];
        n = 0;
        Iterator iterator = mapArray[2].keySet().iterator();
        while (iterator.hasNext()) {
            workSpaceFile = (WorkSpaceFile)iterator.next();
            documentArray[n] = (Document)this.collectFile(workSpaceFile, (Integer)mapArray[2].get(workSpaceFile));
            if (this.debugEnabled) {
                Tr.debug(tc, documentArray[n].getURI() + " will be deleted to the Master Repository");
            }
            ++n;
        }
        boolean bl = true;
        int n2 = 10;
        for (n = 1; n <= n2; ++n) {
            Integer n3;
            Iterator iterator2;
            int n4;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "update, addedDocs: " + documentContentSourceArray.length + ", updatedDocs: " + documentContentSourceArray2.length + ", deletedDocs: " + documentArray.length);
                }
                this.getConfigRepository().update(documentContentSourceArray, documentContentSourceArray2, documentArray);
            }
            catch (DocumentChangedException documentChangedException) {
                Tr.warning(tc, "Got DocumentChangedException, #" + n + " on file \"" + documentChangedException.getMessage() + "\"", documentChangedException);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n4 = 0;
                iterator2 = mapArray[1].keySet().iterator();
                while (iterator2.hasNext()) {
                    workSpaceFile = (WorkSpaceFile)iterator2.next();
                    n3 = ConflictState.MODIFIED;
                    this.restoreServerindex(workSpaceFile);
                    n3 = this.checkMerge(workSpaceFile, n3);
                    if (this.isSelfCorrection()) {
                        this.selfCorrect(workSpaceFile);
                    }
                    documentContentSourceArray2[n4] = (DocumentContentSource)this.collectFile(workSpaceFile, (Integer)mapArray[1].get(workSpaceFile));
                    ++n4;
                }
                continue;
            }
            catch (DocumentLockedException documentLockedException) {
                Tr.warning(tc, "Got DocumentLockedException, #" + n + " on file \"" + documentLockedException.getMessage() + "\"", documentLockedException);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n4 = 0;
                iterator2 = mapArray[1].keySet().iterator();
                while (iterator2.hasNext()) {
                    workSpaceFile = (WorkSpaceFile)iterator2.next();
                    n3 = ConflictState.MODIFIED;
                    this.restoreServerindex(workSpaceFile);
                    n3 = this.checkMerge(workSpaceFile, n3);
                    if (this.isSelfCorrection()) {
                        this.selfCorrect(workSpaceFile);
                    }
                    documentContentSourceArray2[n4] = (DocumentContentSource)this.collectFile(workSpaceFile, (Integer)mapArray[1].get(workSpaceFile));
                    ++n4;
                }
                continue;
            }
            catch (RepositoryException repositoryException) {
                throw new WorkSpaceException("RepositoryException while updating documents in master repository", repositoryException);
            }
            bl = false;
            break;
        }
        if (bl) {
            throw new WorkSpaceException("RepositoryException while retry updating documents in master repository");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "update");
        }
    }

    private boolean isClusterFile(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        boolean bl = false;
        String string = workSpaceFile.getURI();
        if (string != null) {
            bl = string.endsWith(CLUSTER_XML_NAME) && string.indexOf("/clusters/") != -1;
        } else if (this.debugEnabled) {
            Tr.debug(tc, "isClusterFile: null URI");
        }
        return bl;
    }

    private void checkClusterConfigLimit(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        ConfigRepository configRepository;
        String[] stringArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkClusterConfigLimit");
        }
        RepositoryContext repositoryContext = workSpaceFile.getContext().getParentContext();
        String string = repositoryContext.getURI() + "/clusters";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clusters URI: " + string);
        }
        if ((stringArray = (configRepository = WorkSpaceMasterRepositoryAdapter.getDefaultRepository()).listResourceNames(string, 2, 0)).length > 0) {
            stringArray = configRepository.listResourceNames(string, 2, 1);
        }
        short s = (short)stringArray.length;
        Collection collection = repositoryContext.findContext(repositoryContext.getWorkSpace().getMetaData().getContextType("clusters"));
        short s2 = (short)collection.size();
        short s3 = (short)(s + s2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cluster Info:", new String[]{"existing=" + s, "newClusterCount=" + s2});
        }
        try {
            ConfigLimits configLimits = ConfigLimits.createConfigLimits();
            if (!configLimits.isNumberOfClustersWithinLimit(s3)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkClusterConfigLimit: Exceeding number of clusters permitted by license.", new String[]{"totalClusterCount=" + s3});
                }
                throw WorkSpaceLogger.createException(tc, "WKSP0550E WebSphere Application Server license restrictions in effect do not allow this configuration change.");
            }
        }
        catch (AdminException adminException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkClusterConfigLimit", "Exception: Config limits read error.");
            }
            throw WorkSpaceLogger.createException(tc, "WKSP0551E An error occurred while checking licensing restrictions.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkClusterConfigLimit", "Within limits");
        }
    }

    public void extract(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extract (file: " + workSpaceFile + ")");
        }
        this.extract(workSpaceFile, workSpaceFile.getURI(), this.needMerge(workSpaceFile));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extract (file: " + workSpaceFile + ")");
        }
    }

    private void extract(WorkSpaceFile workSpaceFile, String string, boolean bl) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extract (file: " + workSpaceFile + ", target: " + string + ", needCopy: " + bl + ")");
        }
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        String string2 = workSpaceFile.getURI();
        RepositoryContext repositoryContext = workSpaceFile.getContext();
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)repositoryContext.getWorkSpace();
        FileAccessor fileAccessor = workSpaceImpl.getFileAccessor();
        try {
            File file = new File(string);
            FileAccessorUtil.makeDir(fileAccessor, file.getParent());
            if (this.debugEnabled) {
                Tr.debug(tc, "Extracting from " + string2);
            }
            DocumentContentSource documentContentSource = this.getConfigRepository().extract(string2);
            if (this.debugEnabled) {
                Tr.debug(tc, "Extracting to   " + file + ", under: " + file.getParentFile() + ", size = " + documentContentSource.getSource().available());
            }
            fileOutputStream = (FileOutputStream)fileAccessor.getOutputStream(string);
            if (bl) {
                if (this.debugEnabled) {
                    Tr.debug(tc, "\tKeep original ");
                }
                fileOutputStream2 = (FileOutputStream)fileAccessor.getOutputStream(string + ORIG_SUFFIX);
            }
            InputStream inputStream = documentContentSource.getSource();
            byte[] byArray = new byte[4096];
            int n = inputStream.read(byArray);
            while (n != -1) {
                fileOutputStream.write(byArray, 0, n);
                if (fileOutputStream2 != null) {
                    fileOutputStream2.write(byArray, 0, n);
                }
                n = inputStream.read(byArray);
            }
            inputStream.close();
            fileOutputStream.flush();
            fileOutputStream.close();
            if (fileOutputStream2 != null) {
                fileOutputStream2.flush();
                fileOutputStream2.close();
            }
            this.setDigest(fileAccessor, string + DIGEST_SUFFIX, documentContentSource.getDocument().getDigest());
        }
        catch (IOException iOException) {
            throw WorkSpaceLogger.createException(tc, "WKSP0012E Exception when while extracting {0} from Config Repository--{1}", new Object[]{string2, iOException}, iOException);
        }
        catch (RepositoryException repositoryException) {
            throw WorkSpaceLogger.createException(tc, "WKSP0012E Exception when while extracting {0} from Config Repository--{1}", new Object[]{string2, repositoryException}, repositoryException);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (fileOutputStream2 != null) {
                    fileOutputStream2.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extract (file: " + workSpaceFile + ", target: " + string + ", needCopy: " + bl + ")");
        }
    }

    private boolean needMerge(WorkSpaceFile workSpaceFile) {
        return workSpaceFile.getName().equalsIgnoreCase(SERVER_INDEX_NAME);
    }

    private void setDigest(FileAccessor fileAccessor, String string, DocumentDigest documentDigest) throws WorkSpaceException {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileAccessor.getOutputStream(string));
            objectOutputStream.writeObject(documentDigest);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            throw WorkSpaceLogger.createException(tc, "WKSP0017E Error keep digest for {0}:{1} --{2}", new Object[]{string, documentDigest, exception}, exception);
        }
    }

    public void release(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        if (this.debugEnabled) {
            Tr.debug(tc, "release: " + workSpaceFile.getPath());
        }
        RepositoryContext repositoryContext = workSpaceFile.getContext();
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)repositoryContext.getWorkSpace();
        FileAccessor fileAccessor = workSpaceImpl.getFileAccessor();
        FileAccessorUtil.delete(fileAccessor, workSpaceFile.getURI());
        FileAccessorUtil.delete(fileAccessor, workSpaceFile.getURI() + DIGEST_SUFFIX);
        if (FileAccessorUtil.exist(fileAccessor, workSpaceFile.getURI() + ORIG_SUFFIX)) {
            ((WorkSpaceResourceSet)workSpaceFile.getContext().getResourceSet()).release(workSpaceFile.getName() + ORIG_SUFFIX);
            FileAccessorUtil.delete(fileAccessor, workSpaceFile.getURI() + ORIG_SUFFIX);
        }
        if (FileAccessorUtil.exist(fileAccessor, workSpaceFile.getURI() + CURRENT_SUFFIX)) {
            ((WorkSpaceResourceSet)workSpaceFile.getContext().getResourceSet()).release(workSpaceFile.getName() + CURRENT_SUFFIX);
            FileAccessorUtil.delete(fileAccessor, workSpaceFile.getURI() + CURRENT_SUFFIX);
        }
        FileAccessorUtil.delete(fileAccessor, workSpaceFile.getURI() + CURRENT_SUFFIX + DIGEST_SUFFIX);
    }

    public void release(RepositoryContext repositoryContext) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "release (context: " + repositoryContext + ")");
        }
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)repositoryContext.getWorkSpace();
        FileAccessor fileAccessor = workSpaceImpl.getFileAccessor();
        FileAccessorUtil.deleteTree(fileAccessor, repositoryContext.getURI());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "release (context: " + repositoryContext + ")");
        }
    }

    public void delete(RepositoryContext repositoryContext) throws WorkSpaceException {
    }

    public void delete(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delete (file: " + workSpaceFile + ")");
        }
        RepositoryContext repositoryContext = workSpaceFile.getContext();
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)repositoryContext.getWorkSpace();
        FileAccessor fileAccessor = workSpaceImpl.getFileAccessor();
        FileAccessorUtil.delete(fileAccessor, workSpaceFile.getURI());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "delete (file: " + workSpaceFile + ")");
        }
    }

    public void setSessionId(WorkSpace workSpace) throws WorkSpaceException {
        this.createSessionIdFile(workSpace);
    }

    public void unsetSessionId(WorkSpace workSpace) throws WorkSpaceException {
        this.deleteSessionIdFile(workSpace);
    }

    public boolean isValid(WorkSpace workSpace) throws WorkSpaceException {
        try {
            FileAccessor fileAccessor = ((WorkSpaceImpl)workSpace).getFileAccessor();
            String string = this.getSessionIdFilePath(workSpace);
            return FileAccessorUtil.exist(fileAccessor, string);
        }
        catch (Exception exception) {
            throw new WorkSpaceException("Exception in isValid workspace ", exception);
        }
    }

    private String getSessionIdFilePath(WorkSpace workSpace) {
        return SESSION_ID_FILE_PREFIX + workSpace.getSessionId();
    }

    private void createSessionIdFile(WorkSpace workSpace) throws WorkSpaceException {
        FileAccessor fileAccessor = ((WorkSpaceImpl)workSpace).getFileAccessor();
        String string = this.getSessionIdFilePath(workSpace);
        try {
            Object object;
            if (!FileAccessorUtil.exist(fileAccessor, "")) {
                FileAccessorUtil.makeDir(fileAccessor, "");
            } else {
                object = FileAccessorUtil.listFiles(fileAccessor, "", 1, 1);
                for (int i = 0; i < object.size(); ++i) {
                    String string2 = (String)object.get(i);
                    if (!string2.startsWith(SESSION_ID_FILE_PREFIX)) continue;
                    FileAccessorUtil.delete(fileAccessor, string2);
                }
            }
            FileAccessorUtil.createNewFile(fileAccessor, string);
            object = null;
            try {
                object = (FileOutputStream)fileAccessor.getOutputStream(string);
                byte[] byArray = ((WorkSpaceImpl)workSpace).getCallerInfo().getBytes();
                ((FileOutputStream)object).write(byArray);
            }
            catch (IOException iOException) {
                throw WorkSpaceLogger.createException(tc, "WKSP0011E Unable to create existing session id file {0} --{1}", new Object[]{string, iOException}, iOException);
            }
            finally {
                try {
                    if (object != null) {
                        ((OutputStream)object).flush();
                        ((FileOutputStream)object).close();
                    }
                    ((WorkSpaceImpl)workSpace).setCallerInfo("");
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            throw WorkSpaceLogger.createException(tc, "WKSP0011E Unable to create existing session id file {0} --{1}", new Object[]{string, iOException}, iOException);
        }
    }

    private void deleteSessionIdFile(WorkSpace workSpace) {
        try {
            FileAccessor fileAccessor = ((WorkSpaceImpl)workSpace).getFileAccessor();
            String string = this.getSessionIdFilePath(workSpace);
            fileAccessor.delete(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initialize(Properties properties) throws WorkSpaceException {
        this.setRepositoryProp(properties);
    }

    private static void initialize() throws WorkSpaceException {
        if (!init) {
            try {
                Properties properties = new Properties();
                ConfigRepositoryFactory.getConfigRepository().initialize(properties);
            }
            catch (Exception exception) {
                WorkSpaceLogger.createException(tc, "WKSP0000E Error initialize  -- {0}", new Object[]{exception}, exception);
            }
            init = true;
        }
    }

    private void setRepositoryProp(Properties properties) {
        this.repositoryProp = properties;
        this.configRepository = null;
    }

    public void remove(WorkSpace workSpace) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "remove (wsUserPath: " + workSpace.getUserPath() + ")");
        }
        try {
            FileAccessor fileAccessor = ((WorkSpaceImpl)workSpace).getFileAccessor();
            FileAccessorUtil.deleteTree(fileAccessor, "");
            FileAccessorUtil.deleteUserPath(fileAccessor, workSpace.getUserPath());
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove workspace repository failed ");
            }
            throw new WorkSpaceException("remove failed", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "remove (wsUserPath: " + workSpace.getUserPath() + ")");
        }
    }

    public void save(RepositoryContext repositoryContext) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save (context: \"" + repositoryContext + "\")");
        }
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)repositoryContext.getWorkSpace();
        FileAccessor fileAccessor = workSpaceImpl.getFileAccessor();
        String string = repositoryContext.getURI();
        OutputStream outputStream = null;
        String string2 = string.length() == 0 ? WORKSPACE_REPOSITORY : string + File.separator + WORKSPACE_REPOSITORY;
        String string3 = FileAccessorUtil.getFullPath(fileAccessor, string2.replace('/', File.separatorChar));
        try {
            FileAccessorUtil.makeDir(fileAccessor, string);
            if (!FileAccessorUtil.exist(fileAccessor, string2)) {
                FileAccessorUtil.createNewFile(fileAccessor, string2);
            }
            outputStream = (FileOutputStream)fileAccessor.getOutputStream(string2);
            byte[] byArray = repositoryContext.getPersistData().getBytes();
            ((FileOutputStream)outputStream).write(byArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Context Saved: (" + repositoryContext.getState() + ") " + string3);
            }
        }
        catch (IOException iOException) {
            if (iOException instanceof FileNotFoundException) {
                try {
                    WorkSpaceMasterRepositoryAdapter.checkURILength(string3);
                }
                catch (IOException iOException2) {
                    throw WorkSpaceLogger.createException(tc, "WKSP0006E Error while saving context {0}-{1}", new Object[]{repositoryContext.getName(), iOException2}, iOException);
                }
            }
            throw WorkSpaceLogger.createException(tc, "WKSP0006E Error while saving context {0}-{1}", new Object[]{repositoryContext.getName(), iOException}, iOException);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.flush();
                    ((FileOutputStream)outputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save (context: \"" + repositoryContext + "\")");
        }
    }

    public static void checkURILength(String string) throws IOException {
        int n = 259;
    }

    public String restore(RepositoryContext repositoryContext) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restore (context: \"" + repositoryContext + "\")");
        }
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)repositoryContext.getWorkSpace();
        FileAccessor fileAccessor = workSpaceImpl.getFileAccessor();
        String string = null;
        String string2 = repositoryContext.getURI().length() == 0 ? WORKSPACE_REPOSITORY : repositoryContext.getURI() + File.separator + WORKSPACE_REPOSITORY;
        BufferedReader bufferedReader = null;
        InputStream inputStream = null;
        try {
            if (FileAccessorUtil.exist(fileAccessor, string2)) {
                inputStream = fileAccessor.load(string2);
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            throw WorkSpaceLogger.createException(tc, "WKSP0001E Error reading serialized context from {0} -- {1}", new Object[]{string2, iOException}, iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restore (context: \"" + repositoryContext + "\"), value: " + string);
        }
        return string;
    }

    private Object collectFile(WorkSpaceFile workSpaceFile, Integer n) throws WorkSpaceException {
        RepositoryContext repositoryContext = workSpaceFile.getContext();
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)repositoryContext.getWorkSpace();
        FileAccessor fileAccessor = workSpaceImpl.getFileAccessor();
        Document document = this.getDocument(workSpaceFile);
        Serializable serializable = null;
        if (n != null && n == ConflictResolution.OVER_WRITE) {
            document.setOverwrite(true);
        }
        if (workSpaceFile.getState() == WorkSpaceFileState.ADDED) {
            serializable = this.getDocumentContentSource(fileAccessor, document, workSpaceFile.getURI());
        } else if (workSpaceFile.getState() == WorkSpaceFileState.UPDATED) {
            String string = null;
            if (this.needMerge(workSpaceFile) && !FileAccessorUtil.exist(fileAccessor, string = workSpaceFile.getURI() + CURRENT_SUFFIX)) {
                string = null;
            }
            if (string == null) {
                string = workSpaceFile.getURI();
            }
            if (this.debugEnabled) {
                Tr.debug(tc, "Source version: " + string);
            }
            serializable = this.getDocumentContentSource(fileAccessor, document, string);
        } else {
            serializable = document;
        }
        return serializable;
    }

    private Integer checkMerge(WorkSpaceFile workSpaceFile, Integer n) throws WorkSpaceException {
        Integer n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkMerge (file: \"" + workSpaceFile.getURI() + "\", conflictState: " + n + ")");
        }
        RepositoryContext repositoryContext = workSpaceFile.getContext();
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)repositoryContext.getWorkSpace();
        FileAccessor fileAccessor = workSpaceImpl.getFileAccessor();
        if (!this.needMerge(workSpaceFile)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkMerge return conflictState = " + n);
            }
            return n;
        }
        RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)workSpaceFile.getContext();
        repositoryContextImpl.resetAdapterNotifier(false);
        this.extract(workSpaceFile, workSpaceFile.getURI() + CURRENT_SUFFIX, false);
        String string = workSpaceFile.getName();
        if (MergeUtilManager.getUtil(workSpaceFile).merge(workSpaceFile.getContext(), string, string + ORIG_SUFFIX, string + CURRENT_SUFFIX)) {
            if (this.debugEnabled) {
                Tr.debug(tc, "Can be merged:" + string);
            }
            n2 = ConflictState.UN_MODIFIED;
        } else {
            if (this.debugEnabled) {
                Tr.debug(tc, "Can not be merged:" + string);
            }
            FileAccessorUtil.delete(fileAccessor, workSpaceFile.getURI() + CURRENT_SUFFIX);
            FileAccessorUtil.delete(fileAccessor, workSpaceFile.getURI() + CURRENT_SUFFIX + DIGEST_SUFFIX);
            n2 = ConflictState.MODIFIED;
        }
        repositoryContextImpl.resetAdapterNotifier(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkMerge return conflictState = " + n2);
        }
        return n2;
    }

    private Integer checkMergeForRefresh(WorkSpaceFile workSpaceFile, Integer n) throws WorkSpaceException {
        Integer n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkMergeForRefresh (file: \"" + workSpaceFile.getURI() + "\", conflictState: " + n + ")");
        }
        RepositoryContext repositoryContext = workSpaceFile.getContext();
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)repositoryContext.getWorkSpace();
        FileAccessor fileAccessor = workSpaceImpl.getFileAccessor();
        if (!this.needMerge(workSpaceFile)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkMergeForRefresh return conflictState = " + n);
            }
            return n;
        }
        RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)workSpaceFile.getContext();
        repositoryContextImpl.resetAdapterNotifier(false);
        this.extract(workSpaceFile, workSpaceFile.getURI() + CURRENT_SUFFIX, false);
        String string = workSpaceFile.getName();
        if (MergeUtilManager.getUtil(workSpaceFile).merge(workSpaceFile.getContext(), string, string + ORIG_SUFFIX, string + CURRENT_SUFFIX)) {
            if (this.debugEnabled) {
                Tr.debug(tc, "Can be merged:" + string);
            }
            n2 = ConflictState.MODIFIED;
        } else {
            if (this.debugEnabled) {
                Tr.debug(tc, "Can not be merged:" + string);
            }
            FileAccessorUtil.delete(fileAccessor, workSpaceFile.getURI() + CURRENT_SUFFIX);
            FileAccessorUtil.delete(fileAccessor, workSpaceFile.getURI() + CURRENT_SUFFIX + DIGEST_SUFFIX);
            n2 = ConflictState.MODIFIED;
        }
        repositoryContextImpl.resetAdapterNotifier(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkMergeForRefresh return conflictState = " + n2);
        }
        return n2;
    }

    private InputStream readFile(FileAccessor fileAccessor, String string) throws IOException {
        Object object;
        RepositoryInputStream repositoryInputStream = null;
        if (fileAccessor instanceof DefaultFileAccessor) {
            object = ((DefaultFileAccessor)fileAccessor).getRootDir();
            File file = new File(((File)object).getPath() + File.separator + string);
            repositoryInputStream = new RepositoryInputStream(file);
        } else {
            repositoryInputStream = new RepositoryInputStream();
        }
        object = fileAccessor.load(string);
        repositoryInputStream.setStream((InputStream)object);
        return repositoryInputStream;
    }

    private DocumentContentSource getDocumentContentSource(FileAccessor fileAccessor, Document document, String string) throws WorkSpaceException {
        try {
            if (fileAccessor instanceof DefaultFileAccessor) {
                return new DocumentContentSource(document, this.getFile((DefaultFileAccessor)fileAccessor, string));
            }
            return new DocumentContentSource(document, this.readFile(fileAccessor, string));
        }
        catch (IOException iOException) {
            throw WorkSpaceLogger.createException(tc, "WKSP0018E Error read file for {0} --{1}", new Object[]{string, iOException}, iOException);
        }
    }

    private File getFile(DefaultFileAccessor defaultFileAccessor, String string) throws IOException {
        File file = defaultFileAccessor.getRootDir();
        File file2 = new File(file.getPath() + File.separator + string);
        return file2;
    }

    private Document getDocument(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        Document document = workSpaceFile.getState() == WorkSpaceFileState.ADDED ? new Document(workSpaceFile.getURI()) : new Document(workSpaceFile.getURI(), this.getDigest(workSpaceFile));
        return document;
    }

    public RepositoryMetaData getMetaData() {
        return this.getDefaultMetaData();
    }

    static {
        init = false;
        defaultMetaData = null;
    }

    private class SessionIdFileFilter
    implements FilenameFilter {
        private SessionIdFileFilter() {
        }

        public boolean accept(File file, String string) {
            return string.startsWith(WorkSpaceMasterRepositoryAdapter.SESSION_ID_FILE_PREFIX);
        }
    }
}

