/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.MetadataNotAvailableException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.repository.ConfigStructureHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceEvent;
import com.ibm.ws.sm.workspace.WorkSpaceListener;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.WorkSpacePersistentObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;

public class WorkspaceMetadataAccessor
implements ManagedObjectMetadataAccessor,
WorkSpaceListener {
    private static TraceComponent _tc = Tr.register(WorkspaceMetadataAccessor.class, "Admin", null);
    private static String METADATA_FILE_URI_SUFFIX = "/node-metadata.properties";
    private static HashMap _accessorCache = new HashMap();
    private WorkSpace _ws;
    private String _userName;
    private HashMap _metadataCache = new HashMap();

    public static ManagedObjectMetadataAccessor createAccessor(String string) throws Exception {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "creating metadata accessor", "userName=" + string);
        }
        ManagedObjectMetadataAccessor managedObjectMetadataAccessor = WorkspaceMetadataAccessor.getCachedOrCreateNewAccessor(string);
        return managedObjectMetadataAccessor;
    }

    public WorkspaceMetadataAccessor(WorkSpace workSpace, Properties properties) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WorkspaceMetadataAccessor", new Object[]{workSpace, properties});
        }
        this._ws = workSpace;
        this._userName = this._ws.getUserName();
        this._ws.addWorkSpaceListener(this);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WorkspaceMetadataAccessor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getMetadataProperties(String string) throws AdminException {
        Properties properties;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getMetadataProperties", new String[]{"userName=" + this._userName, "nodeName=" + string});
        }
        HashMap hashMap = this._metadataCache;
        synchronized (hashMap) {
            properties = (Properties)this._metadataCache.get(string);
        }
        if (properties == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getMetadataProperties", "Properties not cached.");
            }
            properties = this.extractMetadata(string);
            this.addMetadataToCache(string, properties);
        }
        properties = (Properties)properties.clone();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getMetadataProperties", "props=" + properties);
        }
        return properties;
    }

    public String getMetadataProperty(String string, String string2) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getMetadataProperty", new String[]{"userName=" + this._userName, "nodeName=" + string, "propName=" + string2});
        }
        Properties properties = this.getMetadataProperties(string);
        String string3 = properties.getProperty(string2);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getMetadataProperty", string2 + "=" + string3);
        }
        return string3;
    }

    public void handle(WorkSpaceEvent workSpaceEvent) {
        int n = workSpaceEvent.getType();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "handle", new String[]{"userName=" + this._userName, "eventType=" + n});
        }
        if (n == 22 || n == 21 || n == 11) {
            WorkSpacePersistentObject workSpacePersistentObject = (WorkSpacePersistentObject)workSpaceEvent.getSource();
            String string = workSpacePersistentObject.getURI();
            if (!(n != 22 && n != 21 || string.endsWith(METADATA_FILE_URI_SUFFIX))) {
                return;
            }
            String string2 = ConfigStructureHelper.nodeNameForDoc(string);
            if (string2 != null && string.startsWith("cells/") && string.indexOf("/servers/") == -1 && !string.endsWith("/servers")) {
                this.removeMetadataFromCache(string2);
            }
        } else if (n == 0) {
            WorkspaceMetadataAccessor.removeAccessorFromCache(this._userName);
        }
    }

    private Properties extractMetadata(String string) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "extractMetadata");
        }
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            Object object;
            AdminService adminService = AdminServiceFactory.getAdminService();
            RepositoryContext repositoryContext = null;
            if (adminService != null) {
                object = adminService.getCellName();
                repositoryContext = this._ws.getRootContext().findContext("cells/" + (String)object + "/nodes/" + string);
            } else {
                object = this._ws.getRootContext().findContext("nodes", string);
                if (object.size() != 0) {
                    repositoryContext = (RepositoryContext)object.iterator().next();
                }
            }
            if (repositoryContext == null) {
                object = new MetadataNotAvailableException("specified node name is not valid: " + string);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "extractMetadata", object);
                }
                throw object;
            }
            inputStream = repositoryContext.getInputStream("node-metadata.properties");
            properties.load(inputStream);
        }
        catch (MetadataNotAvailableException metadataNotAvailableException) {
            throw metadataNotAvailableException;
        }
        catch (Throwable throwable) {
            MetadataNotAvailableException metadataNotAvailableException = new MetadataNotAvailableException(throwable, "Unexpected exception received while extracting metadata from the workspace" + this._ws.getUserName());
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "extractMetadata: Unexpected exception: ", metadataNotAvailableException);
            }
            throw metadataNotAvailableException;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.sm.workspace.impl.WorkspaceMetadataAccessor", "149");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "extractMetadata");
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMetadataToCache(String string, Properties properties) {
        HashMap hashMap = this._metadataCache;
        synchronized (hashMap) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Adding metadata to cache: nodeName=" + string);
            }
            this._metadataCache.put(string, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMetadataFromCache(String string) {
        HashMap hashMap = this._metadataCache;
        synchronized (hashMap) {
            Object v = this._metadataCache.remove(string);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Removed metadata from cache:", new String[]{"nodeName=" + string, "metadata=" + v});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ManagedObjectMetadataAccessor getCachedOrCreateNewAccessor(String string) throws Exception {
        ManagedObjectMetadataAccessor managedObjectMetadataAccessor = null;
        try {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getCachedOrCreateNewAccessor", "userName=" + string);
            }
            WorkSpace workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(string);
            HashMap hashMap = _accessorCache;
            synchronized (hashMap) {
                managedObjectMetadataAccessor = (ManagedObjectMetadataAccessor)_accessorCache.get(string);
                if (managedObjectMetadataAccessor == null) {
                    managedObjectMetadataAccessor = workSpace.getManagedObjectMetadataAccessor();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Adding to accessor cache: userName=" + string);
                    }
                    _accessorCache.put(string, managedObjectMetadataAccessor);
                }
            }
        }
        catch (Exception exception) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getCachedOrCreateNewAccessor: Exception:", exception);
            }
            throw exception;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCachedOrCreateNewAccessor", "accessor=" + managedObjectMetadataAccessor);
        }
        return managedObjectMetadataAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeAccessorFromCache(String string) {
        HashMap hashMap = _accessorCache;
        synchronized (hashMap) {
            Object v = _accessorCache.remove(string);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Removed from accessor cache:", new String[]{"userName=" + string, "accessor=" + v});
            }
        }
    }
}

