/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.merger.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.impl.RepositoryContextImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.merger.MergeUtil;
import com.ibm.ws.sm.workspace.util.ServerIndexUtil;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ServerIndexMerger
implements MergeUtil {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(ServerIndexMerger.class);
    private static String ERROR_LOAD_RESOURCE = "WKSP1001E: Error loading resource {0} for context {1} --{2}";
    private static String ERROR_SAVE_RESOURCE = "WKSP1002E: Error saving resource {0} --{1}";
    private static String ERROR_MERGE_RESOURCE = "WKSP1003E: Error merging resource {0} for context {1} ";
    private static String ERROR_SERVERENTRY = "WKSP1004E: Error - ServerEntry {0} does not have a corresponding server in the configuration.";
    private static String ERROR_APPDEPLOYMENT = "WKSP1005E: Error - DeployedApplication {0} does not have a corresponding deployment.xml in the configuration.";
    private ServerIndexUtil util = new ServerIndexUtil();

    public boolean merge(RepositoryContext repositoryContext, String string, String string2, String string3) throws WorkSpaceException {
        ServerIndex serverIndex = this.getObject(repositoryContext, string);
        ServerIndex serverIndex2 = this.getObject(repositoryContext, string2);
        ServerIndex serverIndex3 = this.getObject(repositoryContext, string3);
        boolean bl = this.util.mergeDocuments(serverIndex2, serverIndex, serverIndex3);
        Tr.debug(tc, "merge status: " + bl);
        if (bl) {
            this.saveObject(serverIndex3);
        }
        return bl;
    }

    private ServerIndex getObject(RepositoryContext repositoryContext, String string) throws WorkSpaceException {
        try {
            Resource resource = repositoryContext.getResourceSet().getResource(URI.createURI((String)string), true);
            if (resource == null) {
                return null;
            }
            return (ServerIndex)resource.getContents().iterator().next();
        }
        catch (Exception exception) {
            throw WorkSpaceLogger.createException(tc, ERROR_LOAD_RESOURCE, new Object[]{string, repositoryContext.getURI(), exception}, exception);
        }
    }

    private void saveObject(ServerIndex serverIndex) throws WorkSpaceException {
        try {
            serverIndex.eResource().save(new HashMap());
        }
        catch (Exception exception) {
            throw WorkSpaceLogger.createException(tc, ERROR_SAVE_RESOURCE, new Object[]{serverIndex, exception}, exception);
        }
    }

    public void selfCorrect(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        boolean bl = false;
        RepositoryContext repositoryContext = workSpaceFile.getContext();
        ServerIndex serverIndex = this.getObject(repositoryContext, workSpaceFile.getFileName());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "selfCorrect: getObject(context: " + repositoryContext + ", file: " + workSpaceFile + ") return si: " + serverIndex);
        }
        if (serverIndex == null) {
            return;
        }
        EList eList = serverIndex.getServerEntries();
        EList eList2 = serverIndex.getEndPointRefs();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "EndPointRefs #1 = " + eList2);
        }
        for (int i = 0; i < eList.size(); ++i) {
            Object object;
            String string;
            Object object2;
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            String string2 = serverEntry.getServerName();
            EList eList3 = serverEntry.getSpecialEndpoints();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2 + " SpecialEndpoints #1 = " + eList3);
            }
            try {
                object2 = (Server)this.getContentObject(repositoryContext, "servers/" + string2 + "/server.xml");
            }
            catch (Exception exception) {
                string = repositoryContext.getURI() + "/servers/" + string2 + "/server.xml";
                if (((RepositoryContextImpl)repositoryContext).getRepositoryAdapter().exist(repositoryContext.getWorkSpace(), string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "selfCorrect: Found " + string + " in the master config repository, leave it as is.");
                    }
                }
                bl = true;
                object = WorkSpaceLogger.createException(tc, ERROR_SERVERENTRY, new Object[]{string2}, exception);
                FFDCFilter.processException((Throwable)object, "com.ibm.ws.sm.workspace.merger.impl.ServerIndexMerger.selfCorrect", "100");
                Tr.warning(tc, "ServerEntry without corresponding server in the configuration: " + string2);
                eList.remove(i);
                --i;
                eList2.removeAll((Collection)eList3);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "EndPointRefs #2 = " + eList2);
                Tr.debug(tc, string2 + " SpecialEndpoints #2 = " + eList3);
                continue;
            }
            object2 = repositoryContext.getParent();
            string = null;
            object = serverEntry.getDeployedApplications();
            for (int j = 0; j < object.size(); ++j) {
                string = "applications/" + (String)object.get(j);
                string = string + "/deployment.xml";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "selfCorrect: Checking deployment.xml for Server: " + string2 + ", App: " + string);
                }
                try {
                    Deployment deployment = (Deployment)this.getContentObject((RepositoryContext)object2, string);
                    continue;
                }
                catch (Exception exception) {
                    String string3 = object2.getURI() + "/" + string;
                    if (((RepositoryContextImpl)object2).getRepositoryAdapter().exist(object2.getWorkSpace(), string3)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "selfCorrect: Found " + string3 + " in the master config repository, leave it as it.");
                        continue;
                    }
                    bl = true;
                    WorkSpaceException workSpaceException = WorkSpaceLogger.createException(tc, ERROR_APPDEPLOYMENT, new Object[]{(String)object.get(j)}, exception);
                    FFDCFilter.processException(workSpaceException, "com.ibm.ws.sm.workspace.merger.impl.ServerIndexMerger.selfCorrect", "121");
                    Tr.warning(tc, "DeployedApplication without corresponding deployment.xml in the configuration: " + (String)object.get(j));
                    object.remove(j);
                    --j;
                }
            }
        }
        if (bl) {
            this.saveObject(serverIndex);
        }
    }

    private synchronized Object getContentObject(RepositoryContext repositoryContext, String string) throws WorkSpaceException {
        Object e2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContentObject (context: " + repositoryContext + ", uri: " + string + ")");
        }
        try {
            Resource resource = repositoryContext.getResourceSet().getResource(URI.createURI((String)string), true);
            e2 = resource.getContents().iterator().next();
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Can not find corresponding " + string + " in the configuration.");
            }
            throw nullPointerException;
        }
        catch (Exception exception) {
            throw WorkSpaceLogger.createException(tc, ERROR_LOAD_RESOURCE, new Object[]{string, repositoryContext.getURI(), exception}, exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContentObject (context: " + repositoryContext + ", uri: " + string + ") return object: " + e2);
        }
        return e2;
    }
}

