/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.migration;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.impl.WorkSpaceResourceSet;
import com.ibm.ws.sm.workspace.migration.MOFContext;
import com.ibm.ws.sm.workspace.migration.WSURIConverter;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;

public final class WSResourceSetImpl
extends WASResourceSetImpl
implements WorkSpaceResourceSet {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(WSResourceSetImpl.class);
    private RepositoryContext context;
    private boolean adapterNotifierOn = true;

    public WSResourceSetImpl(MOFContext mOFContext) {
        this.context = (RepositoryContext)mOFContext;
    }

    public RepositoryContext getContext() {
        return this.context;
    }

    public Notifier getTarget() {
        return this;
    }

    public void setTarget(Notifier notifier) {
    }

    public boolean isAdapterForType(Object object) {
        return true;
    }

    public synchronized void notifyChanged(Notification notification) {
        if (this.adapterNotifierOn) {
            try {
                int n = notification.getEventType();
                if (n == 3) {
                    Resource resource = (Resource)notification.getNewValue();
                    String string = resource.getURI().toFileString();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "notify ADD:" + string);
                    }
                    if (string != null) {
                        this.context.notifyChanged(0, string);
                    }
                }
            }
            catch (WorkSpaceException workSpaceException) {
                workSpaceException.printStackTrace();
            }
        }
    }

    public void setAdapterNotifier(boolean bl) {
        this.adapterNotifierOn = bl;
    }

    public void release(String string) {
        URI uRI = URI.createURI((String)string);
        Resource resource = null;
        try {
            resource = this.getResource(uRI, false);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (resource != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Releasing resource = " + string + " for " + this.context.getURI());
            }
            this.getResources().remove((Object)resource);
        }
    }

    public void refreshPath() {
        WSURIConverter wSURIConverter = new WSURIConverter(this.context);
        this.setURIConverter((URIConverter)wSURIConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getResource(URI uRI, boolean bl) {
        String string;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getResource: " + uRI + ", loadOnDemand: " + bl);
        }
        if ((string = uRI.scheme()) != null && string.equals("java")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getResource: java URI:" + uRI);
            }
            return null;
        }
        if (!bl) {
            return super.getResource(uRI, bl);
        }
        try {
            String string2 = uRI.toString();
            RepositoryContext repositoryContext = this.context.findContext(string2);
            if (repositoryContext != null && repositoryContext != this.context) {
                String string3 = repositoryContext.getURI();
                String string4 = this.context.getURI();
                int n = string3.length() - string4.length();
                if (string4.length() == 0) {
                    ++n;
                }
                String string5 = string2.substring(n);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "old context: " + string4 + ", old uri: " + string2);
                    Tr.debug(tc, "new context: " + string3 + ", new uri: " + string5);
                }
                return repositoryContext.getResourceSet().getResource(URI.createURI((String)string5), bl);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Try to load local: " + this.context.getURI() + ", file: " + uRI);
            }
            Resource resource = null;
            InputStream inputStream = null;
            try {
                inputStream = this.getURIConverter().createInputStream(uRI);
                resource = super.getResource(uRI, bl);
                if (uRI.toString().equals("serverindex.xml.current") || uRI.toString().equals("serverindex.xml")) {
                    if (tc.isDebugEnabled()) {
                        this.dumpServerindexFile(inputStream, uRI);
                        this.showDeployedApps(resource, uRI.toString() + " 1st Try");
                    }
                    resource.unload();
                    resource = super.getResource(uRI, bl);
                    if (tc.isDebugEnabled()) {
                        this.showDeployedApps(resource, uRI.toString() + " 2nd Try");
                    }
                }
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got IOException in getResource(), so check for parent context. " + iOException);
                }
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (resource != null) {
                return resource;
            }
            if (this.context.getParent() != null) {
                return this.context.getParent().getResourceSet().getResource(uRI, bl);
            }
            return null;
        }
        catch (WorkSpaceException workSpaceException) {
            throw new WrappedException((Exception)workSpaceException);
        }
    }

    private void dumpServerindexFile(InputStream inputStream, URI uRI) throws IOException {
        byte[] byArray = new byte[2048];
        int n = inputStream.read(byArray);
        String string = new String(byArray);
        Tr.debug(tc, uRI + ":\n" + string);
    }

    private void showDeployedApps(Resource resource, String string) {
        ServerIndex serverIndex = (ServerIndex)resource.getContents().iterator().next();
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            EList eList2 = serverEntry.getDeployedApplications();
            Tr.debug(tc, "\n Context: " + this.context.getPath() + "\n docName: " + string + ", Server: " + serverEntry.getServerName() + "\n    Apps: " + eList2 + "\n");
        }
    }
}

