/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.template.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.resource.WASResourceImpl;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.template.RefObjectHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.wst.common.internal.emf.utilities.CopyGroup;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;
import org.eclipse.wst.common.internal.emf.utilities.IDUtil;

public class RefObjectHelperImpl
implements RefObjectHelper {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(RefObjectHelperImpl.class);
    static final URI TRANSIENT_RESOURCE_URI = URI.createURI((String)"tempworkarea.xmi");
    protected ResourceSet transientRS = new WASResourceSetImpl();
    protected XMIResource transientResource = new WASResourceImpl(TRANSIENT_RESOURCE_URI);

    public RefObjectHelperImpl() {
        this.transientRS.getResources().add((Object)this.transientResource);
    }

    public EObject clone(EObject eObject) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clone", new Object[]{eObject});
        }
        CopyGroup copyGroup = new CopyGroup();
        copyGroup.setPreserveIds(false);
        copyGroup.add(eObject);
        EtoolsCopyUtility.createCopy((CopyGroup)copyGroup);
        List list = copyGroup.getCopiedRefObjects();
        if (list.size() > 0) {
            return (EObject)list.get(0);
        }
        return null;
    }

    public Collection clone(Collection collection) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clone", new Object[]{collection});
        }
        CopyGroup copyGroup = new CopyGroup();
        copyGroup.setPreserveIds(false);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            copyGroup.add((EObject)iterator.next());
        }
        EtoolsCopyUtility.createCopy((CopyGroup)copyGroup);
        return copyGroup.getCopiedRefObjects();
    }

    public void refreshRefId(EObject eObject) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "refreshRefId", new Object[]{eObject});
        }
        this.refreshIdLocal(eObject);
        Iterator iterator = eObject.eContents().iterator();
        while (iterator.hasNext()) {
            this.refreshRefId((EObject)iterator.next());
        }
    }

    public void replicate(EObject eObject, Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = map.get(string);
            if (v instanceof List) {
                this.replicate(eObject, string, (List)v);
                continue;
            }
            EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(string);
            this.setFeature(eObject, eStructuralFeature, v);
        }
    }

    private void setFeature(EObject eObject, EStructuralFeature eStructuralFeature, Object object) {
        if (eStructuralFeature.isMany()) {
            ((EList)eObject.eGet(eStructuralFeature)).add(object);
        } else {
            eObject.eSet(eStructuralFeature, object);
        }
    }

    private void unsetFeature(EObject eObject, EStructuralFeature eStructuralFeature) {
        if (eStructuralFeature.isMany()) {
            ((EList)eObject.eGet(eStructuralFeature)).clear();
        } else {
            eObject.eUnset(eStructuralFeature);
        }
    }

    private void replicate(EObject eObject, String string, List list) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(string);
        this.unsetFeature(eObject, eStructuralFeature);
        Collection collection = this.clone(list);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.setFeature(eObject, eStructuralFeature, iterator.next());
        }
        this.refreshRefId(eObject);
    }

    public void unset(EObject eObject, String string) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(string);
        this.unsetFeature(eObject, eStructuralFeature);
    }

    public void set(EObject eObject, String string, Object object) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(string);
        this.setFeature(eObject, eStructuralFeature, object);
    }

    public EObject getTemporaryObject(String string) {
        URI uRI = URI.createURI((String)string);
        return this.transientRS.getEObject(uRI, true);
    }

    public String makeTemporary(EObject eObject) {
        this.transientResource.getContents().add((Object)eObject);
        this.refreshRefId(eObject);
        return this.makeHref(eObject);
    }

    public String makeHref(EObject eObject) {
        XMLResource xMLResource = (XMLResource)eObject.eResource();
        StringBuffer stringBuffer = new StringBuffer(xMLResource.getURI().toString());
        stringBuffer.append("#");
        stringBuffer.append(xMLResource.getID(eObject));
        return stringBuffer.toString();
    }

    public String getRefID(EObject eObject) {
        XMLResource xMLResource = (XMLResource)eObject.eResource();
        return xMLResource.getID(eObject);
    }

    private void refreshIdLocal(EObject eObject) {
        IDUtil.assignID((EObject)eObject);
    }
}

