/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class ServerIndexUtil {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(ServerIndexUtil.class);
    private static int NEW_ENTRY = 1;
    private static int MODIFIED_ENTRY = 2;
    private static int NOT_MODIFIED_ENTRY = 3;
    private static int DELETED_ENTRY = 4;
    private static String PROCESSED = "p";

    private void showDeployedApps(List list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)list.get(i);
            if (!serverEntry.getServerName().equals("server1")) continue;
            EList eList = serverEntry.getDeployedApplications();
            Tr.debug(tc, "\n " + string + ":\t" + eList);
        }
    }

    public boolean mergeDocuments(ServerIndex serverIndex, ServerIndex serverIndex2, ServerIndex serverIndex3) {
        int n;
        int n2;
        boolean bl = false;
        EList eList = serverIndex.getServerEntries();
        EList eList2 = serverIndex2.getServerEntries();
        EList eList3 = serverIndex3.getServerEntries();
        int n3 = eList.size();
        int n4 = eList2.size();
        int n5 = eList3.size();
        ServerEntry serverEntry = null;
        ServerEntry serverEntry2 = null;
        ServerEntry serverEntry3 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        HashMap<String, ServerEntryDelta> hashMap = new HashMap<String, ServerEntryDelta>();
        ServerEntryDelta serverEntryDelta = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Checking for hostname change conflict:");
        }
        if (!serverIndex3.getHostName().equals(serverIndex.getHostName()) && !serverIndex2.getHostName().equals(serverIndex.getHostName())) {
            bl = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CONFLICT! - Hostname was modified on local and current.");
            }
        }
        if (!bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Building original/current delta list:");
            }
            for (n2 = 0; n2 < n5; ++n2) {
                serverEntry2 = (ServerEntry)eList3.get(n2);
                string2 = serverEntry2.getServerName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing...currentServerName[" + n2 + "]=" + string2);
                }
                serverEntryDelta = new ServerEntryDelta(n2, NEW_ENTRY);
                hashMap.put(string2, serverEntryDelta);
                if (string4 != null || !serverEntry2.getServerType().equals("DEPLOYMENT_MANAGER") && !serverEntry2.getServerType().equals("NODE_AGENT")) continue;
                string4 = serverEntry2.getServerType();
            }
        }
        if (!bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Comparing original/current entries:");
            }
            for (n2 = 0; n2 < n3; ++n2) {
                serverEntry = (ServerEntry)eList.get(n2);
                string = serverEntry.getServerName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing...origServerName[" + n2 + "]=" + string);
                }
                if ((serverEntryDelta = (ServerEntryDelta)hashMap.get(string)) != null) {
                    if (this.equalsServerEntry((ServerEntry)eList3.get(serverEntryDelta.getIndex()), serverEntry)) {
                        serverEntryDelta.setStatus(NOT_MODIFIED_ENTRY);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Entry was not modified on current.");
                        continue;
                    }
                    serverEntryDelta.setStatus(MODIFIED_ENTRY);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Entry has been modified on current.");
                    continue;
                }
                serverEntryDelta = new ServerEntryDelta(0, DELETED_ENTRY);
                hashMap.put(string, serverEntryDelta);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Entry has been deleted on current.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Comparing local and original/current entries:");
            }
        }
        n2 = n3;
        boolean bl2 = false;
        int n6 = 0;
        for (int i = 0; i < n4 && !bl; ++i) {
            serverEntry3 = (ServerEntry)eList2.get(i);
            string3 = serverEntry3.getServerName();
            bl2 = false;
            for (n6 = 0; n6 < n3 && !bl2; ++n6) {
                serverEntry = (ServerEntry)eList.get(n6);
                string = serverEntry.getServerName();
                if (!string3.equals(string)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking for changes to server[" + string + "]");
                }
                --n2;
                serverEntry.setServerType(PROCESSED);
                n = !this.equalsServerEntry(serverEntry3, serverEntry) ? 1 : 0;
                List[] listArray = this.getDeltaApplications(serverEntry3, serverEntry);
                if (n || listArray != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Entry was modified on local.");
                    }
                    if ((serverEntryDelta = (ServerEntryDelta)hashMap.get(string3)) != null) {
                        int n7 = serverEntryDelta.getStatus();
                        if (n7 == MODIFIED_ENTRY && n || n7 == DELETED_ENTRY || n7 == NEW_ENTRY) {
                            bl = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "CONFLICT! - Entry was modified on local and current.");
                            }
                        } else {
                            ServerEntry serverEntry4;
                            int n8 = serverEntryDelta.getIndex();
                            serverEntry2 = (ServerEntry)eList3.get(n8);
                            List[] listArray2 = this.getDeltaApplications(serverEntry2, serverEntry);
                            if (n) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Local server entry NOT equal to original server entry, localChanged = " + (n != 0));
                                }
                                serverEntry4 = (ServerEntry)EtoolsCopyUtility.createCopy((EObject)serverEntry3);
                                bl = this.mergeApplChange(listArray2, listArray, serverEntry4);
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Local server entry equal to original server entry, localChanged = " + (n != 0));
                                }
                                serverEntry4 = serverEntry2;
                                bl = this.mergeApplChange(listArray, listArray2, serverEntry4);
                            }
                            if (!bl) {
                                if (tc.isDebugEnabled()) {
                                    if (n) {
                                        Tr.debug(tc, "Local entry changed(other than applicaton, so overwrite the server entry with the local one(with merged application.");
                                    } else {
                                        Tr.debug(tc, "Current entry changed(other than applicaton, so merge the local applicaiton to currentserver entry.");
                                    }
                                }
                                eList3.remove(n8);
                                eList3.add(n8, serverEntry4);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Entry was modified on local and not current - merge.");
                            }
                        }
                    } else {
                        bl = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "CONFLICT! - Entry was modified on local and deleted on current.");
                        }
                    }
                }
                bl2 = true;
            }
            if (bl2) continue;
            serverEntryDelta = (ServerEntryDelta)hashMap.get(string3);
            if (serverEntryDelta == null) {
                eList3.add(serverEntry3);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Entry was new on local - merge.");
                continue;
            }
            bl = true;
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "CONFLICT! - Entry was new on local and new on current.");
        }
        if (n2 != 0 && !bl) {
            for (n6 = 0; n6 < n3 && !bl; ++n6) {
                serverEntry = (ServerEntry)eList.get(n6);
                if (serverEntry.getServerType().equals(PROCESSED) || (serverEntryDelta = (ServerEntryDelta)hashMap.get(string = serverEntry.getServerName())) == null) continue;
                n = serverEntryDelta.getStatus();
                if (n == MODIFIED_ENTRY) {
                    bl = true;
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "CONFLICT! - Entry was deleted on local and modified on current.");
                    continue;
                }
                int n9 = serverEntryDelta.getIndex();
                eList3.remove(n9);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Entry was deleted on local and not modified on current.");
            }
        }
        if (!bl) {
            this.refactorDistinguishedEndpoints(serverIndex3, string4);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning - documents merged=" + !bl);
        }
        return !bl;
    }

    private boolean equalsServerEntry(ServerEntry serverEntry, ServerEntry serverEntry2) {
        boolean bl = true;
        if (serverEntry.getServerDisplayName() != null && serverEntry2.getServerDisplayName() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServerDisplayName is " + serverEntry.getServerDisplayName() + " and " + serverEntry2.getServerDisplayName());
            }
            if (!serverEntry.getServerDisplayName().equals(serverEntry2.getServerDisplayName())) {
                bl = false;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServerDisplayName is null");
            }
            if (serverEntry.getServerDisplayName() != null || serverEntry2.getServerDisplayName() != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Only One of the ServerDisplayName is null");
                }
                bl = false;
            }
        }
        if (bl && !serverEntry.getServerName().equals(serverEntry2.getServerName())) {
            bl = false;
        }
        int n = 0;
        int n2 = 0;
        if (bl) {
            EList eList = serverEntry.getSpecialEndpoints();
            EList eList2 = serverEntry2.getSpecialEndpoints();
            n = eList2.size();
            for (n2 = 0; n2 < eList.size(); ++n2) {
                NamedEndPoint namedEndPoint = (NamedEndPoint)eList.get(n2);
                String string = namedEndPoint.getEndPointName();
                EndPoint endPoint = namedEndPoint.getEndPoint();
                String string2 = endPoint.getHost();
                int n3 = endPoint.getPort();
                boolean bl2 = false;
                for (int i = 0; i < eList2.size() && !bl2; ++i) {
                    NamedEndPoint namedEndPoint2 = (NamedEndPoint)eList2.get(i);
                    String string3 = namedEndPoint2.getEndPointName();
                    if (!string.equals(string3)) continue;
                    EndPoint endPoint2 = namedEndPoint2.getEndPoint();
                    String string4 = endPoint2.getHost();
                    int n4 = endPoint2.getPort();
                    if (!string2.equals(string4) || n3 != n4) continue;
                    --n;
                    bl2 = true;
                }
            }
            if (n != 0) {
                bl = false;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning - equal=" + bl);
        }
        return bl;
    }

    private List[] getDeltaApplications(ServerEntry serverEntry, ServerEntry serverEntry2) {
        List[] listArray = new List[2];
        listArray[0] = new ArrayList(serverEntry.getDeployedApplications());
        listArray[0].removeAll((Collection<?>)serverEntry2.getDeployedApplications());
        listArray[1] = new ArrayList(serverEntry2.getDeployedApplications());
        listArray[1].removeAll((Collection<?>)serverEntry.getDeployedApplications());
        if (listArray[0].size() == 0 && listArray[1].size() == 0) {
            return null;
        }
        return listArray;
    }

    private boolean mergeApplChange(List[] listArray, List[] listArray2, ServerEntry serverEntry) {
        if (tc.isDebugEnabled()) {
            if (listArray != null) {
                Tr.debug(tc, "Changed apps:  Add: " + listArray[0] + ", Remove: " + listArray[1]);
            }
            if (listArray2 != null) {
                Tr.debug(tc, "Conflict apps: Add: " + listArray2[0] + ", Remove: " + listArray2[1]);
            }
            Tr.debug(tc, "ServerEntry: " + serverEntry);
        }
        if (listArray == null) {
            return false;
        }
        boolean bl = false;
        if (listArray2 != null) {
            for (int i = 0; i < 2 && !bl; ++i) {
                for (int j = 0; j < listArray[i].size() && !bl; ++j) {
                    String string = (String)listArray[i].get(j);
                    bl = listArray2[0].contains(string) || listArray2[1].contains(string);
                }
            }
        }
        if (!bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Merge applications without conflict.");
            }
            serverEntry.getDeployedApplications().addAll((Collection)listArray[0]);
            serverEntry.getDeployedApplications().removeAll((Collection)listArray[1]);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Can not merge applications as there is conflict.");
        }
        return bl;
    }

    private void refactorDistinguishedEndpoints(ServerIndex serverIndex, String string) {
        EList eList = serverIndex.getServerEntries();
        EList eList2 = serverIndex.getEndPointRefs();
        eList2.clear();
        boolean bl = false;
        for (int i = 0; i < eList.size() && !bl; ++i) {
            String string2;
            NamedEndPoint namedEndPoint;
            int n;
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            if (!serverEntry.getServerType().equals(string)) continue;
            EList eList3 = serverEntry.getSpecialEndpoints();
            if (string.equals("DEPLOYMENT_MANAGER")) {
                for (n = 0; n < eList3.size(); ++n) {
                    namedEndPoint = (NamedEndPoint)eList3.get(n);
                    string2 = namedEndPoint.getEndPointName();
                    if (!string2.equals("BOOTSTRAP_ADDRESS") && !string2.equals("CELL_DISCOVERY_ADDRESS") && !string2.equals("CELL_MULTICAST_DISCOVERY_ADDRESS") && !string2.equals("ORB_LISTENER_ADDRESS")) continue;
                    eList2.add(namedEndPoint);
                }
            } else if (string.equals("NODE_AGENT")) {
                for (n = 0; n < eList3.size(); ++n) {
                    namedEndPoint = (NamedEndPoint)eList3.get(n);
                    string2 = namedEndPoint.getEndPointName();
                    if (!string2.equals("NODE_DISCOVERY_ADDRESS") && !string2.equals("NODE_MULTICAST_DISCOVERY_ADDRESS") && !string2.equals("ORB_LISTENER_ADDRESS")) continue;
                    eList2.add(namedEndPoint);
                }
            }
            bl = true;
        }
    }

    class ServerEntryDelta {
        private int index;
        private int status;

        public ServerEntryDelta(int n, int n2) {
            this.index = n;
            this.status = n2;
        }

        public int getIndex() {
            return this.index;
        }

        public int getStatus() {
            return this.status;
        }

        public void setIndex(int n) {
            this.index = n;
        }

        public void setStatus(int n) {
            this.status = n;
        }
    }
}

