/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.soapchannel.acceptor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.soapchannel.acceptor.SOAPAcceptorConnectionLink;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.exception.BodyCompleteException;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.util.ArrayList;
import java.util.Iterator;

public class SACReadCallback
implements InterChannelCallback {
    private static final TraceComponent _tc = Tr.register(SACReadCallback.class, "SOAPChannel", "com.ibm.ws.soapchannel.resources.Messages");
    private static NLS _nls = null;
    private SOAPAcceptorConnectionLink link = null;
    private HttpInboundServiceContext isc = null;
    private VirtualConnection vc = null;
    private ArrayList bodyBuffers = null;
    private boolean haveAllBuffers = false;
    private int requestBytes;

    private static NLS getNLS() {
        if (_nls == null) {
            _nls = new NLS("com.ibm.ws.soapchannel.resources.Messages");
        }
        return _nls;
    }

    public void init(SOAPAcceptorConnectionLink sOAPAcceptorConnectionLink, HttpInboundServiceContext httpInboundServiceContext, VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "init");
        }
        this.link = sOAPAcceptorConnectionLink;
        this.isc = httpInboundServiceContext;
        this.vc = virtualConnection;
        this.bodyBuffers = new ArrayList();
        this.haveAllBuffers = false;
        this.requestBytes = 0;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "init");
        }
    }

    public ArrayList getRequestBodyBuffers() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getRequestBodyBuffers(): returning " + (this.bodyBuffers != null ? this.bodyBuffers.size() : 0) + " buffers.");
        }
        ArrayList arrayList = this.bodyBuffers;
        this.bodyBuffers = null;
        this.haveAllBuffers = false;
        this.requestBytes = 0;
        return arrayList;
    }

    public void readRequest() {
        String[] stringArray;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "readRequest");
        }
        try {
            while (!this.haveAllBuffers) {
                VirtualConnection virtualConnection = null;
                try {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Calling async getRequestBodyBuffer...");
                    }
                    if ((virtualConnection = this.isc.getRequestBodyBuffer(this, false)) == null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Callback will be used, bailing out now...");
                        }
                        return;
                    }
                }
                catch (BodyCompleteException bodyCompleteException) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Caught BodyCompleteException, we're done reading buffers...");
                    }
                    this.haveAllBuffers = true;
                    continue;
                }
                catch (Exception exception) {
                    this.haveAllBuffers = true;
                    Object[] objectArray = new String[]{exception.toString()};
                    String string = SACReadCallback.getNLS().getFormattedMessage("caughtException2", objectArray, "Caught unexpected exception from asynchronous getRequestBodyBuffers(): {0}");
                    Tr.error(_tc, "caughtException2", exception);
                    throw new RuntimeException(string, exception);
                }
                try {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Calling synchronous getRequestBodyBuffer...");
                    }
                    if ((stringArray = this.isc.getRequestBodyBuffer()) == null) {
                        this.haveAllBuffers = true;
                        if (!_tc.isDebugEnabled()) continue;
                        Tr.debug(_tc, "getRequestBodyBuffer() returned null, we're done!");
                        continue;
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Read in a buffer of length " + stringArray.remaining() + " bytes.");
                    }
                    this.bodyBuffers.add(stringArray);
                    this.requestBytes += stringArray.remaining();
                }
                catch (Exception exception) {
                    Object[] objectArray = new String[]{exception.toString()};
                    String string = SACReadCallback.getNLS().getFormattedMessage("caughtException3", objectArray, "Caught unexpected exception from synchronous getRequestBodyBuffers(): {0}");
                    Tr.error(_tc, "caughtException3", exception);
                    throw new RuntimeException(string, exception);
                }
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "We now have " + this.bodyBuffers.size() + " buffer(s) (" + this.requestBytes + " bytes) to process.");
            }
            this.link.requestReady(this.vc);
        }
        catch (Throwable throwable) {
            stringArray = new String[]{throwable.toString()};
            String string = SACReadCallback.getNLS().getFormattedMessage("caughtException", stringArray, "Caught unexpected exception: {0}");
            Tr.error(_tc, "caughtException", throwable);
            throw new RuntimeException(string, throwable);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "readRequest");
            }
        }
    }

    public void complete(VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "complete");
        }
        this.readRequest();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "complete");
        }
    }

    public void error(VirtualConnection virtualConnection, Throwable throwable) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "error");
        }
        Tr.error(_tc, "caughtException7", throwable);
        this.link.close(virtualConnection, (Exception)throwable);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "error");
        }
    }

    public void destroy() {
        ArrayList arrayList;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "destroy");
        }
        if ((arrayList = this.getRequestBodyBuffers()) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "About to release body buffers.");
            }
            this.releaseBodyBuffers(arrayList);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "destroy");
        }
    }

    private void releaseBodyBuffers(ArrayList arrayList) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "releaseBodyBuffers");
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            WsByteBuffer wsByteBuffer = (WsByteBuffer)iterator.next();
            wsByteBuffer.release();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "releaseBodyBuffers");
        }
    }
}

