/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.soapchannel.acceptor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.soapchannel.monitor.impl.SOAPByteBufferInputStream;
import com.ibm.ws.webcontainer.srt.http.HttpDate;
import com.ibm.ws.webcontainer.util.ArrayEnumeration;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.soapcontainer.SOAPRequest;
import com.ibm.wsspi.soapcontainer.SOAPResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.Cookie;

public class SACRequestImpl
implements SOAPRequest {
    private static final TraceComponent _tc = Tr.register(SACRequestImpl.class, "SOAPChannel", "com.ibm.ws.soapchannel.resources.Messages");
    private HttpInboundServiceContext isc = null;
    private HttpRequestMessage request = null;
    private SOAPResponse response = null;
    private String serverName = null;
    private int serverPort = -1;
    private SOAPByteBufferInputStream bbIS = null;
    private ArrayList bodyBuffers = null;

    public void init(HttpInboundServiceContext httpInboundServiceContext, ArrayList arrayList, SOAPResponse sOAPResponse) {
        this.isc = httpInboundServiceContext;
        this.response = sOAPResponse;
        this.request = this.isc.getRequest();
        this.bodyBuffers = arrayList;
        this.bbIS = new SOAPByteBufferInputStream(this.bodyBuffers);
    }

    public void destroy() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "destroy");
        }
        if (this.bodyBuffers != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Releasing body buffers...");
            }
            Iterator iterator = this.bodyBuffers.iterator();
            while (iterator.hasNext()) {
                WsByteBuffer wsByteBuffer = (WsByteBuffer)iterator.next();
                wsByteBuffer.release();
            }
            this.bodyBuffers = null;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "destroy");
        }
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public String getRequestPathInfo() {
        String string = this.request.getRequestURI();
        String string2 = string.substring(string.indexOf("/", 1));
        return string2;
    }

    public String getRequestURLAsString() {
        return this.request.getRequestURLAsString();
    }

    public String getRemoteUser() {
        return this.request.getHeaderAsString(HttpConstants.HDR_$WSRU);
    }

    public String getAuthType() {
        return this.request.getHeaderAsString(HttpConstants.HDR_$WSAT);
    }

    public String getHeader(String string) {
        return this.request.getHeaderAsString(string);
    }

    public Enumeration getHeaders(String string) {
        Vector vector = this.request.getHeaderStringValues(string);
        if (vector == null || vector.isEmpty()) {
            return new ArrayEnumeration(null);
        }
        return vector.elements();
    }

    public long getDateHeader(String string) {
        HttpDate httpDate = new HttpDate();
        String string2 = this.request.getHeaderAsString(string);
        if (string2 == null) {
            return -1L;
        }
        httpDate.parse(string2);
        return httpDate.getTime();
    }

    public int getIntHeader(String string) {
        String string2 = this.request.getHeaderAsString(string);
        if (string2 == null) {
            return -1;
        }
        return Integer.parseInt(string2);
    }

    public void clearHeaders() {
    }

    public Enumeration getHeaderNames() {
        return this.request.getAllHeaders().elements();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getHeaderAsString(HttpConstants.HDR_CONTENT_TYPE);
    }

    public String getProtocol() {
        return this.request.getVersion();
    }

    public String getServerName() {
        if (this.serverName == null) {
            this.serverName = this.request.getVirtualHost();
            if (this.serverName == null) {
                this.serverName = new String("localhost");
            }
        }
        return this.serverName;
    }

    public int getServerPort() {
        if (this.serverPort == -1) {
            this.serverPort = this.request.getVirtualPort();
            if (this.serverPort == -1) {
                this.serverPort = 80;
            }
        }
        return this.serverPort;
    }

    public String getRemoteHost() {
        return this.isc.getRemoteAddr().getCanonicalHostName();
    }

    public String getRemoteAddr() {
        return this.isc.getRemoteAddr().getHostAddress();
    }

    public int getRemotePort() {
        return this.isc.getRemotePort();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public InputStream getInputStream() throws IOException {
        return this.bbIS;
    }

    public String getLocalAddr() {
        return this.isc.getLocalAddr().getCanonicalHostName();
    }

    public String getLocalName() {
        return this.isc.getLocalAddr().getHostAddress();
    }

    public int getLocalPort() {
        return this.isc.getLocalPort();
    }

    public boolean isSSL() {
        return this.isc.isSecure();
    }

    public byte[] getSSLSessionID() {
        return null;
    }

    public String getSessionID() {
        return null;
    }

    public SOAPResponse getResponse() {
        return this.response;
    }

    public String getCipherSuite() {
        return null;
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public Cookie[] getCookies() {
        List list = this.request.getAllCookies();
        if (list == null || list.isEmpty()) {
            return null;
        }
        Cookie[] cookieArray = new Cookie[list.size()];
        list.toArray(cookieArray);
        return cookieArray;
    }
}

