/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.soapchannel.acceptor;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.soapchannel.acceptor.SACByteBufferOutputStream;
import com.ibm.ws.soapchannel.acceptor.SACWriteCallback;
import com.ibm.ws.soapchannel.acceptor.SOAPAcceptorConnectionLink;
import com.ibm.ws.webcontainer.srt.http.HttpDate;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.soapcontainer.SOAPRequest;
import com.ibm.wsspi.soapcontainer.SOAPResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.Cookie;

public class SACResponseImpl
implements SOAPResponse {
    private HttpResponseMessage response = null;
    private SOAPRequest request = null;
    private SACByteBufferOutputStream bbOS = null;
    private SACWriteCallback writeCB = null;

    public void init(SOAPAcceptorConnectionLink sOAPAcceptorConnectionLink, HttpInboundServiceContext httpInboundServiceContext, SACWriteCallback sACWriteCallback) {
        this.writeCB = sACWriteCallback;
        this.request = sOAPAcceptorConnectionLink.getRequest();
        this.response = httpInboundServiceContext.getResponse();
        this.bbOS = new SACByteBufferOutputStream(httpInboundServiceContext, sACWriteCallback);
    }

    public void destroy() {
    }

    public void setStatusCode(int n) {
        try {
            this.response.setStatusCode(n);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, this.getClass().getName(), "87");
        }
    }

    public OutputStream getOutputStream() throws IOException {
        return this.bbOS;
    }

    public boolean isCommitted() {
        return false;
    }

    public boolean hasContentBuffered() {
        return this.bbOS.hasContentBuffered();
    }

    public void flushBufferedContent() {
        this.bbOS.flushWriteBuffer();
    }

    public void addHeader(String string, String string2) {
        this.response.appendHeader(string, string2);
    }

    public void addHeader(byte[] byArray, byte[] byArray2) {
        this.response.appendHeader(byArray, byArray2);
    }

    public void addDateHeader(String string, long l) {
        this.addHeader(string, Long.toString(l));
    }

    public void addIntHeader(String string, int n) {
        this.addHeader(string, Integer.toString(n));
    }

    public void setDateHeader(String string, long l) {
        HttpDate httpDate = new HttpDate(l);
        this.setHeader(string, httpDate.toString());
    }

    public void setIntHeader(String string, int n) {
        this.setHeader(string, Integer.toString(n));
    }

    public String getHeader(String string) {
        return this.response.getHeaderAsString(string);
    }

    public String getHeader(byte[] byArray) {
        return this.response.getHeaderAsString(byArray);
    }

    public boolean containsHeader(String string) {
        return this.response.containsHeader(string);
    }

    public boolean containsHeader(byte[] byArray) {
        return this.response.containsHeader(byArray);
    }

    public void removeHeader(String string) {
        this.response.removeHeader(string);
    }

    public void removeHeader(byte[] byArray) {
        this.response.removeHeader(byArray);
    }

    public SOAPRequest getRequest() {
        return this.request;
    }

    public void setFlushMode(boolean bl) {
        this.bbOS.setFlushMode(bl);
    }

    public void setReason(String string) {
        this.response.setReasonPhrase(string);
    }

    public void setReason(byte[] byArray) {
        this.response.setReasonPhrase(byArray);
    }

    public void addCookie(Cookie cookie) {
        if (cookie.getVersion() == 1) {
            this.response.setCookie(cookie, HttpConstants.HDR_SET_COOKIE2);
        }
        this.response.setCookie(cookie, HttpConstants.HDR_SET_COOKIE);
    }

    public Cookie[] getCookies() {
        List list = this.response.getAllCookies();
        if (list == null || list.isEmpty()) {
            return null;
        }
        Cookie[] cookieArray = new Cookie[list.size()];
        list.toArray(cookieArray);
        return cookieArray;
    }

    public void setHeader(String string, String string2) {
        this.response.setHeader(string, string2);
    }

    public void setHeader(byte[] byArray, byte[] byArray2) {
        this.response.setHeader(byArray, byArray2);
    }

    public void setContentType(String string) {
        this.response.setHeader((HeaderKeys)HttpConstants.HDR_CONTENT_TYPE, string);
    }

    public void setContentLength(int n) {
        this.response.setContentLength(n);
    }

    public void finishResponse() {
        this.flushBufferedContent();
        this.writeCB.finishResponse();
    }
}

