/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.soapchannel.acceptor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.soapchannel.acceptor.SACResponseImpl;
import com.ibm.ws.soapchannel.acceptor.SOAPAcceptorConnectionLink;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.util.ArrayList;

public class SACWriteCallback
implements InterChannelCallback {
    private static final TraceComponent _tc = Tr.register(SACWriteCallback.class, "SOAPChannel", "com.ibm.ws.soapchannel.resources.Messages");
    private SOAPAcceptorConnectionLink link = null;
    private HttpInboundServiceContext isc = null;
    private SACResponseImpl response = null;
    private ArrayList writeQueue = new ArrayList();
    private boolean writing = false;
    private boolean doClose = false;

    public void init(SOAPAcceptorConnectionLink sOAPAcceptorConnectionLink, HttpInboundServiceContext httpInboundServiceContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "init");
        }
        this.link = sOAPAcceptorConnectionLink;
        this.isc = httpInboundServiceContext;
        this.response = this.link.getResponse();
        this.doClose = false;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "init");
        }
    }

    public int getBufferSize() {
        return this.link.getChannel().getBufferSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "complete");
        }
        ArrayList arrayList = this.writeQueue;
        synchronized (arrayList) {
            WsByteBuffer[] wsByteBufferArray;
            if (!this.writeQueue.isEmpty()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Releasing buffer(s) we just finished writing.");
                }
                wsByteBufferArray = (WsByteBuffer[])this.writeQueue.remove(0);
                this.releaseByteBuffers(wsByteBufferArray);
            }
            if (this.writeQueue.isEmpty()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Write queue is now empty.");
                }
                this.writing = false;
                if (this.doClose) {
                    this.link.close(virtualConnection, null);
                }
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Writing next buffer...");
                }
                wsByteBufferArray = (WsByteBuffer[])this.writeQueue.get(0);
                if (this.doClose && this.writeQueue.isEmpty()) {
                    this.finishBufferAsynch(wsByteBufferArray);
                } else {
                    this.writeBufferAsynch(wsByteBufferArray);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "complete");
        }
    }

    public void destroy() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "destroy");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Write queue size: " + this.writeQueue.size());
        }
        while (!this.writeQueue.isEmpty()) {
            WsByteBuffer[] wsByteBufferArray = (WsByteBuffer[])this.writeQueue.remove(0);
            this.releaseByteBuffers(wsByteBufferArray);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "destroy");
        }
    }

    public void error(VirtualConnection virtualConnection, Throwable throwable) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "error");
        }
        Tr.error(_tc, "caughtException7", throwable);
        this.link.close(virtualConnection, null);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishResponse() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "finishResponse");
        }
        ArrayList arrayList = this.writeQueue;
        synchronized (arrayList) {
            this.doClose = true;
            if (this.writeQueue.isEmpty() && !this.response.hasContentBuffered()) {
                this.finishBufferAsynch(null);
            } else if (this.response.hasContentBuffered()) {
                this.response.flushBufferedContent();
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "finishResponse");
        }
    }

    private void releaseByteBuffers(WsByteBuffer[] wsByteBufferArray) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "releaseByteBuffers");
        }
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            wsByteBufferArray[i].release();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "releaseByteBuffers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBuffer(WsByteBuffer[] wsByteBufferArray) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "writeBuffer");
        }
        if (wsByteBufferArray != null) {
            ArrayList arrayList = this.writeQueue;
            synchronized (arrayList) {
                if (this.writeQueue.isEmpty() && !this.writing) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Direct write");
                    }
                    this.writeQueue.add(wsByteBufferArray);
                    if (this.doClose) {
                        this.finishBufferAsynch(wsByteBufferArray);
                    } else {
                        this.writeBufferAsynch(wsByteBufferArray);
                    }
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Adding to queue");
                    }
                    this.writeQueue.add(wsByteBufferArray);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "writeBuffer");
        }
    }

    private void writeBufferAsynch(WsByteBuffer[] wsByteBufferArray) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "writeBufferAsynch");
        }
        this.writing = true;
        try {
            VirtualConnection virtualConnection = this.isc.sendResponseBody(wsByteBufferArray, this, false);
            if (virtualConnection != null) {
                this.complete(virtualConnection);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "writeBufferAsynch");
        }
    }

    private void finishBufferAsynch(WsByteBuffer[] wsByteBufferArray) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "finishBufferAsynch");
        }
        this.writing = true;
        try {
            VirtualConnection virtualConnection = null;
            virtualConnection = this.isc.finishResponseMessage(wsByteBufferArray, this, false);
            if (virtualConnection != null) {
                this.complete(virtualConnection);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "finishBufferAsynch");
        }
    }
}

