/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.soapchannel.acceptor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.soap.container.SoapContainerService;
import com.ibm.ws.soapchannel.acceptor.SOAPAcceptorChannelFactory;
import com.ibm.ws.soapchannel.acceptor.SOAPAcceptorConnectionLink;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.base.InboundApplicationChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;

public class SOAPAcceptorChannel
extends InboundApplicationChannel
implements Discriminator {
    private static final TraceComponent _tc = Tr.register(SOAPAcceptorChannel.class, "SOAPChannel", "com.ibm.ws.soapchannel.resources.Messages");
    private SOAPAcceptorChannelFactory objFactory = null;
    private static SoapContainerService soapContainerSvc = null;
    private Class inputInterface = HttpInboundServiceContext.class;
    private Class inputDiscrimDataType = HttpRequestMessage.class;
    private int bufferSize = 8192;
    private static final String SOAP_ACL_NAME = "SOAPACL";
    private static final byte[] SYSAPP_CR_AS_BYTES = "/_IBMSYSAPP".getBytes();

    public SOAPAcceptorChannel(SOAPAcceptorChannelFactory sOAPAcceptorChannelFactory, ChannelData channelData) {
        super(channelData);
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPAcceptorChannel ctor");
        }
        this.objFactory = sOAPAcceptorChannelFactory;
        Integer n = (Integer)channelData.getPropertyBag().get("bufferSize");
        if (n != null) {
            this.bufferSize = n;
            Tr.info(_tc, "bufferSize", Integer.toString(this.bufferSize));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPAcceptorChannel ctor, bufferSize=" + this.bufferSize);
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public Discriminator getDiscriminator() {
        return this;
    }

    public ConnectionLink getConnectionLink(VirtualConnection virtualConnection) {
        Object object;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getConnectionLink", new Object[]{virtualConnection});
        }
        if ((object = (ConnectionLink)virtualConnection.getStateMap().get(SOAP_ACL_NAME)) == null) {
            object = this.objFactory.getSCL(virtualConnection, this);
            virtualConnection.getStateMap().put(SOAP_ACL_NAME, object);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getConnectionLink");
        }
        return object;
    }

    public void releaseConnectionLink(SOAPAcceptorConnectionLink sOAPAcceptorConnectionLink) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "releaseConnectionLink");
        }
        this.objFactory.releaseSCL(sOAPAcceptorConnectionLink);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "releaseConnectionLink");
        }
    }

    public void start() throws ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "start");
        }
        if (SOAPAcceptorChannel.getSoapContainerService() == null) {
            throw new ChannelException("SOAP Container Service has not been set.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "start");
        }
    }

    public void stop(long l) throws ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stop");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stop");
        }
    }

    public void init() throws ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "init, name=" + this.getName());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "init");
        }
    }

    public void destroy() throws ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "destroy");
        }
        this.objFactory = null;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "destroy");
        }
    }

    public Class getDeviceInterface() {
        return this.inputInterface;
    }

    public void update(ChannelData channelData) {
        super.setConfig(channelData);
    }

    public int discriminate(VirtualConnection virtualConnection, Object object) {
        byte[] byArray;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "discriminate", new Object[]{virtualConnection});
        }
        int n = 0;
        HttpRequestMessage httpRequestMessage = (HttpRequestMessage)object;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Checking request URI: " + httpRequestMessage.getRequestURI());
        }
        if ((byArray = httpRequestMessage.getRequestURIAsByteArray()).length >= SYSAPP_CR_AS_BYTES.length) {
            n = 1;
            for (int i = 0; n == 1 && i < SYSAPP_CR_AS_BYTES.length; ++i) {
                if (byArray[i] == SYSAPP_CR_AS_BYTES[i]) continue;
                n = 0;
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Discriminate process has yielded the following answer: " + n);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "discriminate");
        }
        return n;
    }

    public void cleanUpState(VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cleanUpState");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cleanUpState");
        }
    }

    public Class getDiscriminatoryDataType() {
        return this.inputDiscrimDataType;
    }

    public Channel getChannel() {
        return this;
    }

    public int getWeight() {
        return this.getConfig().getDiscriminatorWeight();
    }

    public static void setSoapContainerService(SoapContainerService soapContainerService) {
        soapContainerSvc = soapContainerService;
    }

    public static SoapContainerService getSoapContainerService() {
        return soapContainerSvc;
    }
}

