/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.soapchannel.acceptor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.soapchannel.acceptor.SACReadCallback;
import com.ibm.ws.soapchannel.acceptor.SACRequestImpl;
import com.ibm.ws.soapchannel.acceptor.SACResponseImpl;
import com.ibm.ws.soapchannel.acceptor.SACWriteCallback;
import com.ibm.ws.soapchannel.acceptor.SOAPAcceptorChannel;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.channel.base.InboundApplicationLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.io.OutputStream;

public class SOAPAcceptorConnectionLink
extends InboundApplicationLink
implements Runnable {
    private static final TraceComponent _tc = Tr.register(SOAPAcceptorConnectionLink.class, "SOAPChannel", "com.ibm.ws.soapchannel.resources.Messages");
    private HttpInboundServiceContext isc = null;
    private SOAPAcceptorChannel channel = null;
    private SACRequestImpl request = null;
    private SACResponseImpl response = null;
    private SACReadCallback readCB = null;
    private SACWriteCallback writeCB = null;

    public SOAPAcceptorConnectionLink(SOAPAcceptorChannel sOAPAcceptorChannel, VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPAcceptorConnectionLink ctor");
        }
        this.init(sOAPAcceptorChannel, virtualConnection);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPAcceptorConnectionLink ctor");
        }
    }

    public void init(SOAPAcceptorChannel sOAPAcceptorChannel, VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "init(SOAPAcceptorChannel,VirtualConnection)");
        }
        this.init(virtualConnection);
        this.channel = sOAPAcceptorChannel;
        this.createSubs();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "init(SOAPAcceptorChannel,VirtualConnection)");
        }
    }

    public SACResponseImpl getResponse() {
        return this.response;
    }

    public SACRequestImpl getRequest() {
        return this.request;
    }

    public void destroy(Exception exception) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "destroy(Exception), exception=" + (exception != null ? exception.toString() : "<null>"));
        }
        this.destroySubs();
        super.destroy(exception);
        this.channel.releaseConnectionLink(this);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "destroy(Exception)");
        }
    }

    private void destroySubs() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Destroying subordinate objects.");
        }
        if (this.request != null) {
            this.request.destroy();
            this.request = null;
        }
        if (this.response != null) {
            this.response.destroy();
            this.response = null;
        }
        if (this.readCB != null) {
            this.readCB.destroy();
            this.readCB = null;
        }
        if (this.writeCB != null) {
            this.writeCB.destroy();
            this.writeCB = null;
        }
    }

    private void createSubs() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Allocating subordinate objects.");
        }
        this.request = new SACRequestImpl();
        this.response = new SACResponseImpl();
        this.readCB = new SACReadCallback();
        this.writeCB = new SACWriteCallback();
    }

    public void ready(VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ready");
        }
        super.init(virtualConnection);
        if (this.request == null) {
            this.createSubs();
        }
        this.isc = (HttpInboundServiceContext)this.getDeviceLink().getChannelAccessor();
        this.readCB.init(this, this.isc, virtualConnection);
        this.readCB.readRequest();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ready");
        }
    }

    public void close(VirtualConnection virtualConnection, Exception exception) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "close");
        }
        this.destroySubs();
        super.close(virtualConnection, exception);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestReady(VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "requestReady");
        }
        this.writeCB.init(this, this.isc);
        this.request.init(this.isc, this.readCB.getRequestBodyBuffers(), this.response);
        this.response.init(this, this.isc, this.writeCB);
        try {
            Object v = virtualConnection.getStateMap().get("ZAioThreadPool");
            if (v != null) {
                String string = Thread.currentThread().getName();
                ThreadPool threadPool = (ThreadPool)v;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Current thread name: " + string);
                }
                if (!string.startsWith(threadPool.getName())) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "About to do threadswitch!");
                    }
                    threadPool.execute((Runnable)this, 2);
                    return;
                }
            }
            this.run();
        }
        catch (Throwable throwable) {
            Tr.error(_tc, "caughtException8", throwable);
            this.errorResponse(throwable);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "requestReady");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "run");
        }
        try {
            SOAPAcceptorChannel.getSoapContainerService().handleRequest(this.request, this.response);
        }
        catch (Throwable throwable) {
            Tr.error(_tc, "caughtException8", throwable);
            this.errorResponse(throwable);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "run");
            }
        }
    }

    public void errorResponse(Throwable throwable) {
        try {
            this.response.setStatusCode(404);
            this.response.setContentType("text/html");
            OutputStream outputStream = this.response.getOutputStream();
            if (outputStream != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<h2>ERROR</h2>\n");
                stringBuffer.append("<p>System error occurred while processing request URL: " + this.request.getRequestURLAsString() + "\n");
                stringBuffer.append("<p>Exception is: " + throwable + "\n");
                outputStream.write(stringBuffer.toString().getBytes());
                outputStream.close();
                this.response.finishResponse();
            }
        }
        catch (Throwable throwable2) {
            Tr.error(_tc, "caughtException8", throwable2);
        }
    }

    public SOAPAcceptorChannel getChannel() {
        return this.channel;
    }
}

