/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.soapchannel.acceptor.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.channel.framework.impl.WSChainData;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.http.channel.inbound.impl.WSHttpInboundChannelFactory;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.soap.container.SoapContainerService;
import com.ibm.ws.soapchannel.acceptor.SOAPAcceptorChannel;
import com.ibm.ws.soapchannel.acceptor.SOAPAcceptorChannelFactory;
import com.ibm.ws.webcontainer.channel.WCChannelFactory;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import java.util.HashMap;

public class SOAPAcceptorChannelComponentImpl
extends ComponentImpl {
    private static final TraceComponent _tc = Tr.register(SOAPAcceptorChannelComponentImpl.class, "SOAPChannel", "com.ibm.ws.soapchannel.resources.Messages");
    private static final String SOAP_ACCEPTOR_CHANNEL_NAME = "SOAPAcceptor";
    private static final String SOAP_ACCEPTOR_CHAIN_NAME = "SOAPAcceptorChain";
    private static final Class wcChannelFactoryClass = WCChannelFactory.class;
    private static final Class httpChannelFactoryClass = WSHttpInboundChannelFactory.class;
    private static final Class soapAcceptorFactoryClass = SOAPAcceptorChannelFactory.class;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "start");
        }
        try {
            ChannelFrameworkService channelFrameworkService;
            SoapContainerService soapContainerService = (SoapContainerService)this.getService(SoapContainerService.class);
            if (soapContainerService == null) {
                Tr.error(_tc, "noSOAPContainer");
                return;
            }
            SOAPAcceptorChannel.setSoapContainerService(soapContainerService);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found the SOAP Container Service.");
            }
            if ((channelFrameworkService = (ChannelFrameworkService)this.getService(ChannelFrameworkService.class)) == null) {
                Tr.error(_tc, "noCFSvc2");
                return;
            }
            ChannelData[] channelDataArray = channelFrameworkService.getAllChannels();
            ChannelData channelData = null;
            for (int i = 0; i < channelDataArray.length; ++i) {
                int n;
                if (channelDataArray[i].getFactoryType() != wcChannelFactoryClass || (n = (channelData = channelDataArray[i]).getDiscriminatorWeight()) >= 2) continue;
                channelFrameworkService.updateChannelWeight(channelData.getName(), 2);
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Updated disc wt of channel '" + channelData.getName() + "' to: " + channelData.getDiscriminatorWeight());
            }
            if (channelData == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Web Container channel not found, so we'll bypass the SOAP Acceptor channel.");
                }
                return;
            }
            HashMap hashMap = new HashMap();
            ChannelData channelData2 = channelFrameworkService.addChannel(SOAP_ACCEPTOR_CHANNEL_NAME, soapAcceptorFactoryClass, hashMap, 0);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Created SOAP Acceptor channel: " + channelData2.getName() + ", wt=" + channelData2.getDiscriminatorWeight());
            }
            ChainData[] chainDataArray = channelFrameworkService.getAllChains(wcChannelFactoryClass);
            for (int i = 0; i < chainDataArray.length; ++i) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found chain containing Web Container channel: " + chainDataArray[i].getName());
                }
                if (!((WSChainData)chainDataArray[i]).isEnabled()) continue;
                ChannelData[] channelDataArray2 = chainDataArray[i].getChannelList();
                String[] stringArray = new String[channelDataArray2.length + 1];
                int n = 0;
                boolean bl = false;
                for (int j = 0; j < channelDataArray2.length && !bl; ++j) {
                    stringArray[n] = channelDataArray2[j].getName();
                    ++n;
                    if (channelDataArray2[j].getFactoryType() != httpChannelFactoryClass) continue;
                    stringArray[n] = SOAP_ACCEPTOR_CHANNEL_NAME;
                    ++n;
                    bl = true;
                }
                if (bl) {
                    String[] stringArray2 = new String[n];
                    for (int j = 0; j < n; ++j) {
                        stringArray2[j] = stringArray[j];
                    }
                    String string = new String(SOAP_ACCEPTOR_CHAIN_NAME + (i + 1));
                    channelFrameworkService.addChain(string, FlowType.INBOUND, stringArray2, "com.ibm.ws.runtime.WebContainerImpl");
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Created new chain '" + string + "' in group '" + "com.ibm.ws.runtime.WebContainerImpl" + "':");
                        for (int j = 0; j < n; ++j) {
                            Tr.debug(_tc, "   Channel #" + (j + 1) + ": " + stringArray2[j]);
                        }
                    }
                    String string2 = new String(string + "_Recovery");
                    channelFrameworkService.addChain(string2, FlowType.INBOUND, stringArray2, "com.ibm.ws.runtime.WebContainerImpl.Recovery");
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "Created new chain '" + string2 + "' in group '" + "com.ibm.ws.runtime.WebContainerImpl.Recovery" + "':");
                    for (int j = 0; j < n; ++j) {
                        Tr.debug(_tc, "   Channel #" + (j + 1) + ": " + stringArray2[j]);
                    }
                    continue;
                }
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Chain '" + chainDataArray[i].getName() + "' is disabled; skipping...");
            }
            Tr.info(_tc, "soapAccConfigComplete");
        }
        catch (Exception exception) {
            Tr.error(_tc, "caughtException", exception);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "start");
            }
        }
    }

    public void initialize(Object object) throws ComponentDisabledException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initialize");
        }
        if (AdminServiceFactory.getAdminService().getProcessType().equals("DeploymentManager")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Disabling component in DMGR process.");
            }
            throw new ComponentDisabledException();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initialize");
        }
    }

    public void stop() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stop");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stop");
        }
    }
}

