/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.soapchannel.monitor.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.channel.framework.impl.WSChainData;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.soapchannel.monitor.impl.SOAPMonitorChannel;
import com.ibm.ws.soapchannel.monitor.impl.SOAPMonitorChannelFactory;
import com.ibm.ws.soapchannel.monitor.impl.SOAPRequestMonitorManager;
import com.ibm.ws.webcontainer.channel.WCChannelFactory;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import java.util.HashMap;

public class SOAPMonitorChannelComponentImpl
extends ComponentImpl {
    private static final TraceComponent _tc = Tr.register(SOAPMonitorChannelComponentImpl.class, "SOAPChannel", "com.ibm.ws.soapchannel.resources.Messages");
    private static final String SOAP_MONITOR_CHANNEL_NAME = "SOAPMonitor";
    private static final String SOAP_MONITOR_CHAIN_NAME = "SOAPMonitorChain";
    private static final Class proxyFactoryClass = WCChannelFactory.class;
    private static final Class soapMonitorFactoryClass = SOAPMonitorChannelFactory.class;

    public void initialize(Object object) throws ComponentDisabledException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initialize");
        }
        if (AdminServiceFactory.getAdminService().getProcessType().equals("DeploymentManager")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Disabling component in DeploymentManager process.");
            }
            throw new ComponentDisabledException();
        }
        if (AdminServiceFactory.getAdminService().getProcessType().equals("NodeAgent")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Disabling component in NodeAgent process.");
            }
            throw new ComponentDisabledException();
        }
        SOAPRequestMonitorManager sOAPRequestMonitorManager = new SOAPRequestMonitorManager();
        if (sOAPRequestMonitorManager == null || sOAPRequestMonitorManager.numRequestMonitors() == 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Disabling SOAP monitor channel... no registered request monitors.");
            }
            throw new ComponentDisabledException();
        }
        SOAPMonitorChannel.setRequestMonitorManager(sOAPRequestMonitorManager);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws RuntimeError, RuntimeWarning {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "start");
        }
        try {
            ChannelFrameworkService channelFrameworkService = (ChannelFrameworkService)this.getService(ChannelFrameworkService.class);
            if (channelFrameworkService == null) {
                Tr.error(_tc, "noCFSvc");
                return;
            }
            ChannelData[] channelDataArray = channelFrameworkService.getAllChannels();
            ChannelData channelData = null;
            for (int i = 0; i < channelDataArray.length; ++i) {
                int n;
                if (channelDataArray[i].getFactoryType() != proxyFactoryClass || (n = (channelData = channelDataArray[i]).getDiscriminatorWeight()) >= 2) continue;
                channelFrameworkService.updateChannelWeight(channelData.getName(), 2);
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Updated disc wt of channel '" + channelData.getName() + "' to: " + channelData.getDiscriminatorWeight());
            }
            if (channelData == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Proxy channel not found, so we'll bypass the SOAP Monitor channel.");
                }
                return;
            }
            HashMap hashMap = new HashMap();
            ChannelData channelData2 = channelFrameworkService.addChannel(SOAP_MONITOR_CHANNEL_NAME, soapMonitorFactoryClass, hashMap, 1);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Created SOAP Monitor channel: " + channelData2.getName() + ", wt=" + channelData2.getDiscriminatorWeight());
            }
            ChainData[] chainDataArray = channelFrameworkService.getAllChains(proxyFactoryClass);
            for (int i = 0; i < chainDataArray.length; ++i) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found chain containing Web Container/Proxy channel: " + chainDataArray[i].getName());
                }
                if (!((WSChainData)chainDataArray[i]).isEnabled()) continue;
                ChannelData[] channelDataArray2 = chainDataArray[i].getChannelList();
                String[] stringArray = new String[channelDataArray2.length + 1];
                int n = 0;
                int n2 = 0;
                while (n2 < channelDataArray2.length) {
                    if (channelDataArray2[n2].getFactoryType() == proxyFactoryClass) {
                        stringArray[n] = SOAP_MONITOR_CHANNEL_NAME;
                        ++n;
                    }
                    stringArray[n] = channelDataArray2[n2].getName();
                    ++n2;
                    ++n;
                }
                String string = new String(SOAP_MONITOR_CHAIN_NAME + (i + 1));
                channelFrameworkService.addChain(string, FlowType.INBOUND, stringArray);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Created new chain: " + string);
                    for (int j = 0; j < n; ++j) {
                        Tr.debug(_tc, "   Channel #" + (j + 1) + ": " + stringArray[j]);
                    }
                }
                channelFrameworkService.addChainToGroup("com.ibm.ws.runtime.WebContainerImpl", string);
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Added new chain to web container group: com.ibm.ws.runtime.WebContainerImpl");
            }
            Tr.info(_tc, "soapMonConfigComplete");
        }
        catch (Exception exception) {
            Tr.error(_tc, "caughtException", exception);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "start");
            }
        }
    }

    public void stop() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stop");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stop");
        }
    }
}

