/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.soapchannel.monitor.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class SOAPByteBufferInputStream
extends InputStream {
    private static final TraceComponent _tc = Tr.register(SOAPByteBufferInputStream.class, "SOAPChannel", "com.ibm.ws.soapchannel.resources.Messages");
    private List byteBuffers;
    private WsByteBuffer curBuffer;
    private int curIndex;

    public SOAPByteBufferInputStream(List list) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPByteBufferInputStream");
        }
        this.byteBuffers = list;
        this.curIndex = -1;
        this.curBuffer = null;
        this.nextBuffer();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPByteBufferInputStream, " + this.byteBuffers.size() + " buffer(s).");
        }
    }

    public int available() {
        if (this.moreData()) {
            return this.curBuffer.remaining();
        }
        return -1;
    }

    public int read() throws IOException {
        if (this.moreData()) {
            return this.curBuffer.get();
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "read(byte[]): b.length=" + byArray.length);
        }
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "read(byte[],int,int): len=" + n2 + ", offset=" + n);
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (!this.moreData()) {
            return -1;
        }
        if (n2 > this.curBuffer.remaining()) {
            n2 = this.curBuffer.remaining();
        }
        this.curBuffer.get(byArray, n, n2);
        return n2;
    }

    public boolean markSupported() {
        return false;
    }

    private boolean moreData() {
        if (this.curBuffer != null) {
            if (this.curBuffer.hasRemaining()) {
                return true;
            }
            this.nextBuffer();
            return this.moreData();
        }
        return false;
    }

    private void nextBuffer() {
        if (this.curIndex < this.byteBuffers.size()) {
            ++this.curIndex;
            WsByteBuffer wsByteBuffer = this.curBuffer = this.curIndex < this.byteBuffers.size() ? (WsByteBuffer)this.byteBuffers.get(this.curIndex) : null;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Moving to buffer #" + (this.curIndex + 1));
            }
        }
    }
}

