/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.soapchannel.monitor.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.soapchannel.monitor.impl.SOAPHttpInboundServiceContext;
import com.ibm.ws.soapchannel.monitor.impl.SOAPMonitorChannel;
import com.ibm.ws.soapchannel.monitor.impl.SOAPRequestMonitorServiceContext;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.ConnectionReadyCallback;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.base.InboundProtocolLink;
import com.ibm.wsspi.channel.framework.DiscriminationProcess;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.soapchannel.monitor.SOAPRequestController;
import java.util.List;

public class SOAPConnectionLink
extends InboundProtocolLink
implements InterChannelCallback,
SOAPRequestController {
    private static final TraceComponent _tc = Tr.register(SOAPConnectionLink.class, "SOAPChannel", "com.ibm.ws.soapchannel.resources.Messages");
    private static NLS _nls = null;
    protected static final String SOAP_ICL_NAME = "SOAPICL";
    private SOAPMonitorChannel channel;
    private HttpInboundServiceContext httpISC = null;
    private SOAPHttpInboundServiceContext soapHttpISC = null;
    private SOAPRequestMonitorServiceContext soapRMSC = null;
    private int numRequestsProcessed = 0;
    private Object suspendSem = new Object();
    private boolean isSuspended = false;
    private boolean inProgress = false;

    private static NLS getNLS() {
        if (_nls == null) {
            _nls = new NLS("com.ibm.ws.soapchannel.resources.Messages");
        }
        return _nls;
    }

    public SOAPConnectionLink(SOAPMonitorChannel sOAPMonitorChannel, VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPConnectionLink ctor");
        }
        this.init(sOAPMonitorChannel, virtualConnection);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPConnectionLink ctor");
        }
    }

    public void init(SOAPMonitorChannel sOAPMonitorChannel, VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "init");
        }
        this.init(virtualConnection);
        this.channel = sOAPMonitorChannel;
        this.vc.getStateMap().put(SOAP_ICL_NAME, this);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "init");
        }
    }

    public Object getChannelAccessor() {
        return this.soapHttpISC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ready(VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ready");
        }
        this.httpISC = (HttpInboundServiceContext)this.getDeviceLink().getChannelAccessor();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Obtained HTTP ISC: " + this.httpISC.toString());
        }
        this.processRequest();
        Object object = this.suspendSem;
        synchronized (object) {
            if (!this.isSuspended) {
                this.doApplicationSideDispatch();
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ready");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doApplicationSideDispatch() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doApplicationSideDispatch");
        }
        try {
            List list = this.soapRMSC.getByteBuffers();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Retreived " + list.size() + " byte buffers from the SOAP RMSC.");
            }
            this.soapHttpISC = new SOAPHttpInboundServiceContext(this.getVirtualConnection(), this.httpISC, list);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Performing discrimination to determine next channel...");
            }
            DiscriminationProcess discriminationProcess = this.channel.getDiscriminationProcess();
            int n = 0;
            try {
                n = discriminationProcess.discriminate(this.vc, (Object)this.soapHttpISC.getRequest(), (ConnectionLink)this);
            }
            catch (Exception exception) {
                Object[] objectArray = new String[]{exception.toString()};
                String string = SOAPConnectionLink.getNLS().getFormattedMessage("caughtException4", objectArray, "Caught unexpected exception discriminate(): {0}");
                Tr.error(_tc, "caughtException4", exception);
                throw new RuntimeException(string);
            }
            if (n == 1) {
                ConnectionReadyCallback connectionReadyCallback = this.getApplicationCallback();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Calling ready() method on next channel: " + connectionReadyCallback.toString());
                }
                connectionReadyCallback.ready(this.vc);
            }
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doApplicationSideDispatch");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processRequest");
        }
        this.soapRMSC = this.channel.getSOAPServiceContext();
        this.soapRMSC.init(this, this.channel, this.httpISC);
        Object object = this.suspendSem;
        synchronized (object) {
            this.isSuspended = false;
            this.inProgress = true;
        }
        this.channel.getRequestMonitorManager().driveHandleRequest(this.soapRMSC, this);
        object = this.suspendSem;
        synchronized (object) {
            this.inProgress = false;
        }
        ++this.numRequestsProcessed;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "processRequest");
        }
    }

    public void close(VirtualConnection virtualConnection, Exception exception) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "close");
        }
        super.close(virtualConnection, exception);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "close");
        }
    }

    public void destroy(Exception exception) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "destroy");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "processed " + this.numRequestsProcessed + " SOAP request(s)");
        }
        this.vc.getStateMap().remove(SOAP_ICL_NAME);
        super.destroy(exception);
        this.numRequestsProcessed = 0;
        this.httpISC = null;
        if (this.soapHttpISC != null) {
            this.soapHttpISC.destroy();
            this.soapHttpISC = null;
        }
        if (this.soapRMSC != null) {
            this.soapRMSC.destroy();
            this.soapRMSC = null;
        }
        this.channel.releaseConnectionLink(this);
        this.channel = null;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "destroy");
        }
    }

    public void complete(VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "complete");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "complete");
        }
    }

    public void error(VirtualConnection virtualConnection, Throwable throwable) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "error");
        }
        Tr.error(_tc, "caughtException5", throwable);
        super.close(virtualConnection, new Exception(throwable));
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "suspend");
        }
        Object object = this.suspendSem;
        synchronized (object) {
            this.isSuspended = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "suspend");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "resume");
        }
        Object object = this.suspendSem;
        synchronized (object) {
            if (this.isSuspended) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Cleared 'isSuspended' flag.");
                }
                this.isSuspended = false;
                if (!this.inProgress) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Request not 'in progress', proceeding with dispatch.");
                    }
                    this.doApplicationSideDispatch();
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "resume() called for request that was not suspended!");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "resume");
        }
    }

    public void sendError() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "sendError");
        }
        try {
            this.httpISC.sendError(HttpConstants.STATUS_INTERNAL_ERROR.getHttpError());
        }
        catch (MessageSentException messageSentException) {
            // empty catch block
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "sendError");
        }
    }

    public void setHeader(String string, String string2) {
        this.httpISC.getRequest().setHeader(string, string2);
    }

    public void setHeader(HttpHeaderKeys httpHeaderKeys, String string) {
        this.httpISC.getRequest().setHeader((HeaderKeys)httpHeaderKeys, string);
    }

    public boolean containsHeader(HttpHeaderKeys httpHeaderKeys) {
        return this.httpISC.getRequest().containsHeader(httpHeaderKeys);
    }
}

