/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.soapchannel.monitor.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.exception.IllegalResponseObjectException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.error.HttpError;
import com.ibm.wsspi.http.channel.exception.BodyCompleteException;
import com.ibm.wsspi.http.channel.exception.IllegalHttpBodyException;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.tcp.channel.SSLConnectionContext;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;

public class SOAPHttpInboundServiceContext
implements HttpInboundServiceContext {
    private static final TraceComponent _tc = Tr.register(SOAPHttpInboundServiceContext.class, "SOAPChannel", "com.ibm.ws.soapchannel.resources.Messages");
    private HttpInboundServiceContext isc;
    private List bodyBuffers;
    private int nextBufferIndex;
    private VirtualConnection theVC;

    public SOAPHttpInboundServiceContext(VirtualConnection virtualConnection, HttpInboundServiceContext httpInboundServiceContext, List list) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPHttpInboundServiceContext ctor");
        }
        this.theVC = virtualConnection;
        this.isc = httpInboundServiceContext;
        this.bodyBuffers = list;
        this.nextBufferIndex = 0;
        if (_tc.isDebugEnabled()) {
            int n = 0;
            for (int i = 0; i < list.size(); ++i) {
                WsByteBuffer wsByteBuffer = (WsByteBuffer)list.get(i);
                n += wsByteBuffer.remaining();
            }
            Tr.debug(_tc, "# of byte buffers: " + list.size() + ", total bytes: " + n);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPHttpInboundServiceContext ctor");
        }
    }

    public void setResponse(HttpResponseMessage httpResponseMessage) throws IllegalResponseObjectException {
        this.isc.setResponse(httpResponseMessage);
    }

    public void sendResponseHeaders() throws IOException, MessageSentException {
        this.isc.sendResponseHeaders();
    }

    public void sendResponseBody(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        this.isc.sendResponseBody(wsByteBufferArray);
    }

    public void finishResponseMessage(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        this.isc.finishResponseMessage(wsByteBufferArray);
    }

    public void sendError(HttpError httpError) throws MessageSentException {
        this.isc.sendError(httpError);
    }

    public WsByteBuffer[] _getRequestBodyBuffers(boolean bl) throws IOException, IllegalHttpBodyException {
        int n;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "_getRequestBodyBuffers(" + (bl ? "true" : "false") + ")");
        }
        WsByteBuffer[] wsByteBufferArray = null;
        int n2 = 0;
        if (!this.isc.isIncomingMessageFullyRead()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Delegating to HTTP ISC to read remaining buffers...");
            }
            wsByteBufferArray = bl ? this.isc.getRawRequestBodyBuffers() : this.isc.getRequestBodyBuffers();
            int n3 = n2 = wsByteBufferArray != null ? wsByteBufferArray.length : 0;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Read " + n2 + " buffers from HTTP ISC.");
            }
        }
        int n4 = this.localBuffersReady() ? this.bodyBuffers.size() - this.nextBufferIndex : 0;
        WsByteBuffer[] wsByteBufferArray2 = null;
        int n5 = 0;
        if (n4 + n2 > 0) {
            wsByteBufferArray2 = new WsByteBuffer[n4 + n2];
        }
        if (n4 > 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Will return " + n4 + " local buffers...");
            }
            while (this.nextBufferIndex < this.bodyBuffers.size()) {
                wsByteBufferArray2[n5] = (WsByteBuffer)this.bodyBuffers.get(this.nextBufferIndex);
                ++this.nextBufferIndex;
                ++n5;
            }
        }
        if (n2 > 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Will return " + n2 + " buffers from the HTTP ISC...");
            }
            for (n = 0; n < n2; ++n) {
                wsByteBufferArray2[n5] = wsByteBufferArray[n];
                ++n5;
            }
        }
        wsByteBufferArray = null;
        if (_tc.isDebugEnabled()) {
            n = 0;
            for (int i = 0; i < wsByteBufferArray2.length; ++i) {
                n += wsByteBufferArray2[i].remaining();
            }
            Tr.debug(_tc, "Returning " + wsByteBufferArray2.length + " byte buffers, total size = " + n + " bytes.");
        }
        return wsByteBufferArray2;
    }

    private WsByteBuffer _getRequestBodyBuffer(boolean bl) throws IOException, IllegalHttpBodyException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "_getRequestBodyBuffer(" + (bl ? "true" : "false") + ")");
        }
        WsByteBuffer wsByteBuffer = null;
        if (this.localBuffersReady()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Returning a local byte buffer...");
            }
            wsByteBuffer = (WsByteBuffer)this.bodyBuffers.get(this.nextBufferIndex);
            ++this.nextBufferIndex;
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Delegating to HTTP ISC...");
            }
            WsByteBuffer wsByteBuffer2 = wsByteBuffer = bl ? this.isc.getRawRequestBodyBuffer() : this.isc.getRequestBodyBuffer();
        }
        if (_tc.isDebugEnabled()) {
            if (wsByteBuffer != null) {
                Tr.debug(_tc, "Returning 1 byte buffer, total bytes = " + wsByteBuffer.remaining() + " bytes.");
            } else {
                Tr.debug(_tc, "Returning null... no more data available to be read.");
            }
        }
        return wsByteBuffer;
    }

    public VirtualConnection getRequestBodyBuffers(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getRequestBodyBuffers async");
        }
        if (bl && null != interChannelCallback) {
            interChannelCallback.complete(this.theVC);
            return null;
        }
        return this.theVC;
    }

    public VirtualConnection getRequestBodyBuffer(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getRequestBodyBuffer async");
        }
        if (bl && null != interChannelCallback) {
            interChannelCallback.complete(this.theVC);
            return null;
        }
        return this.theVC;
    }

    public WsByteBuffer[] getRequestBodyBuffers() throws IOException, IllegalHttpBodyException {
        return this._getRequestBodyBuffers(false);
    }

    public WsByteBuffer getRequestBodyBuffer() throws IOException, IllegalHttpBodyException {
        return this._getRequestBodyBuffer(false);
    }

    public WsByteBuffer getRawRequestBodyBuffer() throws IOException, IllegalHttpBodyException {
        return this._getRequestBodyBuffer(true);
    }

    public WsByteBuffer[] getRawRequestBodyBuffers() throws IOException, IllegalHttpBodyException {
        return this._getRequestBodyBuffers(true);
    }

    public VirtualConnection getRawRequestBodyBuffer(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getRawRequestBodyBuffer async");
        }
        return this.getRequestBodyBuffer(interChannelCallback, bl);
    }

    public VirtualConnection getRawRequestBodyBuffers(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getRawRequestBodyBuffers async");
        }
        return this.getRequestBodyBuffers(interChannelCallback, bl);
    }

    public HttpRequestMessage getRequest() {
        return this.isc.getRequest();
    }

    public HttpResponseMessage getResponse() {
        return this.isc.getResponse();
    }

    public void resetRequestOwnership() {
        this.isc.resetRequestOwnership();
    }

    public void resetResponseOwnership() {
        this.isc.resetResponseOwnership();
    }

    public boolean isMessageSent() {
        return this.isc.isMessageSent();
    }

    public boolean localBuffersReady() {
        return this.nextBufferIndex < this.bodyBuffers.size();
    }

    public boolean isPersistent() {
        return this.isc.isPersistent();
    }

    public boolean isSecure() {
        return this.isc.isSecure();
    }

    public boolean isZlibEncoded() {
        return this.isc.isZlibEncoded();
    }

    public boolean isZlibEncodingSupported() {
        return this.isc.isZlibEncodingSupported();
    }

    public boolean setZlibEncoded(boolean bl) {
        return this.isc.setZlibEncoded(bl);
    }

    public void clear() {
        this.isc.clear();
        this.bodyBuffers = null;
        this.nextBufferIndex = -1;
    }

    public void destroy() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "destroy");
        }
        this.bodyBuffers = null;
        this.nextBufferIndex = -1;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "destroy");
        }
    }

    public InetAddress getRemoteAddr() {
        return this.isc.getRemoteAddr();
    }

    public InetAddress getLocalAddr() {
        return this.isc.getLocalAddr();
    }

    public int getRemotePort() {
        return this.isc.getRemotePort();
    }

    public int getLocalPort() {
        return this.isc.getLocalPort();
    }

    public VirtualConnection sendResponseHeaders(InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        return this.isc.sendResponseHeaders(interChannelCallback, bl);
    }

    public VirtualConnection sendResponseBody(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        return this.isc.sendResponseBody(wsByteBufferArray, interChannelCallback, bl);
    }

    public VirtualConnection finishResponseMessage(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        return this.isc.finishResponseMessage(wsByteBufferArray, interChannelCallback, bl);
    }

    public boolean isIncomingMessageFullyRead() {
        boolean bl = !this.localBuffersReady() && this.isc.isIncomingMessageFullyRead();
        return bl;
    }

    public void setReadTimeout(int n) throws IllegalArgumentException {
        this.isc.setReadTimeout(n);
    }

    public void setWriteTimeout(int n) throws IllegalArgumentException {
        this.isc.setWriteTimeout(n);
    }

    public int getReadTimeout() {
        return this.isc.getReadTimeout();
    }

    public int getWriteTimeout() {
        return this.isc.getWriteTimeout();
    }

    public SSLConnectionContext getSSLContext() {
        return this.isc.getSSLContext();
    }

    public void sendRawResponseBody(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        this.isc.sendRawResponseBody(wsByteBufferArray);
    }

    public VirtualConnection sendRawResponseBody(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        return this.isc.sendRawResponseBody(wsByteBufferArray, interChannelCallback, bl);
    }

    public void finishRawResponseMessage(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        this.isc.finishRawResponseMessage(wsByteBufferArray);
    }

    public VirtualConnection finishRawResponseMessage(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        return this.isc.finishRawResponseMessage(wsByteBufferArray, interChannelCallback, bl);
    }

    public boolean isGZipEncoded() {
        return this.isc.isGZipEncoded();
    }

    public boolean setGZipEncoded(boolean bl) {
        return this.isc.setGZipEncoded(bl);
    }

    public boolean isGZipEncodingSupported() {
        return this.isc.isGZipEncodingSupported();
    }

    public boolean isXGZipEncoded() {
        return this.isc.isXGZipEncoded();
    }

    public boolean setXGZipEncoded(boolean bl) {
        return this.isc.setXGZipEncoded(bl);
    }

    public boolean isXGZipEncodingSupported() {
        return this.isc.isXGZipEncodingSupported();
    }

    public int getNumBytesWritten() {
        return this.isc.getNumBytesWritten();
    }

    public boolean cancelOutstandingRead() {
        return this.isc.cancelOutstandingRead();
    }

    public boolean cancelOutstandingWrite() {
        return this.isc.cancelOutstandingWrite();
    }
}

