/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.soapchannel.monitor.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.soapchannel.monitor.impl.SOAPConnectionLink;
import com.ibm.ws.soapchannel.monitor.impl.SOAPMonitorChannelFactory;
import com.ibm.ws.soapchannel.monitor.impl.SOAPRequestMonitorManager;
import com.ibm.ws.soapchannel.monitor.impl.SOAPRequestMonitorServiceContext;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.base.InboundProtocolChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;

public class SOAPMonitorChannel
extends InboundProtocolChannel
implements Discriminator {
    private static final TraceComponent _tc = Tr.register(SOAPMonitorChannel.class, "SOAPChannel", "com.ibm.ws.soapchannel.resources.Messages");
    public static final String discriminatorKey = "SOAPMonitorChannel.applicationInterface";
    private Class inputInterface = HttpInboundServiceContext.class;
    private Class outputInterface = HttpInboundServiceContext.class;
    private Class inputDiscrimDataType = HttpRequestMessage.class;
    private Class outputDiscrimDataType;
    private SOAPMonitorChannelFactory objFactory;
    private static SOAPRequestMonitorManager srmMgr = null;

    public static synchronized void setRequestMonitorManager(SOAPRequestMonitorManager sOAPRequestMonitorManager) {
        srmMgr = sOAPRequestMonitorManager;
    }

    public SOAPMonitorChannel(SOAPMonitorChannelFactory sOAPMonitorChannelFactory, ChannelData channelData) {
        super(channelData);
        Class clazz = this.outputDiscrimDataType = HttpRequestMessage.class;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPMonitorChannel ctor, name=" + channelData.getName());
        }
        this.objFactory = sOAPMonitorChannelFactory;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPMonitorChannel ctor, name=" + channelData.getName());
        }
    }

    public int discriminate(VirtualConnection virtualConnection, Object object) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "discriminate", new Object[]{virtualConnection});
        }
        int n = 0;
        if (srmMgr.numRequestMonitors() > 0) {
            HttpRequestMessage httpRequestMessage = null;
            try {
                httpRequestMessage = (HttpRequestMessage)object;
                if (httpRequestMessage.containsHeader(HttpConstants.HDR_SOAPACTION)) {
                    n = 1;
                    Tr.debug(_tc, "Found SOAPAction HTTP header.");
                }
            }
            catch (Exception exception) {
                Tr.error(_tc, "discrimError", exception);
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "No registered request monitors...");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Discriminate process has yielded the following answer: " + n);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "discriminate");
        }
        return n;
    }

    public Class getDiscriminatoryDataType() {
        return this.inputDiscrimDataType;
    }

    public Class getDiscriminatoryType() {
        return this.outputDiscrimDataType;
    }

    public Channel getChannel() {
        return this;
    }

    public int getWeight() {
        return this.getConfig().getDiscriminatorWeight();
    }

    public Discriminator getDiscriminator() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getDiscriminator");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getDiscriminator, wt=" + this.getWeight());
        }
        return this;
    }

    public ConnectionLink getConnectionLink(VirtualConnection virtualConnection) {
        Object object;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getConnectionLink", new Object[]{virtualConnection});
        }
        if ((object = (ConnectionLink)virtualConnection.getStateMap().get("SOAPICL")) == null) {
            object = this.objFactory.getSCL(virtualConnection, this);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getConnectionLink");
        }
        return object;
    }

    public void releaseConnectionLink(SOAPConnectionLink sOAPConnectionLink) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "releaseConnectionLink");
        }
        this.objFactory.releaseSCL(sOAPConnectionLink);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "releaseConnectionLink");
        }
    }

    public SOAPRequestMonitorServiceContext getSOAPServiceContext() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getSOAPServiceContext");
        }
        SOAPRequestMonitorServiceContext sOAPRequestMonitorServiceContext = this.objFactory.getSSC();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getSOAPServiceContext");
        }
        return sOAPRequestMonitorServiceContext;
    }

    public void releaseSOAPServiceContext(SOAPRequestMonitorServiceContext sOAPRequestMonitorServiceContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "releaseSOAPServiceContext");
        }
        this.objFactory.releaseSSC(sOAPRequestMonitorServiceContext);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "releaseSOAPServiceContext");
        }
    }

    public void start() throws ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "start");
        }
        if (srmMgr == null) {
            srmMgr = new SOAPRequestMonitorManager();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "start");
        }
    }

    public void stop(long l) throws ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stop");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stop");
        }
    }

    public void init() throws ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "init, name=" + this.getName());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "init");
        }
    }

    public void update(ChannelData channelData) {
        super.setConfig(channelData);
    }

    public void destroy() throws ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "destroy");
        }
        this.objFactory = null;
        srmMgr = null;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "destroy");
        }
    }

    public Class getDeviceInterface() {
        return this.inputInterface;
    }

    public Class getApplicationInterface() {
        return this.outputInterface;
    }

    public SOAPRequestMonitorManager getRequestMonitorManager() {
        return srmMgr;
    }

    public void cleanUpState(VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cleanUpState");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cleanUpState");
        }
    }
}

