/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.soapchannel.monitor.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.models.config.channelservice.InboundTransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.ws.soapchannel.monitor.impl.SOAPConnectionLink;
import com.ibm.ws.soapchannel.monitor.impl.SOAPMonitorChannel;
import com.ibm.ws.soapchannel.monitor.impl.SOAPRequestMonitorServiceContext;
import com.ibm.ws.util.ObjectPool;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.WSChannelFactory;
import com.ibm.wsspi.channel.base.ProtocolChannelFactory;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFactoryData;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryAlreadyInitializedException;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.util.Map;

public class SOAPMonitorChannelFactory
extends ProtocolChannelFactory
implements WSChannelFactory {
    private static final TraceComponent _tc = Tr.register(SOAPMonitorChannelFactory.class, "SOAPChannel", "com.ibm.ws.soapchannel.resources.Messages");
    private static NLS _nls = null;
    private Class appInterface = null;
    private Class[] devInterfaces = null;
    private static final int SCL_POOL_SIZE = 100;
    private static final int ISC_POOL_SIZE = 100;
    private ObjectPool sclPool = null;
    private ObjectPool iscPool = null;

    private static NLS getNLS() {
        if (_nls == null) {
            _nls = new NLS("com.ibm.ws.soapchannel.resources.Messages");
        }
        return _nls;
    }

    public SOAPMonitorChannelFactory() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPMonitorChannelFactory ctor");
        }
        this.appInterface = HttpInboundServiceContext.class;
        this.devInterfaces = new Class[1];
        Class clazz = this.devInterfaces[0] = HttpInboundServiceContext.class;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPMonitorChannelFactory ctor");
        }
    }

    protected Channel createChannel(ChannelData channelData) throws ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createChannel");
        }
        SOAPMonitorChannel sOAPMonitorChannel = null;
        try {
            sOAPMonitorChannel = new SOAPMonitorChannel(this, channelData);
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{exception.toString()};
            String string = SOAPMonitorChannelFactory.getNLS().getFormattedMessage("errorCreateChannel", objectArray, "Caught unexpected exception while creating the SOAP monitor channel: {0}");
            Tr.error(_tc, "errorCreateChannel", exception);
            throw new ChannelException(string, (Throwable)exception);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createChannel");
        }
        return sOAPMonitorChannel;
    }

    public void init(ChannelFactoryData channelFactoryData) throws ChannelFactoryAlreadyInitializedException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "init");
        }
        this.updateProperties(channelFactoryData.getProperties());
        this.sclPool = new ObjectPool("SOAPConnectionLink", 100);
        this.iscPool = new ObjectPool("SOAPRequestMonitorServiceContext", 100);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "init");
        }
    }

    public void destroy() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "destroy");
        }
        this.sclPool = null;
        this.iscPool = null;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "destroy");
        }
    }

    public Class getApplicationInterface() {
        return this.appInterface;
    }

    public Class[] getDeviceInterface() {
        return this.devInterfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPConnectionLink getSCL(VirtualConnection virtualConnection, SOAPMonitorChannel sOAPMonitorChannel) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getSCL");
        }
        SOAPConnectionLink sOAPConnectionLink = null;
        ObjectPool objectPool = this.sclPool;
        synchronized (objectPool) {
            sOAPConnectionLink = (SOAPConnectionLink)this.sclPool.remove();
        }
        if (sOAPConnectionLink != null) {
            sOAPConnectionLink.init(sOAPMonitorChannel, virtualConnection);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Re-using existing SOAPConnectionLink object.");
            }
        } else {
            sOAPConnectionLink = new SOAPConnectionLink(sOAPMonitorChannel, virtualConnection);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Created new SOAPConnectionLink object.");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getSCL");
        }
        return sOAPConnectionLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPRequestMonitorServiceContext getSSC() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getSSC");
        }
        SOAPRequestMonitorServiceContext sOAPRequestMonitorServiceContext = null;
        ObjectPool objectPool = this.iscPool;
        synchronized (objectPool) {
            sOAPRequestMonitorServiceContext = (SOAPRequestMonitorServiceContext)this.iscPool.remove();
        }
        if (sOAPRequestMonitorServiceContext == null) {
            sOAPRequestMonitorServiceContext = new SOAPRequestMonitorServiceContext();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Created new SOAPRequestMonitorServiceContext object.");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getSCL");
        }
        return sOAPRequestMonitorServiceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSCL(SOAPConnectionLink sOAPConnectionLink) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "releaseSCL");
        }
        ObjectPool objectPool = this.sclPool;
        synchronized (objectPool) {
            this.sclPool.add(sOAPConnectionLink);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "releaseSCL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSSC(SOAPRequestMonitorServiceContext sOAPRequestMonitorServiceContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "releaseSSC");
        }
        ObjectPool objectPool = this.iscPool;
        synchronized (objectPool) {
            this.iscPool.add(sOAPRequestMonitorServiceContext);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "releaseSSC");
        }
    }

    public Map createFactoryConfigurationMap(TransportChannelFactory transportChannelFactory, ChannelFrameworkService channelFrameworkService) {
        return null;
    }

    public Map createChannelConfigurationMap(TransportChannel transportChannel, ChannelFrameworkService channelFrameworkService) {
        return null;
    }

    public OutboundChannelDefinition getOutboundChannelDefinition(Map map) {
        return null;
    }

    public String determineAcceptorID(InboundTransportChannel inboundTransportChannel) {
        return null;
    }
}

