/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.soapchannel.monitor.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class SOAPMonitorChannelInputStream
extends InputStream {
    private static final TraceComponent _tc = Tr.register(SOAPMonitorChannelInputStream.class, "SOAPChannel", "com.ibm.ws.soapchannel.resources.Messages");
    private static NLS _nls = null;
    private HttpInboundServiceContext httpISC;
    private ArrayList byteBuffers;
    private WsByteBuffer curBuffer;
    private int curIndex;

    private static NLS getNLS() {
        if (_nls == null) {
            _nls = new NLS("com.ibm.ws.soapchannel.resources.Messages");
        }
        return _nls;
    }

    public SOAPMonitorChannelInputStream(HttpInboundServiceContext httpInboundServiceContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPMonitorChannelInputStream ctor");
        }
        this.httpISC = httpInboundServiceContext;
        this.byteBuffers = new ArrayList();
        this.curIndex = -1;
        this.curBuffer = null;
        this.nextBuffer();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPMonitorChannelInputStream ctor");
        }
    }

    public int available() {
        if (this.moreData()) {
            return this.curBuffer.remaining();
        }
        return -1;
    }

    public int read() throws IOException {
        if (this.moreData()) {
            return this.curBuffer.get();
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "read(byte[]): b.length=" + byArray.length);
        }
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "read(byte[],int,int): len=" + n2 + ", offset=" + n);
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (!this.moreData()) {
            return -1;
        }
        if (n2 > this.curBuffer.remaining()) {
            n2 = this.curBuffer.remaining();
        }
        this.curBuffer.get(byArray, n, n2);
        return n2;
    }

    public boolean markSupported() {
        return false;
    }

    private boolean moreData() {
        if (this.curBuffer != null) {
            if (this.curBuffer.hasRemaining()) {
                return true;
            }
            this.nextBuffer();
            return this.moreData();
        }
        return false;
    }

    private void nextBuffer() {
        try {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Trying to read the next buffer from the HttpISC...");
            }
            this.curBuffer = this.httpISC.getRequestBodyBuffer();
            if (this.curBuffer != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Read next buffer (" + this.curBuffer.remaining() + " bytes)");
                }
                this.byteBuffers.add(this.curBuffer);
                ++this.curIndex;
            }
        }
        catch (Throwable throwable) {
            this.curBuffer = null;
            Object[] objectArray = new String[]{throwable.toString()};
            String string = SOAPMonitorChannelInputStream.getNLS().getFormattedMessage("caughtException3", objectArray, "Caught unexpected exception from synchronous getRequestBodyBuffer(): {0}");
            Tr.error(_tc, "caughtException3", throwable);
            throw new RuntimeException(string);
        }
    }

    private void rewind() {
        for (int i = 0; i < this.byteBuffers.size(); ++i) {
            ((WsByteBuffer)this.byteBuffers.get(i)).rewind();
        }
        this.curIndex = 0;
        this.curBuffer = (WsByteBuffer)this.byteBuffers.get(0);
    }

    public List getByteBuffers() {
        this.rewind();
        ArrayList arrayList = this.byteBuffers;
        this.byteBuffers = null;
        this.curBuffer = null;
        this.curIndex = -1;
        return arrayList;
    }
}

