/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.soapchannel.monitor.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.soapchannel.monitor.impl.SOAPConnectionLink;
import com.ibm.ws.soapchannel.monitor.impl.SOAPRequestMonitorServiceContext;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.soapchannel.monitor.SOAPRequestMonitor;
import com.ibm.wsspi.soapchannel.monitor.SOAPRequestMonitorFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;

public class SOAPRequestMonitorManager {
    private static final TraceComponent _tc = Tr.register(SOAPRequestMonitorManager.class, "SOAPChannel", "com.ibm.ws.soapchannel.resources.Messages");
    private TreeSet monitorSet = null;
    private static final String CFG_FILENAME = "META-INF/soap-request-monitor";

    public SOAPRequestMonitorManager() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPRequestMonitorManager ctor");
        }
        this.monitorSet = this.findAllRequestMonitors();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Discovered " + this.numRequestMonitors() + " request monitor(s).");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPRequestMonitorManager ctor");
        }
    }

    public int numRequestMonitors() {
        return this.monitorSet == null ? 0 : this.monitorSet.size();
    }

    public void driveHandleRequest(SOAPRequestMonitorServiceContext sOAPRequestMonitorServiceContext, SOAPConnectionLink sOAPConnectionLink) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "driveHandleRequest");
        }
        Iterator iterator = this.monitorSet.iterator();
        while (iterator.hasNext()) {
            SOAPRequestMonitor sOAPRequestMonitor = (SOAPRequestMonitor)iterator.next();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "About to call handleRequest for monitor: " + sOAPRequestMonitor.getName());
            }
            try {
                sOAPRequestMonitor.handleRequest(sOAPRequestMonitorServiceContext.getMessageContext(), sOAPConnectionLink);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!_tc.isDebugEnabled()) continue;
            Tr.debug(_tc, "Returned from handleRequest for monitor: " + sOAPRequestMonitor.getName());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "driveHandleRequest");
        }
    }

    private TreeSet findAllRequestMonitors() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "findAllRequestMonitors");
        }
        TreeSet treeSet = (TreeSet)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SOAPRequestMonitorManager.this.discoverRequestMonitors();
            }
        });
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "findAllRequestMonitors", treeSet);
        }
        return treeSet;
    }

    private TreeSet discoverRequestMonitors() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "discoverRequestMonitors");
        }
        TreeSet<SOAPRequestMonitor> treeSet = null;
        List list = this.getFactoryClassNames();
        if (list != null) {
            MonitorComparator monitorComparator = new MonitorComparator();
            treeSet = new TreeSet<SOAPRequestMonitor>(monitorComparator);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SOAPRequestMonitor sOAPRequestMonitor;
                String string = (String)iterator.next();
                SOAPRequestMonitorFactory sOAPRequestMonitorFactory = this.instantiateFactory(string);
                if (sOAPRequestMonitorFactory == null) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Instantiated monitor factory: " + sOAPRequestMonitorFactory.getClass().getName());
                }
                if ((sOAPRequestMonitor = sOAPRequestMonitorFactory.getRequestMonitor()) == null) continue;
                treeSet.add(sOAPRequestMonitor);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "discoverRequestMonitors");
        }
        return treeSet;
    }

    private SOAPRequestMonitorFactory instantiateFactory(String string) {
        SOAPRequestMonitorFactory sOAPRequestMonitorFactory = null;
        Object var3_3 = null;
        try {
            var3_3 = ClassUtils.forName(string).newInstance();
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{string, exception};
            Tr.error(_tc, "errorInstClass", objectArray);
        }
        if (var3_3 != null && var3_3 instanceof SOAPRequestMonitorFactory) {
            sOAPRequestMonitorFactory = var3_3;
        } else {
            String[] stringArray = new String[]{string, SOAPRequestMonitorFactory.class.getName()};
            Tr.warning(_tc, "notFactoryClass", stringArray);
        }
        return sOAPRequestMonitorFactory;
    }

    private List getFactoryClassNames() {
        ArrayList arrayList = new ArrayList();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> enumeration = classLoader.getResources(CFG_FILENAME);
            while (enumeration.hasMoreElements()) {
                this.readClassNames(enumeration.nextElement(), arrayList);
            }
        }
        catch (Exception exception) {
            Tr.error(_tc, "caughtException6", exception);
        }
        this.getClassNamesFromExtensions(arrayList);
        return arrayList;
    }

    private void getClassNamesFromExtensions(ArrayList arrayList) {
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (iExtensionRegistry == null) {
            Tr.error(_tc, "Unable to get eclipse extension registry");
            return;
        }
        String string = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".soap-request-monitor";
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string);
        if (iExtensionPoint == null) {
            Tr.error(_tc, "Unable to get extension point - " + string);
            return;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Processing extension point " + string);
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        for (int i = 0; i < iExtensionArray.length; ++i) {
            IConfigurationElement[] iConfigurationElementArray;
            IExtension iExtension = iExtensionArray[i];
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Processing extension " + iExtensionArray[i].getUniqueIdentifier());
            }
            if ((iConfigurationElementArray = iExtension.getConfigurationElements()).length != 1) {
                Tr.error(_tc, "Invalid number of <classes> elements - " + iConfigurationElementArray.length);
                return;
            }
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[0];
            if (!iConfigurationElement.getName().equals("classes")) {
                Tr.error(_tc, "Invalid element name - expected <classes> but got <" + iConfigurationElement.getName() + ">");
                return;
            }
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElement.getChildren();
            for (int j = 0; j < iConfigurationElementArray2.length; ++j) {
                IConfigurationElement iConfigurationElement2 = iConfigurationElementArray2[j];
                if (!iConfigurationElement2.getName().equals("className")) {
                    Tr.error(_tc, "Invalid element name - expected <className> but got <" + iConfigurationElement2.getName() + ">");
                    continue;
                }
                String string2 = iConfigurationElement2.getValue();
                if (string2 == null) {
                    Tr.error(_tc, "No value provided for <className> element");
                    continue;
                }
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readClassNames(URL uRL, ArrayList arrayList) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "readClassNames, URL=" + uRL.toString());
        }
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf(35);
                if (n >= 0) {
                    string = string.substring(0, n);
                }
                if ((string = string.trim()).length() <= 0 || arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "readClassNames");
        }
    }

    private class MonitorComparator
    implements Comparator {
        private MonitorComparator() {
        }

        public int compare(Object object, Object object2) {
            SOAPRequestMonitor sOAPRequestMonitor = (SOAPRequestMonitor)object;
            SOAPRequestMonitor sOAPRequestMonitor2 = (SOAPRequestMonitor)object2;
            if (sOAPRequestMonitor.getWeight() < sOAPRequestMonitor2.getWeight()) {
                return -1;
            }
            if (sOAPRequestMonitor.getWeight() > sOAPRequestMonitor2.getWeight()) {
                return 1;
            }
            return 0;
        }
    }
}

