/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.soapchannel.monitor.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.soapchannel.monitor.impl.SOAPConnectionLink;
import com.ibm.ws.soapchannel.monitor.impl.SOAPMonitorChannel;
import com.ibm.ws.soapchannel.monitor.impl.SOAPMonitorChannelInputStream;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.client.ClientEngine;
import com.ibm.ws.webservices.engine.configuration.NullEngineConfigurationProvider;
import com.ibm.ws.webservices.engine.utils.MCUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class SOAPRequestMonitorServiceContext {
    private static final TraceComponent _tc = Tr.register(SOAPRequestMonitorServiceContext.class, "SOAPChannel", "com.ibm.ws.soapchannel.resources.Messages");
    private static WebServicesEngine engine = null;
    private SOAPMonitorChannel channel = null;
    private MessageContext msgContext = null;
    private SOAPMonitorChannelInputStream smcIS = null;

    public SOAPRequestMonitorServiceContext() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPRequestMonitorServiceContext ctor");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPRequestMonitorServiceContext ctor");
        }
    }

    public void init(SOAPConnectionLink sOAPConnectionLink, SOAPMonitorChannel sOAPMonitorChannel, HttpInboundServiceContext httpInboundServiceContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "init");
        }
        if (engine == null) {
            engine = new ClientEngine(new NullEngineConfigurationProvider());
        }
        this.channel = sOAPMonitorChannel;
        this.smcIS = new SOAPMonitorChannelInputStream(httpInboundServiceContext);
        String string = httpInboundServiceContext.getRequest().getHeaderAsString("Content-Type");
        String string2 = httpInboundServiceContext.getRequest().getHeaderAsString("Content-Location");
        if (string == null) {
            return;
        }
        Message message = new Message(this.smcIS, string, string2);
        this.msgContext = new MessageContext(engine);
        this.msgContext.setRequestMessage(message);
        ArrayList<QName> arrayList = new ArrayList<QName>();
        arrayList.add(SOAPConstants.SOAP11_CONSTANTS.getBodyQName());
        arrayList.add(SOAPConstants.SOAP12_CONSTANTS.getBodyQName());
        MCUtils.setLazyParseQNames(this.msgContext, arrayList);
        this.msgContext.setProperty("IGNORE_SOAPBODY", new Boolean(true));
    }

    public List getByteBuffers() {
        return this.smcIS.getByteBuffers();
    }

    public void destroy() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "destroy");
        }
        this.channel.releaseSOAPServiceContext(this);
        this.channel = null;
        this.smcIS = null;
        this.msgContext = null;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "destroy");
        }
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }
}

