/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.config.FIPSManager;
import com.ibm.ws.ssl.provider.IBMJSSE2Provider;
import com.ibm.ws.ssl.provider.IBMJSSEProvider;
import com.ibm.ws.ssl.provider.SunJSSEProvider;
import com.ibm.ws.util.PlatformHelperFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.net.ssl.SSLContext;

public class JSSEProviderFactory {
    private static TraceComponent tc = Tr.register(JSSEProviderFactory.class.getName(), "SSL");
    private static JSSEProvider cachedProvider = null;
    private static Boolean USE_FIPS_FLAG = new Boolean(false);
    private static Hashtable providerCache = new Hashtable();
    private static String IBMJSSEFIPS_PROVIDER = "IBMJSSEFIPS";
    private static String IBMJSSE_PROVIDER = "IBMJSSE";
    private static String IBMJSSE2_PROVIDER = "IBMJSSE2";
    private static String SUNJSSE_PROVIDER = "SunJSSE";
    private static String DEFAULT_PROVIDER = "IBMJSSE2";
    private static String trustManagerFactoryAlgorithm = null;
    private static String keyManagerFactoryAlgorithm = null;
    private static String defaultSSLSocketFactory = null;
    private static String defaultSSLServerSocketFactory = null;
    private static String isFipsEnabled = null;
    private static boolean fipsInitialized = false;
    private static List fipsJCEProvidersObjectList = null;
    private static List fipsJSSEProvidersObjectList = null;
    private static String providerFromProviderList = "IBMJSSE2";

    public static JSSEProvider getInstance() {
        return JSSEProviderFactory.getInstance(null);
    }

    public static JSSEProvider getInstance(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance: " + string);
        }
        if (string == null) {
            string = JSSEProviderFactory.getProviderFromProviderList();
        }
        if (string == null) {
            string = DEFAULT_PROVIDER;
        }
        if (string != null) {
            if (JSSEProviderFactory.isFipsEnabled() || string.equalsIgnoreCase(IBMJSSEFIPS_PROVIDER)) {
                string = IBMJSSE2_PROVIDER;
            }
            if ((cachedProvider = (JSSEProvider)providerCache.get(string)) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getInstance returning cached provider: " + cachedProvider);
                }
                return cachedProvider;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cachedProvider is null, proceeding to determine the provider.");
            }
        }
        final String string2 = string;
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                Provider provider = Security.getProvider(string2);
                if (provider == null) {
                    block16: {
                        if (JSSEProviderFactory.isFipsEnabled() || string2.equalsIgnoreCase(IBMJSSE2_PROVIDER)) {
                            try {
                                provider = (Provider)Class.forName("com.ibm.jsse2.IBMJSSEProvider2").newInstance();
                            }
                            catch (Exception exception) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception loading provider: " + string2);
                                }
                                break block16;
                            }
                        }
                        if (string2.equalsIgnoreCase(IBMJSSE_PROVIDER)) {
                            try {
                                provider = (Provider)Class.forName("com.ibm.jsse2.IBMJSSEProvider2").newInstance();
                            }
                            catch (Exception exception) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception loading provider: " + string2);
                                }
                                break block16;
                            }
                        }
                        if (string2.equalsIgnoreCase(SUNJSSE_PROVIDER)) {
                            try {
                                provider = (Provider)Class.forName("com.sun.net.ssl.internal.ssl.Provider").newInstance();
                            }
                            catch (Exception exception) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception loading provider: " + string2);
                                }
                                break block16;
                            }
                        }
                        try {
                            provider = (Provider)Class.forName("com.ibm.jsse2.IBMJSSEProvider2").newInstance();
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) break block16;
                            Tr.debug(tc, "Exception loading provider: " + string2);
                        }
                    }
                    if (provider != null && provider instanceof Provider) {
                        Security.addProvider(provider);
                    }
                }
                return null;
            }
        });
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Provider name [" + i + "]: " + providerArray[i].getName());
            }
            if (cachedProvider == null && providerArray[i].getName().equalsIgnoreCase(string)) {
                if (string.equalsIgnoreCase(IBMJSSE2_PROVIDER) && JSSEProviderFactory.validateProvider(IBMJSSE2_PROVIDER)) {
                    cachedProvider = new IBMJSSE2Provider();
                    providerCache.put(IBMJSSE2_PROVIDER, cachedProvider);
                    providerCache.put(string, cachedProvider);
                } else if (string.equalsIgnoreCase(IBMJSSE_PROVIDER) && JSSEProviderFactory.validateProvider(IBMJSSE_PROVIDER)) {
                    cachedProvider = new IBMJSSEProvider();
                    providerCache.put(IBMJSSE_PROVIDER, cachedProvider);
                    providerCache.put(string, cachedProvider);
                    if (JSSEProviderFactory.isFipsEnabled()) {
                        Tr.warning(tc, "UseFIPS is enabled but the SSL Configuration is not using FIPS approved JSSE Provider. FIPS approved cryptographic algorithms will not be used in this case.");
                    }
                } else if (string.equalsIgnoreCase(SUNJSSE_PROVIDER) && JSSEProviderFactory.validateProvider(SUNJSSE_PROVIDER)) {
                    cachedProvider = new SunJSSEProvider();
                    providerCache.put(SUNJSSE_PROVIDER, cachedProvider);
                    providerCache.put(string, cachedProvider);
                    if (JSSEProviderFactory.isFipsEnabled()) {
                        Tr.warning(tc, "UseFIPS is enabled but the SSL Configuration is not using FIPS approved JSSE Provider. FIPS approved cryptographic algorithms will not be used in this case.");
                    }
                } else {
                    cachedProvider = new IBMJSSE2Provider();
                    providerCache.put(IBMJSSE2_PROVIDER, cachedProvider);
                    providerCache.put(string, cachedProvider);
                }
            }
            if (cachedProvider != null) continue;
            cachedProvider = new IBMJSSE2Provider();
            providerCache.put(IBMJSSE2_PROVIDER, cachedProvider);
            providerCache.put(string, cachedProvider);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance provider = " + cachedProvider);
        }
        return cachedProvider;
    }

    private static boolean validateProvider(String string) {
        boolean bl = true;
        try {
            SSLContext sSLContext = null;
            try {
                String string2 = "SSL";
                if (JSSEProviderFactory.isFipsEnabled()) {
                    string2 = "TLS";
                }
                final String string3 = string2;
                final String string4 = string;
                sSLContext = (SSLContext)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchAlgorithmException, NoSuchProviderException {
                        return SSLContext.getInstance(string3, string4);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error validating provider: " + string + ", Exception: " + exception.getMessage(), new Object[]{exception});
                }
                bl = false;
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error validating provider: " + string + ", Exception: " + throwable.getMessage(), new Object[]{throwable});
            }
            bl = false;
        }
        return bl;
    }

    public static String getDefaultSSLSocketFactory() {
        if (defaultSSLSocketFactory == null) {
            defaultSSLSocketFactory = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("ssl.SocketFactory.provider");
                }
            });
        }
        return defaultSSLSocketFactory;
    }

    public static String getDefaultSSLServerSocketFactory() {
        if (defaultSSLServerSocketFactory == null) {
            defaultSSLServerSocketFactory = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("ssl.ServerSocketFactory.provider");
                }
            });
        }
        return defaultSSLServerSocketFactory;
    }

    public static String getKeyManagerFactoryAlgorithm() {
        if (keyManagerFactoryAlgorithm == null) {
            keyManagerFactoryAlgorithm = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("ssl.KeyManagerFactory.algorithm");
                }
            });
        }
        return keyManagerFactoryAlgorithm;
    }

    public static String getTrustManagerFactoryAlgorithm() {
        if (trustManagerFactoryAlgorithm == null) {
            trustManagerFactoryAlgorithm = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("ssl.TrustManagerFactory.algorithm");
                }
            });
        }
        return trustManagerFactoryAlgorithm;
    }

    public static boolean isFipsEnabled() {
        return FIPSManager.getInstance().isFIPSEnabled();
    }

    public static void initializeIBMCMSProvider() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeIBMCMSProvider");
        }
        if (PlatformHelperFactory.getPlatformHelper().isOS400()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeIBMCMSProvider (iSeries platform)");
            }
            return;
        }
        Provider provider = Security.getProvider("IBMCMSProvider");
        if (provider != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeIBMCMSProvider (already present)");
            }
            return;
        }
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                block3: {
                    try {
                        Provider provider = (Provider)Class.forName("com.ibm.security.cmskeystore.CMSProvider").newInstance();
                        if (provider != null) {
                            Security.addProvider(provider);
                        }
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block3;
                        Tr.debug(tc, "Exception loading provider: com.ibm.security.cmskeystore.CMSProvider");
                    }
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeIBMCMSProvider (provider initialized)");
        }
    }

    public static void initializeFips() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeFips");
        }
        if (!fipsInitialized) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            Provider[] providerArray = null;
            Provider provider = null;
            Provider provider2 = null;
            Provider provider3 = null;
            try {
                block22: {
                    System.setProperty("com.ibm.jsse2.JSSEFIPS", "true");
                    providerArray = Security.getProviders();
                    for (int i = 0; i < providerArray.length; ++i) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Provider[" + i + "]: " + providerArray[i].getName());
                        }
                        if (providerArray[i].getName().equals("IBMJCE")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "IBMJCE provider at position " + i);
                            }
                            n = i;
                            provider = providerArray[i];
                            continue;
                        }
                        if (providerArray[i].getName().equals("IBMJCEFIPS")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "IBMJCEFIPS provider at position " + i);
                            }
                            n2 = i;
                            provider2 = providerArray[i];
                            continue;
                        }
                        if (!providerArray[i].getName().equals("SUN")) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SUN provider at position " + i);
                        }
                        n3 = i;
                        provider3 = providerArray[i];
                    }
                    if (provider2 == null) {
                        providerArray = Security.getProviders();
                        try {
                            provider2 = (Provider)Class.forName("com.ibm.crypto.fips.provider.IBMJCEFIPS").newInstance();
                            if (provider3 != null) {
                                JSSEProviderFactory.insertProviderAt(provider3, 1);
                                JSSEProviderFactory.insertProviderAt(provider2, 2);
                                break block22;
                            }
                            JSSEProviderFactory.insertProviderAt(provider2, 1);
                        }
                        catch (Exception exception) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception loading provider: com.ibm.crypto.fips.provider.IBMJCEFIPS");
                            }
                            break block22;
                        }
                    }
                    if (provider2 != null && n2 != 0) {
                        providerArray = Security.getProviders();
                        if (provider3 != null) {
                            JSSEProviderFactory.insertProviderAt(provider3, 1);
                            JSSEProviderFactory.insertProviderAt(provider2, 2);
                        } else {
                            JSSEProviderFactory.insertProviderAt(provider2, 1);
                        }
                    }
                }
                providerArray = Security.getProviders();
                for (int i = 0; i < providerArray.length; ++i) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Provider[" + i + "]: " + providerArray[i].getName() + ", info: " + providerArray[i].getInfo());
                }
                fipsInitialized = true;
            }
            catch (Exception exception) {
                Tr.warning(tc, "security.addprovider.error", new Object[]{exception});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught adding IBMJCEFIPS provider.", new Object[]{exception});
                }
                throw exception;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeFips");
        }
    }

    public static void insertProviderAt(Provider provider, int n) {
        Provider provider2;
        int n2;
        Provider[] providerArray = Security.getProviders();
        Provider[] providerArray2 = null;
        if (providerArray != null && providerArray.length > 0) {
            providerArray2 = new Provider[providerArray.length + 2];
            providerArray2[n] = provider;
        }
        int n3 = 1;
        for (n2 = 0; n2 < providerArray.length; ++n2) {
            provider2 = providerArray[n2];
            if (provider2 == null || provider2.getName() == provider.getName()) continue;
            while (providerArray2[n3] != null) {
                ++n3;
            }
            providerArray2[n3] = provider2;
            ++n3;
        }
        JSSEProviderFactory.removeAllProviders();
        providerArray = Security.getProviders();
        for (n2 = 0; n2 < providerArray2.length; ++n2) {
            provider2 = providerArray2[n2];
            if (provider2 == null) continue;
            int n4 = Security.insertProviderAt(provider2, n2 + 1);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, provider2.getName() + " provider added at position " + n4);
        }
    }

    public static void removeAllProviders() {
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            String string;
            if (providerArray[i] == null || (string = providerArray[i].getName()) == null) continue;
            Security.removeProvider(string);
        }
    }

    public static List fipsJCEProviders() {
        String[] stringArray = new String[]{"IBMJCEFIPS"};
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fipsJCEProviders");
        }
        if (fipsJCEProvidersObjectList == null) {
            fipsJCEProvidersObjectList = new ArrayList(stringArray.length);
            if (JSSEProviderFactory.isFipsEnabled()) {
                for (int i = 0; i < stringArray.length; ++i) {
                    fipsJCEProvidersObjectList.add(stringArray[i]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fipsJCEProviders: " + fipsJCEProvidersObjectList);
        }
        return fipsJCEProvidersObjectList;
    }

    public static List fipsJSSEProviders() {
        String[] stringArray = new String[]{"IBMJSSE2"};
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fipsJSSEProviders");
        }
        if (fipsJSSEProvidersObjectList == null) {
            fipsJSSEProvidersObjectList = new ArrayList(stringArray.length);
            if (JSSEProviderFactory.isFipsEnabled()) {
                for (int i = 0; i < stringArray.length; ++i) {
                    fipsJSSEProvidersObjectList.add(stringArray[i]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fipsJCEProviders: " + fipsJSSEProvidersObjectList);
        }
        return fipsJSSEProvidersObjectList;
    }

    private static String getProviderFromProviderList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProviderFromProviderList");
        }
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Provider name [" + i + "]: " + providerArray[i].getName());
            }
            if (providerArray[i].getName().equalsIgnoreCase(IBMJSSE2_PROVIDER)) {
                providerFromProviderList = IBMJSSE2_PROVIDER;
                break;
            }
            if (providerArray[i].getName().equalsIgnoreCase(IBMJSSE_PROVIDER)) {
                providerFromProviderList = IBMJSSE_PROVIDER;
                break;
            }
            if (!providerArray[i].getName().equalsIgnoreCase(SUNJSSE_PROVIDER)) continue;
            providerFromProviderList = SUNJSSE_PROVIDER;
            break;
        }
        if (providerFromProviderList == null) {
            providerFromProviderList = IBMJSSE2_PROVIDER;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProviderFromProviderList -> " + providerFromProviderList);
        }
        return providerFromProviderList;
    }
}

