/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jsse2.ProtoSSLEngine;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.util.Properties;

public class SSLLinkConfig {
    private static final TraceComponent tc = Tr.register(SSLLinkConfig.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private Properties myConfig = null;

    public SSLLinkConfig(Properties properties) {
        this.myConfig = properties;
    }

    public boolean getBooleanProperty(String string) {
        return "true".equalsIgnoreCase(this.myConfig.getProperty(string));
    }

    public String getProperty(String string) {
        return this.myConfig.getProperty(string);
    }

    public Properties getProperties() {
        return this.myConfig;
    }

    public String[] getEnabledCipherSuites(ProtoSSLEngine protoSSLEngine) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getEnabledCipherSuites");
        }
        String[] stringArray = null;
        Object object = this.myConfig.get("com.ibm.ssl.enabledCipherSuites");
        if (null == object) {
            String string = this.myConfig.getProperty("com.ibm.ssl.securityLevel");
            if (null == string) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Defaulting to HIGH security level");
                }
                string = "HIGH";
            }
            stringArray = SSLConfigManager.getInstance().adjustSupportedCiphersToSecurityLevel(protoSSLEngine.getSupportedCipherSuites(), string);
        } else if (object instanceof String) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "enabledCipherSuites is a String: " + object);
            }
            stringArray = ((String)object).split("\\s");
        } else if (object instanceof String[]) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "enabledCipherSuites is a String array");
            }
            stringArray = (String[])object;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Invalid object for enabledCipherSuites: " + object);
        }
        if ((null == stringArray || 0 == stringArray.length) && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Unable to find any enabled ciphers");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getEnabledCipherSuites");
        }
        return stringArray;
    }
}

