/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jsse2.ProtoSSLEngineResult;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ssl.channel.impl.SSLConnectionLink;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeCompletedCallback;
import com.ibm.ws.ssl.channel.impl.SSLUtils;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.IOException;
import java.util.HashMap;

public class SSLQueuedHandshake
implements Runnable {
    private static final TraceComponent tc = Tr.register(SSLUtils.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private SSLConnectionLink connLink;
    private WsByteBuffer netBuffer;
    private WsByteBuffer decryptedNetBuffer;
    private WsByteBuffer appBuffer;
    private WsByteBuffer encryptedAppBuffer;
    private ProtoSSLEngineResult result;
    private SSLHandshakeCompletedCallback handshakeCallback;

    public SSLQueuedHandshake(SSLConnectionLink sSLConnectionLink, WsByteBuffer wsByteBuffer, WsByteBuffer wsByteBuffer2, WsByteBuffer wsByteBuffer3, WsByteBuffer wsByteBuffer4, ProtoSSLEngineResult protoSSLEngineResult, SSLHandshakeCompletedCallback sSLHandshakeCompletedCallback) {
        this.connLink = sSLConnectionLink;
        this.netBuffer = wsByteBuffer;
        this.decryptedNetBuffer = wsByteBuffer2;
        this.appBuffer = wsByteBuffer3;
        this.encryptedAppBuffer = wsByteBuffer4;
        this.result = protoSSLEngineResult;
        this.handshakeCallback = sSLHandshakeCompletedCallback;
        this.connLink.setQueuedHandshake(true);
    }

    public void run() {
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Should be off ACRW thread now so doing SSL handshake.");
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            String string = this.connLink.getLinkConfig().getProperty("com.ibm.ssl.endPointName");
            String string2 = this.connLink.getLinkConfig().getProperty(JSSEHelper.CONNECTION_INFO_IS_WEB_CONTAINER_INBOUND);
            hashMap.put("com.ibm.ssl.endPointName", string);
            hashMap.put(JSSEHelper.CONNECTION_INFO_IS_WEB_CONTAINER_INBOUND, Boolean.valueOf(string2));
            JSSEHelper.getInstance().setInboundConnectionInfo(hashMap);
            SSLUtils.handleHandshake(this.connLink, this.netBuffer, this.decryptedNetBuffer, this.appBuffer, this.encryptedAppBuffer, this.result, this.handshakeCallback, true);
        }
        catch (IOException iOException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "IOException in queued handshake, ioe=" + iOException);
            }
            this.handshakeCallback.error(iOException);
        }
        catch (Throwable throwable) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Throwable in queued handshake, t=" + throwable);
            }
            IOException iOException = new IOException("Queued handshake failure");
            iOException.initCause(throwable);
            this.handshakeCallback.error(iOException);
        }
    }
}

