/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jsse2.ProtoSSLEngine;
import com.ibm.jsse2.ProtoSSLEngineResult;
import com.ibm.jsse2.SSLContext;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.channel.impl.SSLConnectionLink;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeCompletedCallback;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeIOCallback;
import com.ibm.ws.ssl.channel.impl.SSLLinkConfig;
import com.ibm.ws.ssl.channel.impl.SSLQueuedHandshake;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLException;

public class SSLUtils {
    private static final TraceComponent tc = Tr.register(SSLUtils.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private static final String CLASS_NAME = "com.ibm.ws.ssl.channel.impl.SSLUtils";
    private static WsByteBufferPoolManager byteBufferManager = WsByteBufferPoolManagerImpl.getRef();

    public static void shutDownSSLEngine(ProtoSSLEngine protoSSLEngine, WsByteBuffer wsByteBuffer, TCPWriteRequestContext tCPWriteRequestContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "shutDownSSLEngine");
        }
        if (!protoSSLEngine.isInboundDone()) {
            protoSSLEngine.closeInbound();
            SSLUtils.flushCloseDown(protoSSLEngine, wsByteBuffer, tCPWriteRequestContext);
        }
        if (!protoSSLEngine.isOutboundDone()) {
            protoSSLEngine.closeOutbound();
            SSLUtils.flushCloseDown(protoSSLEngine, wsByteBuffer, tCPWriteRequestContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "shutDownSSLEngine");
        }
    }

    private static void flushCloseDown(ProtoSSLEngine protoSSLEngine, WsByteBuffer wsByteBuffer, TCPWriteRequestContext tCPWriteRequestContext) {
        block8: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "flushCloseDown, engine=" + protoSSLEngine.hashCode());
            }
            ProtoSSLEngineResult protoSSLEngineResult = null;
            ProtoSSLEngineResult.Status status = null;
            try {
                do {
                    wsByteBuffer.clear();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "before wrap: " + SSLUtils.getBufferTraceInfo(wsByteBuffer));
                    }
                    protoSSLEngineResult = protoSSLEngine.wrap(null, wsByteBuffer.getWrappedByteBuffer());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "after wrap: " + SSLUtils.getBufferTraceInfo(wsByteBuffer) + "\r\n\tresult=" + protoSSLEngineResult);
                    }
                    tCPWriteRequestContext.setBuffer(wsByteBuffer);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "write bytes: " + wsByteBuffer.remaining());
                    }
                    tCPWriteRequestContext.write((long)wsByteBuffer.remaining(), 0);
                } while ((status = protoSSLEngineResult.getStatus()) != ProtoSSLEngineResult.Status.CLOSED);
            }
            catch (Exception exception) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception caught closing down, " + exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "flushCloseDown");
        }
    }

    public static ByteBuffer[] getWrappedByteBuffers(WsByteBuffer[] wsByteBufferArray) {
        ByteBuffer[] byteBufferArray = new ByteBuffer[wsByteBufferArray.length];
        boolean bl = false;
        int n = 0;
        for (n = 0; n < wsByteBufferArray.length; ++n) {
            if (wsByteBufferArray[n] == null) {
                bl = true;
                break;
            }
            byteBufferArray[n] = wsByteBufferArray[n].getWrappedByteBuffer();
        }
        if (bl) {
            ByteBuffer[] byteBufferArray2 = byteBufferArray;
            byteBufferArray = new ByteBuffer[n];
            for (int i = 0; i < n; ++i) {
                byteBufferArray[i] = byteBufferArray2[i];
            }
        }
        return byteBufferArray;
    }

    public static void limitToCapacity(WsByteBuffer[] wsByteBufferArray) {
        if (wsByteBufferArray != null) {
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                if (wsByteBufferArray[i] == null) continue;
                wsByteBufferArray[i].limit(wsByteBufferArray[i].capacity());
            }
        }
    }

    public static void positionToLimit(WsByteBuffer[] wsByteBufferArray) {
        if (wsByteBufferArray != null) {
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                if (wsByteBufferArray[i] == null) continue;
                wsByteBufferArray[i].position(wsByteBufferArray[i].limit());
            }
        }
    }

    public static void flipBuffersToMark(WsByteBuffer[] wsByteBufferArray, int n, int n2) {
        WsByteBuffer wsByteBuffer = null;
        if (wsByteBufferArray != null) {
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                wsByteBuffer = wsByteBufferArray[i];
                if (wsByteBuffer == null) continue;
                if (i == n2 && n != 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "mark is " + n);
                    }
                    wsByteBuffer.limit(wsByteBuffer.position());
                    wsByteBuffer.position(n);
                    continue;
                }
                wsByteBuffer.flip();
            }
        }
    }

    public static void copyBuffer(WsByteBuffer wsByteBuffer, WsByteBuffer wsByteBuffer2) {
        SSLUtils.copyBuffer(wsByteBuffer, wsByteBuffer2, wsByteBuffer.remaining());
    }

    public static void copyBuffer(WsByteBuffer wsByteBuffer, WsByteBuffer wsByteBuffer2, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "copyBuffer: length=" + n + "\r\n\tsrc: " + SSLUtils.getBufferTraceInfo(wsByteBuffer) + "\r\n\tdst: " + SSLUtils.getBufferTraceInfo(wsByteBuffer2));
        }
        if (wsByteBuffer2.remaining() < n || wsByteBuffer.remaining() < n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "copyBuffer: Not enough space");
            }
            RuntimeException runtimeException = new RuntimeException("Attempt to copy source buffer to inadequate destination buffer");
            FFDCFilter.processException((Throwable)runtimeException, CLASS_NAME, "294", wsByteBuffer);
            throw runtimeException;
        }
        if (wsByteBuffer.hasArray()) {
            int n2 = wsByteBuffer.position() + n;
            wsByteBuffer2.put(wsByteBuffer.array(), wsByteBuffer.arrayOffset() + wsByteBuffer.position(), n);
            wsByteBuffer.position(n2);
        } else {
            byte[] byArray = new byte[n];
            wsByteBuffer.get(byArray, 0, n);
            wsByteBuffer2.put(byArray);
        }
    }

    public static WsByteBuffer allocateByteBuffer(int n, boolean bl) {
        WsByteBuffer wsByteBuffer = null;
        wsByteBuffer = bl ? byteBufferManager.allocateDirect(n) : byteBufferManager.allocate(n);
        wsByteBuffer.limit(wsByteBuffer.capacity());
        return wsByteBuffer;
    }

    public static String getBufferTraceInfo(WsByteBuffer[] wsByteBufferArray) {
        if (null == wsByteBufferArray) {
            return "Null buffer array";
        }
        StringBuilder stringBuilder = new StringBuilder(32 + 64 * wsByteBufferArray.length);
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            stringBuilder.append("\r\n\t  Buffer [");
            stringBuilder.append(i);
            stringBuilder.append("]: ");
            SSLUtils.getBufferTraceInfo(stringBuilder, wsByteBufferArray[i]);
        }
        return stringBuilder.toString();
    }

    public static StringBuilder getBufferTraceInfo(StringBuilder stringBuilder, WsByteBuffer wsByteBuffer) {
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3 = stringBuilder2 = null == stringBuilder ? new StringBuilder(64) : stringBuilder;
        if (null == wsByteBuffer) {
            return stringBuilder2.append("null");
        }
        stringBuilder2.append("hc=");
        stringBuilder2.append(wsByteBuffer.hashCode());
        stringBuilder2.append(" pos=");
        stringBuilder2.append(wsByteBuffer.position());
        stringBuilder2.append(" lim=");
        stringBuilder2.append(wsByteBuffer.limit());
        stringBuilder2.append(" cap=");
        stringBuilder2.append(wsByteBuffer.capacity());
        return stringBuilder2;
    }

    public static String getBufferTraceInfo(WsByteBuffer wsByteBuffer) {
        if (null == wsByteBuffer) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("hc=");
        stringBuilder.append(wsByteBuffer.hashCode());
        stringBuilder.append(" pos=");
        stringBuilder.append(wsByteBuffer.position());
        stringBuilder.append(" lim=");
        stringBuilder.append(wsByteBuffer.limit());
        stringBuilder.append(" cap=");
        stringBuilder.append(wsByteBuffer.capacity());
        return stringBuilder.toString();
    }

    public static String showBufferContents(WsByteBuffer[] wsByteBufferArray) {
        if (null == wsByteBufferArray || 0 == wsByteBufferArray.length) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            stringBuilder.append("Buffer [");
            stringBuilder.append(i);
            if (null == wsByteBufferArray[i]) {
                stringBuilder.append("]: null\r\n");
                continue;
            }
            stringBuilder.append("]: ");
            stringBuilder.append(WsByteBufferUtils.asString((WsByteBuffer)wsByteBufferArray[i]));
            stringBuilder.append("\r\n");
        }
        return stringBuilder.toString();
    }

    public static WsByteBuffer[] allocateByteBuffers(int n, long l, boolean bl, boolean bl2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry(tc, "allocateByteBuffers");
        }
        WsByteBuffer wsByteBuffer = SSLUtils.allocateByteBuffer(n, bl);
        if (bl2) {
            wsByteBuffer.limit(n);
        }
        int n2 = wsByteBuffer.limit();
        int n3 = (int)(l / (long)n2);
        if (l % (long)n2 > 0L) {
            ++n3;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "allocate: requestSize=" + n + ", actualSize=" + n2 + ", totSize=" + l + ", numBufs=" + n3);
        }
        WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[n3];
        wsByteBufferArray[0] = wsByteBuffer;
        for (int i = 1; i < wsByteBufferArray.length; ++i) {
            wsByteBufferArray[i] = SSLUtils.allocateByteBuffer(n, bl);
            if (!bl2) continue;
            wsByteBuffer.limit(n);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit(tc, "allocateByteBuffers");
        }
        return wsByteBufferArray;
    }

    public static boolean anyPositionsNonZero(WsByteBuffer[] wsByteBufferArray) {
        if (wsByteBufferArray != null) {
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                if (wsByteBufferArray[i] == null || wsByteBufferArray[i].position() == 0) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProtoSSLEngineResult handleHandshake(SSLConnectionLink sSLConnectionLink, WsByteBuffer object, WsByteBuffer wsByteBuffer, WsByteBuffer wsByteBuffer2, WsByteBuffer wsByteBuffer3, ProtoSSLEngineResult protoSSLEngineResult, SSLHandshakeCompletedCallback sSLHandshakeCompletedCallback, boolean bl) throws IOException, ReadOnlyBufferException {
        void var1_2;
        void var7_9;
        ProtoSSLEngineResult.Status status;
        ProtoSSLEngineResult protoSSLEngineResult2;
        void var4_6;
        void var3_5;
        void var2_4;
        void var6_8;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleHandshake, engine=" + sSLConnectionLink.getSSLEngine().hashCode());
        }
        if (sSLConnectionLink.getChannel().isZOSCR && var6_8 != null && !(Thread.currentThread() instanceof ThreadPool.DecoratedCRThread)) {
            if (sSLConnectionLink.isQueuedHandshake()) {
                FFDCFilter.processException(new Exception("SSL handshake on non-decorated thread"), "com.ibm.ws.ssl.channel.impl.SSLUtils.handleHandshake", "535");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Handshake on non-decorated thread; however already queued once");
                }
            } else {
                void var11_21;
                Object object2;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting off ACRW thread");
                }
                Map map = JSSEHelper.getInstance().getInboundConnectionInfo();
                Properties properties = sSLConnectionLink.getLinkConfig().getProperties();
                if (map != null) {
                    Boolean bl2;
                    object2 = (String)map.get("com.ibm.ssl.endPointName");
                    if (object2 != null) {
                        properties.put("com.ibm.ssl.endPointName", object2);
                    }
                    if ((bl2 = (Boolean)map.get(JSSEHelper.CONNECTION_INFO_IS_WEB_CONTAINER_INBOUND)) != null) {
                        properties.put(JSSEHelper.CONNECTION_INFO_IS_WEB_CONTAINER_INBOUND, bl2.toString());
                    }
                    SSLLinkConfig sSLLinkConfig = new SSLLinkConfig(properties);
                    sSLConnectionLink.setLinkConfig(sSLLinkConfig);
                }
                object2 = new SSLQueuedHandshake(sSLConnectionLink, (WsByteBuffer)object, (WsByteBuffer)var2_4, (WsByteBuffer)var3_5, (WsByteBuffer)var4_6, protoSSLEngineResult2, (SSLHandshakeCompletedCallback)var6_8);
                Object var11_17 = null;
                try {
                    int n = sSLConnectionLink.getThreadPool().execute((Runnable)object2, 2);
                    if (n != 0) {
                        ChannelException channelException = new ChannelException("threadpool at capacity, request rejected");
                    }
                }
                catch (ChannelException channelException) {
                    ChannelException channelException2 = channelException;
                }
                if (var11_21 != null) {
                    FFDCFilter.processException((Throwable)var11_21, CLASS_NAME, "581", (Object)sSLConnectionLink);
                    var6_8.error(new IOException(var11_21.toString()));
                }
                return null;
            }
        }
        sSLConnectionLink.setQueuedHandshake(false);
        ProtoSSLEngine protoSSLEngine = sSLConnectionLink.getSSLEngine();
        TCPReadRequestContext tCPReadRequestContext = sSLConnectionLink.getDeviceReadInterface();
        TCPWriteRequestContext tCPWriteRequestContext = sSLConnectionLink.getDeviceWriteInterface();
        boolean bl3 = false;
        boolean bl4 = true;
        ProtoSSLEngineResult.Status status2 = status = protoSSLEngineResult2 == null ? ProtoSSLEngineResult.Status.HS_NEED_WRAP : protoSSLEngineResult2.getStatus();
        if (var7_9 != false && status == ProtoSSLEngineResult.Status.BUFFER_UNDERFLOW) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "From callback, former status BUFFER_UNDERFLOW.");
            }
            object.limit(object.position());
            object.reset();
            status = ProtoSSLEngineResult.Status.HS_NEED_UNWRAP;
        }
        while (protoSSLEngine.isHandshaking() || status != ProtoSSLEngineResult.Status.HS_FINISHED && status != ProtoSSLEngineResult.Status.OK) {
            VirtualConnection virtualConnection;
            Object object3;
            block63: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "status=" + status);
                }
                if (status == ProtoSSLEngineResult.Status.HS_FINISHED) {
                    if (!sSLConnectionLink.getChannel().isZOS) break;
                    JSSEHelper.getInstance().setSSLPropertiesOnThread(null);
                    break;
                }
                if (status == ProtoSSLEngineResult.Status.HS_NEED_WRAP) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "before wrap: \r\n\tencBuf: " + SSLUtils.getBufferTraceInfo((WsByteBuffer)var4_6));
                    }
                    protoSSLEngineResult2 = protoSSLEngine.wrap(null, var4_6.getWrappedByteBuffer());
                    int n = protoSSLEngineResult2.outBytesProduced();
                    status = protoSSLEngineResult2.getStatus();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "after wrap: \r\n\tencBuf: " + SSLUtils.getBufferTraceInfo((WsByteBuffer)var4_6) + "\r\n\tstatus=" + status + " consumed=" + protoSSLEngineResult2.inBytesConsumed() + " produced=" + protoSSLEngineResult2.outBytesProduced());
                    }
                    if (0 < n) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "Write bytes: " + n);
                        }
                        tCPWriteRequestContext.setBuffer((WsByteBuffer)var4_6);
                        if (var6_8 != null) {
                            object3 = new SSLHandshakeIOCallback(sSLConnectionLink, (WsByteBuffer)var1_2, (WsByteBuffer)var2_4, (WsByteBuffer)var3_5, (WsByteBuffer)var4_6, protoSSLEngineResult2, (SSLHandshakeCompletedCallback)var6_8);
                            virtualConnection = tCPWriteRequestContext.write((long)n, (TCPWriteCompletedCallback)object3, false, 0);
                            if (virtualConnection != null) {
                                var4_6.clear();
                                break block63;
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Write is not done.  Callback will be used.");
                                }
                                protoSSLEngineResult2 = null;
                                break;
                            }
                        }
                        tCPWriteRequestContext.write((long)n, 0);
                        var4_6.clear();
                    } else {
                        var4_6.clear();
                    }
                }
            }
            while (status == ProtoSSLEngineResult.Status.HS_NEED_TASK) {
                object3 = protoSSLEngine.getDelegatedTask();
                if (object3 != null) {
                    object3.run();
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "After task: sslEngine.isHandshaking=" + protoSSLEngine.isHandshaking());
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "No task, setting status to HS_NEED_WRAP");
                }
                status = ProtoSSLEngineResult.Status.HS_NEED_WRAP;
            }
            if (status == ProtoSSLEngineResult.Status.HS_NEED_UNWRAP || status == ProtoSSLEngineResult.Status.BUFFER_UNDERFLOW) {
                block64: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Get ready to decrypt data, netBuf: " + SSLUtils.getBufferTraceInfo((WsByteBuffer)var1_2));
                    }
                    if (var1_2.remaining() == var1_2.capacity() && status == ProtoSSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        object3 = SSLUtils.allocateByteBuffer(protoSSLEngine.getPacketBufferSize(), false);
                        SSLUtils.copyBuffer((WsByteBuffer)var1_2, (WsByteBuffer)object3);
                        object3.flip();
                        var1_2.release();
                        Runnable runnable = object3;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Had to grow the netBuf: " + SSLUtils.getBufferTraceInfo((WsByteBuffer)runnable));
                        }
                    }
                    if (ProtoSSLEngineResult.Status.BUFFER_UNDERFLOW == status || !var1_2.hasRemaining() && !bl4 || var1_2.remaining() == var1_2.capacity() && (!bl4 || ProtoSSLEngineResult.Status.BUFFER_UNDERFLOW != status2)) {
                        tCPReadRequestContext.setBuffer((WsByteBuffer)var1_2);
                        if (!var1_2.hasRemaining() || var1_2.remaining() == var1_2.capacity()) {
                            var1_2.clear();
                            var1_2.mark();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Nothing was in the buffer");
                            }
                        } else {
                            var1_2.mark();
                            var1_2.position(var1_2.limit());
                            var1_2.limit(var1_2.capacity());
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Existing data in netBuf: " + SSLUtils.getBufferTraceInfo((WsByteBuffer)var1_2));
                            }
                        }
                        if (var6_8 != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Do async read");
                            }
                            if ((virtualConnection = tCPReadRequestContext.read(1L, (TCPReadCompletedCallback)(object3 = new SSLHandshakeIOCallback(sSLConnectionLink, (WsByteBuffer)var1_2, (WsByteBuffer)var2_4, (WsByteBuffer)var3_5, (WsByteBuffer)var4_6, protoSSLEngineResult2, (SSLHandshakeCompletedCallback)var6_8)), false, 0)) != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Read already done.  No callback necessary.");
                                }
                                var1_2.limit(var1_2.position());
                                var1_2.reset();
                                break block64;
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Read is not done.  Callback will be used.");
                                }
                                protoSSLEngineResult2 = null;
                                break;
                            }
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Do sync read");
                        }
                        long l = 0L;
                        while (l == 0L) {
                            l = tCPReadRequestContext.read(1L, 0);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                            Tr.event(tc, "Read bytes: " + l);
                        }
                        var1_2.limit(var1_2.position());
                        var1_2.reset();
                    } else {
                        if (!var1_2.hasRemaining() && bl4) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Callback came back with data that needs to be flipped.");
                            }
                            var1_2.flip();
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "Data already in netBuf: " + SSLUtils.getBufferTraceInfo((WsByteBuffer)var1_2));
                        }
                    }
                }
                if (0 != var1_2.position() && var1_2.limit() == var1_2.capacity() && bl4 && ProtoSSLEngineResult.Status.BUFFER_UNDERFLOW != status2) {
                    var1_2.limit(var1_2.position());
                    var1_2.reset();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "before unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo((WsByteBuffer)var1_2) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo((WsByteBuffer)var2_4));
                }
                protoSSLEngineResult2 = protoSSLEngine.unwrap(var1_2.getWrappedByteBuffer(), var2_4.getWrappedByteBuffer());
                status = protoSSLEngineResult2.getStatus();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "after unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo((WsByteBuffer)var1_2) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo((WsByteBuffer)var2_4) + "\r\n\tstatus=" + status + " consumed=" + protoSSLEngineResult2.inBytesConsumed() + " produced=" + protoSSLEngineResult2.outBytesProduced());
                }
                if (var1_2.remaining() == 0) {
                    var1_2.clear();
                }
            }
            if (status == ProtoSSLEngineResult.Status.BUFFER_OVERFLOW) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "BUFFER_OVERFLOW occured during handshake: " + status);
                }
                throw new SSLException("BUFFER_OVERFLOW occured during handshake: " + status);
            }
            if (status == ProtoSSLEngineResult.Status.CLOSED) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Handshake terminated SSL engine: " + status);
                }
                throw new SSLException("Handshake terminated SSL engine: " + status);
            }
            bl4 = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "after handshake loop, status=" + status + ", fromCallback=" + (boolean)var7_9 + ", engine=" + protoSSLEngine.hashCode() + "\r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo((WsByteBuffer)var1_2) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo((WsByteBuffer)var2_4));
        }
        if (var7_9 != false && protoSSLEngineResult2 != null) {
            var6_8.complete(protoSSLEngineResult2);
            protoSSLEngineResult2 = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleHandshake");
        }
        return protoSSLEngineResult2;
    }

    public static void handleHandshake(ProtoSSLEngine protoSSLEngine, ProtoSSLEngine protoSSLEngine2) throws SSLException {
        WsByteBuffer wsByteBuffer;
        WsByteBuffer wsByteBuffer2;
        WsByteBuffer wsByteBuffer3;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleHandshake");
        }
        if (protoSSLEngine == null || protoSSLEngine2 == null) {
            throw new SSLException("Null engine found: engine1=" + protoSSLEngine + ", engine2=" + protoSSLEngine2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parameters: engine1=" + protoSSLEngine.hashCode() + ", engine2=" + protoSSLEngine2.hashCode());
        }
        WsByteBuffer wsByteBuffer4 = wsByteBuffer3 = SSLUtils.allocateByteBuffer(protoSSLEngine.getPacketBufferSize(), false);
        WsByteBuffer wsByteBuffer5 = wsByteBuffer2 = SSLUtils.allocateByteBuffer(protoSSLEngine.getApplicationBufferSize(), false);
        WsByteBuffer wsByteBuffer6 = wsByteBuffer = SSLUtils.allocateByteBuffer(protoSSLEngine.getPacketBufferSize(), false);
        Runnable runnable = null;
        ProtoSSLEngine protoSSLEngine3 = null;
        ProtoSSLEngineResult.Status status = null;
        ProtoSSLEngineResult.Status status2 = ProtoSSLEngineResult.Status.HS_NEED_WRAP;
        ProtoSSLEngineResult.Status status3 = ProtoSSLEngineResult.Status.HS_NEED_UNWRAP;
        protoSSLEngine.beginHandshake();
        protoSSLEngine2.beginHandshake();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "current engine= " + protoSSLEngine.hashCode() + ", status=" + status2);
        }
        while (protoSSLEngine.isHandshaking() || protoSSLEngine2.isHandshaking() || status2 != ProtoSSLEngineResult.Status.HS_FINISHED || status3 != ProtoSSLEngineResult.Status.HS_FINISHED) {
            ProtoSSLEngineResult protoSSLEngineResult;
            if (status2 == ProtoSSLEngineResult.Status.HS_NEED_WRAP && wsByteBuffer6.limit() == wsByteBuffer6.capacity()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "before wrap: encBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer6));
                }
                protoSSLEngineResult = protoSSLEngine.wrap(null, wsByteBuffer6.getWrappedByteBuffer());
                status2 = protoSSLEngineResult.getStatus();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "after wrap: encBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer6) + "\r\n\tstatus=" + protoSSLEngineResult.getStatus() + " consumed=" + protoSSLEngineResult.inBytesConsumed() + " produced=" + protoSSLEngineResult.outBytesProduced());
                }
            } else if ((status2 == ProtoSSLEngineResult.Status.HS_FINISHED || status2 == ProtoSSLEngineResult.Status.HS_NEED_UNWRAP) && wsByteBuffer4.limit() != wsByteBuffer4.capacity()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "before unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer4) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer5));
                }
                protoSSLEngineResult = protoSSLEngine.unwrap(wsByteBuffer4.getWrappedByteBuffer(), wsByteBuffer5.getWrappedByteBuffer());
                status2 = protoSSLEngineResult.getStatus();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "after unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer4) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer5) + "\r\n\tstatus=" + protoSSLEngineResult.getStatus() + " consumed=" + protoSSLEngineResult.inBytesConsumed() + " produced=" + protoSSLEngineResult.outBytesProduced());
                }
                if (wsByteBuffer4.remaining() == 0) {
                    wsByteBuffer4.clear();
                }
            } else if (status2 != ProtoSSLEngineResult.Status.HS_NEED_UNWRAP && status2 != ProtoSSLEngineResult.Status.HS_NEED_WRAP && status2 != ProtoSSLEngineResult.Status.HS_FINISHED && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected status: " + status2);
                throw new SSLException("Unexpected status: " + status2);
            }
            if (status2 == ProtoSSLEngineResult.Status.HS_NEED_TASK) {
                while (status2 == ProtoSSLEngineResult.Status.HS_NEED_TASK) {
                    runnable = protoSSLEngine.getDelegatedTask();
                    if (runnable != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Run task");
                        }
                        runnable.run();
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "After task: sslEngine.isHandshaking=" + protoSSLEngine.isHandshaking());
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "No task, setting status to HS_NEED_WRAP");
                    }
                    status2 = ProtoSSLEngineResult.Status.HS_NEED_WRAP;
                }
                if (status2 == ProtoSSLEngineResult.Status.HS_NEED_WRAP) continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Switching engines");
            }
            wsByteBuffer4 = wsByteBuffer6;
            protoSSLEngine3 = protoSSLEngine;
            protoSSLEngine = protoSSLEngine2;
            protoSSLEngine2 = protoSSLEngine3;
            status = status2;
            status2 = status3;
            status3 = status;
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "current engine= " + protoSSLEngine.hashCode() + ", status=" + status2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleHandshake");
        }
    }

    public static ProtoSSLEngine getOutboundSSLEngine(SSLContext sSLContext, SSLLinkConfig sSLLinkConfig, String string, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutboundSSLEngine, host=" + string + ", port=" + n);
        }
        ProtoSSLEngine protoSSLEngine = sSLContext.createProtoSSLEngine(string, n);
        SSLUtils.configureEngine(protoSSLEngine, FlowType.OUTBOUND, sSLLinkConfig);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutboundSSLEngine, hc=" + protoSSLEngine.hashCode());
        }
        return protoSSLEngine;
    }

    public static ProtoSSLEngine getSSLEngine(SSLContext sSLContext, FlowType flowType, SSLLinkConfig sSLLinkConfig) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLEngine");
        }
        ProtoSSLEngine protoSSLEngine = sSLContext.createProtoSSLEngine();
        SSLUtils.configureEngine(protoSSLEngine, flowType, sSLLinkConfig);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLEngine, hc=" + protoSSLEngine.hashCode());
        }
        return protoSSLEngine;
    }

    private static void configureEngine(ProtoSSLEngine protoSSLEngine, FlowType flowType, SSLLinkConfig sSLLinkConfig) {
        protoSSLEngine.setEnabledCipherSuites(sSLLinkConfig.getEnabledCipherSuites(protoSSLEngine));
        if (flowType == FlowType.INBOUND) {
            protoSSLEngine.setUseClientMode(false);
            boolean bl = sSLLinkConfig.getBooleanProperty("com.ibm.ssl.clientAuthentication");
            if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                String string;
                Map map;
                Object object;
                Object object2;
                GenericDeclaration genericDeclaration;
                Boolean bl2 = Boolean.FALSE;
                String string2 = null;
                try {
                    Class<?> clazz = Class.forName("com.ibm.ws.security.core.SecurityConfig");
                    genericDeclaration = clazz.getMethod("getConfig", null);
                    object2 = ((Method)genericDeclaration).invoke(null, null);
                    object = clazz.getMethod("getValue", String.class);
                    string2 = (String)((Method)object).invoke(object2, "security.activeUserRegistryType");
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No class, object, or method found for SecurityConfig", new Object[]{exception});
                    }
                    FFDCFilter.processException(exception, "com.ibm.ws.ssl.channel.impls.SSLUtils", "1129");
                }
                if ("LOCALOS".equals(string2) && (map = JSSEHelper.getInstance().getInboundConnectionInfo()) != null && (string = (String)map.get("com.ibm.ssl.endPointName")) != null && string.startsWith("WC_")) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "The endpoint, " + string + ", is web and we are on z/OS. Proceeding to get the mutualAuthCbindCheck property.");
                    }
                    try {
                        genericDeclaration = Class.forName("com.ibm.ws.security.zOS.NativeConfiguration");
                        object2 = ((Class)genericDeclaration).getMethod("getConfig", null);
                        object = ((Method)object2).invoke((Object)null, (Object[])null);
                        Method method2 = ((Class)genericDeclaration).getMethod("isMutualAuthCBINDCheckEnabled", null);
                        bl2 = (Boolean)method2.invoke(object, (Object[])null);
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No class, object, or method found for CBIND check", new Object[]{exception});
                        }
                        FFDCFilter.processException(exception, "com.ibm.ws.ssl.channel.impls.SSLUtils", "1159");
                    }
                    if (bl2.booleanValue()) {
                        bl = bl2;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "The mutualAuthCBINDCheck is true, so hard-coded setNeedClientAuth to true.");
                        }
                    }
                }
            }
            protoSSLEngine.setNeedClientAuth(bl);
            if (!bl) {
                bl = sSLLinkConfig.getBooleanProperty("com.ibm.ssl.clientAuthenticationSupported");
                protoSSLEngine.setWantClientAuth(bl);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Client auth supported is " + protoSSLEngine.getWantClientAuth());
                }
            }
        } else {
            protoSSLEngine.setUseClientMode(true);
        }
        protoSSLEngine.beginHandshake();
    }

    public static int[] adjustBuffersForJSSE(WsByteBuffer[] wsByteBufferArray, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "adjustBuffersForJSSE");
        }
        int[] nArray = null;
        int n2 = 0;
        for (int i = 0; i < wsByteBufferArray.length && wsByteBufferArray[i] != null; ++i) {
            if ((n2 += wsByteBufferArray[i].remaining()) > n) {
                int n3 = wsByteBufferArray[i].limit();
                nArray = new int[]{i, n3};
                int n4 = n2 - n;
                wsByteBufferArray[i].limit(n3 - n4);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug(tc, "adjusted limit of buffer [" + i + "] from " + n3 + " to " + wsByteBufferArray[i].limit());
                break;
            }
            if (n2 == n) break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "adjustBuffersForJSSE");
        }
        return nArray;
    }

    public static void resetBuffersAfterJSSE(WsByteBuffer[] wsByteBufferArray, int[] nArray) {
        WsByteBuffer wsByteBuffer;
        if (nArray == null) {
            return;
        }
        int n = nArray[0];
        int n2 = nArray[1];
        if (wsByteBufferArray.length > n && (wsByteBuffer = wsByteBufferArray[n]) != null && wsByteBuffer.capacity() >= n2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "resetBuffersAfterJSSE: buffer [" + n + "] from " + wsByteBuffer.limit() + " to " + n2);
            }
            wsByteBuffer.limit(n2);
        }
    }

    public static void getBufferLimits(WsByteBuffer[] wsByteBufferArray, int[] nArray) {
        if (wsByteBufferArray != null && nArray != null) {
            for (int i = 0; i < wsByteBufferArray.length && i < nArray.length; ++i) {
                if (wsByteBufferArray[i] != null) {
                    nArray[i] = wsByteBufferArray[i].limit();
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "getBufferLimits: buffer[" + i + "] limit of " + nArray[i]);
                    continue;
                }
                nArray[i] = 0;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "getBufferLimits: null buffer[" + i + "] limit of " + nArray[i]);
            }
        }
    }

    public static void setBufferLimits(WsByteBuffer[] wsByteBufferArray, int[] nArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setBufferLimits");
        }
        if (wsByteBufferArray != null && nArray != null) {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < wsByteBufferArray.length && i < nArray.length; ++i) {
                if (wsByteBufferArray[i] == null) continue;
                n = wsByteBufferArray[i].capacity();
                n2 = nArray[i];
                if (wsByteBufferArray[i].limit() == n2) continue;
                if (n >= n2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Buffer [" + i + "] being updated from " + wsByteBufferArray[i].limit() + " to " + n2);
                    }
                    wsByteBufferArray[i].limit(n2);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Buffer [" + i + "] has capacity " + n + " less than passed in limit " + n2);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setBufferLimits");
        }
    }
}

