/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jsse2.ProtoSSLEngine;
import com.ibm.jsse2.ProtoSSLEngineResult;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.channel.impl.SSLBaseServiceContext;
import com.ibm.ws.ssl.channel.impl.SSLConnectionLink;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeCompletedCallback;
import com.ibm.ws.ssl.channel.impl.SSLUtils;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.nio.ReadOnlyBufferException;

public class SSLWriteServiceContext
extends SSLBaseServiceContext
implements TCPWriteRequestContext,
TCPWriteCompletedCallback {
    protected static final TraceComponent tc = Tr.register(SSLWriteServiceContext.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private static final String CLASS_NAME = "com.ibm.ws.ssl.channel.imp.SSLWriteServiceContext";
    protected TCPWriteCompletedCallback callback = null;
    protected WsByteBuffer[] encryptedAppBuffers = null;
    protected TCPWriteRequestContext deviceWriteContext;
    private QueuedWork queuedWork = new QueuedWork();
    MyHandshakeCompletedCallback handshakeCallback = new MyHandshakeCompletedCallback(this);

    public SSLWriteServiceContext(SSLConnectionLink sSLConnectionLink) {
        super(sSLConnectionLink);
    }

    public long write(long l, int n) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "write, numBytes=" + l + ", timeout=" + n + ", vc=" + this.myVCHashCode);
        }
        if (this.deviceWriteContext == null) {
            this.deviceWriteContext = this.connectionLink.getDeviceWriteInterface();
        }
        if (n == -2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Requested to timeout former request.  Calling device side.");
            }
            this.deviceWriteContext.write(l, n);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "write");
            }
            return 0L;
        }
        IOException iOException = this.checkForErrors(l, false);
        if (iOException != null) {
            throw iOException;
        }
        long l2 = 0L;
        ProtoSSLEngineResult protoSSLEngineResult = null;
        long l3 = WsByteBufferUtils.lengthOf((WsByteBuffer[])this.getBuffers());
        if (l == -1L) {
            l = l3;
        }
        if (this.connectionLink.getSSLEngine().isHandshaking()) {
            try {
                protoSSLEngineResult = this.doHandshake(null);
            }
            catch (IOException iOException2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught during handshake, " + iOException2);
                }
                FFDCFilter.processException((Throwable)iOException2, CLASS_NAME, "84", this);
                throw iOException2;
            }
            if (protoSSLEngineResult.getStatus() != ProtoSSLEngineResult.Status.HS_FINISHED) {
                IOException iOException3 = new IOException("Unable to complete SSLhandshake");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to complete SSLhandshake, " + iOException3);
                }
                FFDCFilter.processException((Throwable)iOException3, CLASS_NAME, "117", this);
                throw iOException3;
            }
        }
        if ((iOException = this.encryptMessage(l)) == null) {
            int n2 = WsByteBufferUtils.lengthOf((WsByteBuffer[])this.encryptedAppBuffers);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "write bytes: " + n2);
            }
            long l4 = this.deviceWriteContext.write((long)n2, n);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "wrote " + l4 + " bytes to the network");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught during encryption, " + iOException);
            }
            FFDCFilter.processException((Throwable)iOException, CLASS_NAME, "109", this);
            throw iOException;
        }
        l2 = l3 - (long)WsByteBufferUtils.lengthOf((WsByteBuffer[])this.getBuffers());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "write");
        }
        return l2;
    }

    public VirtualConnection write(long l, TCPWriteCompletedCallback tCPWriteCompletedCallback, boolean bl, int n) {
        return this.write(l, tCPWriteCompletedCallback, bl, n, false);
    }

    protected VirtualConnection write(long l, TCPWriteCompletedCallback tCPWriteCompletedCallback, boolean bl, int n, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeAsync, numBytes=" + l + ", timeout=" + n + ", fromQueue=" + bl2 + ", vc=" + this.myVCHashCode);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TCPWriteContext=" + this.hashCode());
        }
        if (this.deviceWriteContext == null) {
            this.deviceWriteContext = this.connectionLink.getDeviceWriteInterface();
        }
        if (n == -2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Requested to timeout former request.  Calling device side.");
            }
            this.deviceWriteContext.write(l, (TCPWriteCompletedCallback)this, bl, n);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeAsync");
            }
            return this.myVC;
        }
        IOException iOException = this.checkForErrors(l, true);
        if (iOException != null) {
            if (bl) {
                this.queuedWork.setErrorParameters(this.connectionLink.getVirtualConnection(), this, tCPWriteCompletedCallback, iOException);
                ChannelException channelException = null;
                try {
                    int n2 = this.connectionLink.getThreadPool().execute((Runnable)this.queuedWork, 2);
                    if (n2 != 0) {
                        channelException = new ChannelException("threadpool at capacity, request rejected");
                    }
                }
                catch (ChannelException channelException2) {
                    channelException = channelException2;
                }
                if (channelException != null) {
                    FFDCFilter.processException((Throwable)channelException, CLASS_NAME, "172", this);
                    tCPWriteCompletedCallback.error(this.connectionLink.getVirtualConnection(), (TCPWriteRequestContext)this, iOException);
                }
            } else {
                tCPWriteCompletedCallback.error(this.connectionLink.getVirtualConnection(), (TCPWriteRequestContext)this, iOException);
            }
            return null;
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Forcing write request to another thread, vc=" + this.myVCHashCode);
            }
            this.queuedWork.setWriteParameters(l, tCPWriteCompletedCallback, n);
            ChannelException channelException = null;
            try {
                int n3 = this.connectionLink.getThreadPool().execute((Runnable)this.queuedWork, 2);
                if (n3 != 0) {
                    channelException = new ChannelException("threadpool at capacity, request rejected");
                }
            }
            catch (ChannelException channelException3) {
                channelException = channelException3;
            }
            if (channelException != null) {
                FFDCFilter.processException((Throwable)channelException, CLASS_NAME, "294", this);
                tCPWriteCompletedCallback.error(this.connectionLink.getVirtualConnection(), (TCPWriteRequestContext)this, new IOException(channelException.getMessage()));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeAsync");
            }
            return null;
        }
        this.callback = tCPWriteCompletedCallback;
        if (l == -1L) {
            l = WsByteBufferUtils.lengthOf((WsByteBuffer[])this.getBuffers());
        }
        VirtualConnection virtualConnection = null;
        ProtoSSLEngineResult protoSSLEngineResult = null;
        if (this.connectionLink.getSSLEngine().isHandshaking()) {
            this.handshakeCallback.setWriteParameters(l, n);
            try {
                protoSSLEngineResult = this.doHandshake(this.handshakeCallback);
            }
            catch (IOException iOException2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught exception during SSL handshake, " + iOException2);
                }
                FFDCFilter.processException((Throwable)iOException2, CLASS_NAME, "152", this);
                this.callback.error(this.connectionLink.getVirtualConnection(), (TCPWriteRequestContext)this, iOException2);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "writeAsynch");
                }
                return null;
            }
            if (protoSSLEngineResult != null) {
                if (protoSSLEngineResult.getStatus() != ProtoSSLEngineResult.Status.HS_FINISHED) {
                    IOException iOException3 = new IOException("Unable to complete SSLhandshake");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unable to complete SSLhandshake, " + iOException3);
                    }
                    FFDCFilter.processException((Throwable)iOException3, CLASS_NAME, "157", this);
                    this.callback.error(this.connectionLink.getVirtualConnection(), (TCPWriteRequestContext)this, iOException3);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "writeAsynch");
                    }
                    return null;
                }
            } else {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "writeAsynch");
                }
                return null;
            }
        }
        if ((virtualConnection = this.encryptAndWriteAsync(l, false, n)) != null && bl2) {
            this.callback.complete(virtualConnection, (TCPWriteRequestContext)this);
            virtualConnection = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeAsynch");
        }
        return virtualConnection;
    }

    private IOException checkForErrors(long l, boolean bl) {
        WsByteBuffer[] wsByteBufferArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForErrors");
        }
        IOException iOException = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "numBytes=" + l + " buffers=" + SSLUtils.getBufferTraceInfo(this.getBuffers()));
        }
        if ((wsByteBufferArray = this.getBuffers()) == null || wsByteBufferArray.length == 0) {
            iOException = new IOException("No buffer(s) provided for writing data.");
        } else if (l < -1L || l == 0L && bl) {
            iOException = new IOException("Number of bytes requested, " + l + " is not valid.");
        } else {
            int n = WsByteBufferUtils.lengthOf((WsByteBuffer[])wsByteBufferArray);
            if ((long)n < l) {
                iOException = new IOException("Number of bytes requested, " + l + " exceeds space remaining in the buffers provided: " + n);
            }
        }
        if (tc.isDebugEnabled() && iOException != null) {
            Tr.debug(tc, "Found error in data, exception generated: " + iOException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForErrors");
        }
        return iOException;
    }

    public VirtualConnection encryptAndWriteAsync(long l, boolean bl, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptAndWriteAsync");
        }
        VirtualConnection virtualConnection = null;
        IOException iOException = this.encryptMessage(l);
        if (iOException == null) {
            int n2 = WsByteBufferUtils.lengthOf((WsByteBuffer[])this.encryptedAppBuffers);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "write bytes: " + n2);
            }
            virtualConnection = this.deviceWriteContext.write((long)n2, (TCPWriteCompletedCallback)this, bl, n);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception during encryption, " + iOException);
            }
            this.callback.error(this.connectionLink.getVirtualConnection(), (TCPWriteRequestContext)this, iOException);
            virtualConnection = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptAndWriteAsync");
        }
        return virtualConnection;
    }

    private ProtoSSLEngineResult doHandshake(MyHandshakeCompletedCallback myHandshakeCompletedCallback) throws IOException {
        ProtoSSLEngineResult protoSSLEngineResult;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doHandshake");
        }
        ProtoSSLEngine protoSSLEngine = this.connectionLink.getSSLEngine();
        WsByteBuffer wsByteBuffer = SSLUtils.allocateByteBuffer(protoSSLEngine.getPacketBufferSize(), true);
        WsByteBuffer wsByteBuffer2 = SSLUtils.allocateByteBuffer(protoSSLEngine.getApplicationBufferSize(), false);
        WsByteBuffer wsByteBuffer3 = SSLUtils.allocateByteBuffer(protoSSLEngine.getApplicationBufferSize(), false);
        this.encryptedAppBuffers = this.getEncryptedAppBuffers(1L);
        myHandshakeCompletedCallback.setAppBuffer(wsByteBuffer3);
        myHandshakeCompletedCallback.setNetBuffer(wsByteBuffer);
        myHandshakeCompletedCallback.setDecryptedNetBuffer(wsByteBuffer2);
        try {
            protoSSLEngineResult = SSLUtils.handleHandshake(this.connectionLink, wsByteBuffer, wsByteBuffer2, wsByteBuffer3, this.encryptedAppBuffers[0], null, myHandshakeCompletedCallback, false);
        }
        catch (IOException iOException) {
            wsByteBuffer3.release();
            wsByteBuffer.release();
            wsByteBuffer2.release();
            throw iOException;
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            wsByteBuffer3.release();
            wsByteBuffer.release();
            wsByteBuffer2.release();
            throw new IOException("Caught exception during handshake: " + readOnlyBufferException);
        }
        if (protoSSLEngineResult != null) {
            wsByteBuffer3.release();
            wsByteBuffer.release();
            wsByteBuffer2.release();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doHandshake");
        }
        return protoSSLEngineResult;
    }

    private IOException encryptMessage(long l) {
        IOException iOException;
        block15: {
            ProtoSSLEngineResult.Status status;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "encryptMessage, numBytes=" + l);
            }
            iOException = null;
            this.encryptedAppBuffers = this.getEncryptedAppBuffers(l);
            WsByteBuffer[] wsByteBufferArray = this.getBuffers();
            int n = 0;
            while (true) {
                int[] nArray = SSLUtils.adjustBuffersForJSSE(wsByteBufferArray, this.connectionLink.getSSLEngine().getApplicationBufferSize());
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "before wrap:\r\nappBuffers " + SSLUtils.getBufferTraceInfo(wsByteBufferArray) + "\r\nencAppBuffers " + SSLUtils.getBufferTraceInfo(this.encryptedAppBuffers));
                }
                ProtoSSLEngineResult protoSSLEngineResult = null;
                try {
                    protoSSLEngineResult = this.connectionLink.getSSLEngine().wrap(SSLUtils.getWrappedByteBuffers(wsByteBufferArray), SSLUtils.getWrappedByteBuffers(this.encryptedAppBuffers));
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                    break block15;
                }
                status = protoSSLEngineResult.getStatus();
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "after wrap:\r\nappBuffers " + SSLUtils.getBufferTraceInfo(wsByteBufferArray) + "\r\nencAppBuffers " + SSLUtils.getBufferTraceInfo(this.encryptedAppBuffers) + "\r\nstatus=" + status + " consumed=" + protoSSLEngineResult.inBytesConsumed() + " produced=" + protoSSLEngineResult.outBytesProduced());
                }
                if (nArray != null) {
                    SSLUtils.resetBuffersAfterJSSE(wsByteBufferArray, nArray);
                }
                n += protoSSLEngineResult.inBytesConsumed();
                if (status == ProtoSSLEngineResult.Status.OK) {
                    if ((long)n < l) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "More encryption needed: bytesToEncrypt=" + l + " bytesEncrypted=" + n);
                        }
                        SSLUtils.positionToLimit(this.encryptedAppBuffers);
                        SSLUtils.limitToCapacity(this.encryptedAppBuffers);
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "OK result from the SSL engine");
                    }
                    break block15;
                }
                if (status != ProtoSSLEngineResult.Status.BUFFER_OVERFLOW) break;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "BUFFER_OVERFLOW result from the SSL engine");
                }
                this.encryptedAppBuffers = this.getMoreEncryptedAppBuffers();
            }
            iOException = new IOException("Unable to encrypt data, status=" + status);
        }
        if (iOException == null) {
            for (int i = 0; i < this.encryptedAppBuffers.length; ++i) {
                this.encryptedAppBuffers[i].position(0);
            }
            this.connectionLink.getDeviceWriteInterface().setBuffers(this.encryptedAppBuffers);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptMessage");
        }
        return iOException;
    }

    protected WsByteBuffer[] getMoreEncryptedAppBuffers() {
        if (this.encryptedAppBuffers == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Allocating encryptedAppBuffer, we have to release this.");
            }
            this.encryptedAppBuffers = new WsByteBuffer[1];
            this.encryptedAppBuffers[0] = SSLUtils.allocateByteBuffer(this.connectionLink.getSSLEngine().getPacketBufferSize(), this.config.getEncryptBuffersDirect());
        } else {
            WsByteBuffer[] wsByteBufferArray = this.encryptedAppBuffers;
            this.encryptedAppBuffers = new WsByteBuffer[wsByteBufferArray.length + 1];
            int n = 0;
            for (n = 0; n < wsByteBufferArray.length; ++n) {
                this.encryptedAppBuffers[n] = wsByteBufferArray[n];
            }
            this.encryptedAppBuffers[n] = SSLUtils.allocateByteBuffer(this.connectionLink.getSSLEngine().getPacketBufferSize(), this.config.getEncryptBuffersDirect());
        }
        return this.encryptedAppBuffers;
    }

    protected WsByteBuffer[] getEncryptedAppBuffers(long l) {
        if (this.encryptedAppBuffers == null) {
            int n = this.connectionLink.getSSLEngine().getPacketBufferSize();
            int n2 = (int)(l / (long)n);
            if (l % (long)n > 0L) {
                ++n2;
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Allocating encryptedAppBuffer, we have to release this.");
            }
            this.encryptedAppBuffers = new WsByteBuffer[n2];
            for (int i = 0; i < n2; ++i) {
                this.encryptedAppBuffers[i] = SSLUtils.allocateByteBuffer(n, this.config.getEncryptBuffersDirect());
            }
        } else {
            for (int i = 0; i < this.encryptedAppBuffers.length; ++i) {
                this.encryptedAppBuffers[i].clear();
            }
        }
        return this.encryptedAppBuffers;
    }

    public void close() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close");
        }
        if (this.encryptedAppBuffers != null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Releasing ssl output buffer during close.");
            }
            WsByteBufferUtils.releaseBufferArray((WsByteBuffer[])this.encryptedAppBuffers);
            this.encryptedAppBuffers = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    public void complete(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "complete, vc=" + this.myVCHashCode);
        }
        this.callback.complete(virtualConnection, (TCPWriteRequestContext)this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "complete");
        }
    }

    public void error(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext, IOException iOException) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "error, vc=" + this.myVCHashCode);
        }
        this.callback.error(virtualConnection, (TCPWriteRequestContext)this, iOException);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "error");
        }
    }

    private class QueuedWork
    implements Runnable {
        private long numBytes = 0L;
        private TCPWriteCompletedCallback userCallback = null;
        private int timeout = 0;
        private VirtualConnection vc = null;
        private TCPWriteRequestContext tcpWriteRequestContext = null;
        private IOException exception = null;
        private static final int WRITE = 0;
        private static final int ERROR = 1;
        private int action = 0;

        protected QueuedWork() {
        }

        public void setWriteParameters(long l, TCPWriteCompletedCallback tCPWriteCompletedCallback, int n) {
            this.numBytes = l;
            this.userCallback = tCPWriteCompletedCallback;
            this.timeout = n;
            this.action = 0;
        }

        public void setErrorParameters(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext, TCPWriteCompletedCallback tCPWriteCompletedCallback, IOException iOException) {
            this.vc = virtualConnection;
            this.tcpWriteRequestContext = tCPWriteRequestContext;
            this.userCallback = tCPWriteCompletedCallback;
            this.exception = iOException;
            this.action = 1;
        }

        public void run() {
            if (this.action == 0) {
                SSLWriteServiceContext.this.write(this.numBytes, this.userCallback, false, this.timeout, true);
            } else {
                this.userCallback.error(this.vc, this.tcpWriteRequestContext, this.exception);
            }
        }
    }

    public class MyHandshakeCompletedCallback
    implements SSLHandshakeCompletedCallback {
        private TCPWriteRequestContext writeContext;
        private long numBytes;
        private int timeout;
        private WsByteBuffer appBuffer;
        private WsByteBuffer netBuffer;
        private WsByteBuffer decryptedNetBuffer;

        public MyHandshakeCompletedCallback(TCPWriteRequestContext tCPWriteRequestContext) {
            this.writeContext = tCPWriteRequestContext;
        }

        public void setWriteParameters(long l, int n) {
            this.numBytes = l;
            this.timeout = n;
        }

        public void setNetBuffer(WsByteBuffer wsByteBuffer) {
            this.netBuffer = wsByteBuffer;
        }

        public void setDecryptedNetBuffer(WsByteBuffer wsByteBuffer) {
            this.decryptedNetBuffer = wsByteBuffer;
        }

        public void setAppBuffer(WsByteBuffer wsByteBuffer) {
            this.appBuffer = wsByteBuffer;
        }

        public void complete(ProtoSSLEngineResult protoSSLEngineResult) {
            this.appBuffer.release();
            this.appBuffer = null;
            this.netBuffer.release();
            this.netBuffer = null;
            this.decryptedNetBuffer.release();
            this.decryptedNetBuffer = null;
            ProtoSSLEngineResult.Status status = protoSSLEngineResult.getStatus();
            if (status != ProtoSSLEngineResult.Status.HS_FINISHED) {
                IOException iOException = new IOException("Unable to complete SSLhandshake");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to complete SSLhandshake, " + iOException);
                }
                FFDCFilter.processException((Throwable)iOException, SSLWriteServiceContext.CLASS_NAME, "245", this);
                SSLWriteServiceContext.this.callback.error(SSLWriteServiceContext.this.connectionLink.getVirtualConnection(), this.writeContext, iOException);
            } else {
                VirtualConnection virtualConnection = SSLWriteServiceContext.this.encryptAndWriteAsync(this.numBytes, false, this.timeout);
                if (virtualConnection != null) {
                    SSLWriteServiceContext.this.callback.complete(virtualConnection, this.writeContext);
                }
            }
        }

        public void error(IOException iOException) {
            this.appBuffer.release();
            this.appBuffer = null;
            this.netBuffer.release();
            this.netBuffer = null;
            this.decryptedNetBuffer.release();
            this.decryptedNetBuffer = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception during encryption, " + iOException);
            }
            FFDCFilter.processException((Throwable)iOException, SSLWriteServiceContext.CLASS_NAME, "117", this);
            SSLWriteServiceContext.this.callback.error(SSLWriteServiceContext.this.connectionLink.getVirtualConnection(), this.writeContext, iOException);
        }
    }
}

