/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.DescriptiveProp;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class GetDescriptiveProp
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(GetDescriptiveProp.class, "SSL", "com.ibm.ws.ssl.commands");
    private String parentDataType = null;
    private String parentClassName = null;
    private String parentScopeName = null;
    private String name = null;
    private ObjectName parentObjName = null;
    private String descPropDataType = null;
    private ObjectName descPropObj = null;

    public GetDescriptiveProp(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public GetDescriptiveProp(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        boolean bl = false;
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.parentDataType = (String)this.getParameter(CommandConstants.PARENT_DATA_TYPE);
            this.parentClassName = (String)this.getParameter(CommandConstants.PARENT_CLASS_NAME);
            this.parentScopeName = (String)this.getParameter(CommandConstants.PARENT_SCOPE_NAME);
            this.name = (String)this.getParameter(CommandConstants.NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parentDataType:   " + this.parentDataType);
                Tr.debug(tc, "parentClassName:  " + this.parentClassName);
                Tr.debug(tc, "parentScopeName:  " + this.parentScopeName);
                Tr.debug(tc, "name:             " + this.name);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.parentDataType == null) {
                String string = "The data type of the parent is empty or blank";
                throw new CommandValidationException(string);
            }
            this.descPropDataType = commandHelper.childDataType(this.parentDataType);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "descPropDataType: " + this.descPropDataType);
            }
            if (this.parentScopeName == null) {
                this.parentScopeName = commandHelper.defaultCellScope(objectName3);
            }
            if (this.name == null) {
                String string = "The name of the descriptive property is empty or blank";
                throw new CommandValidationException(string);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.parentClassName);
            this.parentObjName = this.parentDataType.equals(CommandConstants.SECURITY) ? objectName : commandHelper.getObjectName(configService, session, objectName, this.parentDataType, attributeList, this.parentScopeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parentObjName: " + this.parentObjName);
            }
            this.descPropObj = commandHelper.getDescPropObj(configService, session, this.parentObjName, this.descPropDataType, CommandConstants.NAME, this.name);
            if (this.descPropObj == null) {
                String string = "The " + this.descPropDataType + " named " + this.name + " beneath the " + this.parentDataType + " named " + this.parentClassName + " is not found";
                throw new CommandValidationException(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.GetDescriptiveProp.validate", "180", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            CommandHelper commandHelper = new CommandHelper();
            AttributeList attributeList = configService.getAttributes(session, this.descPropObj, null, true);
            taskCommandResultImpl.setResult(attributeList);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

