/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.DescriptiveProp;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListDescriptiveProps
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListDescriptiveProps.class, "SSL", "com.ibm.ws.ssl.commands");
    private String parentDataType = null;
    private String parentClassName = null;
    private String parentScopeName = null;
    private Boolean displayObjectName = null;
    private String descPropDataType = null;
    private ObjectName parentObjName = null;

    public ListDescriptiveProps(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ListDescriptiveProps(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.parentDataType = (String)this.getParameter(CommandConstants.PARENT_DATA_TYPE);
            this.parentClassName = (String)this.getParameter(CommandConstants.PARENT_CLASS_NAME);
            this.parentScopeName = (String)this.getParameter(CommandConstants.PARENT_SCOPE_NAME);
            this.displayObjectName = (Boolean)this.getParameter(CommandConstants.DISPLAY_OBJECT_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parentDataType:           " + this.parentDataType);
                Tr.debug(tc, "parentClassName:          " + this.parentClassName);
                Tr.debug(tc, "parentScopeName:          " + this.parentScopeName);
                Tr.debug(tc, "displayObjectName:        " + this.displayObjectName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.parentDataType == null) {
                String string = "The data type of the parent is empty or blank";
                throw new CommandValidationException(string);
            }
            this.descPropDataType = commandHelper.childDataType(this.parentDataType);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "descPropDataType: " + this.descPropDataType);
            }
            if (this.parentScopeName == null) {
                this.parentScopeName = commandHelper.defaultCellScope(objectName3);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.parentClassName);
            this.parentObjName = this.parentDataType.equals(CommandConstants.SECURITY) ? objectName : commandHelper.getObjectName(configService, session, objectName, this.parentDataType, attributeList, this.parentScopeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parentObjName : " + this.parentObjName);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.ssl.commands.listSSLConfigProperties.validate", "164");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            CommandHelper commandHelper = new CommandHelper();
            ArrayList<Comparable<ObjectName>> arrayList = new ArrayList<Comparable<ObjectName>>();
            AttributeList attributeList = configService.getAttributes(session, this.parentObjName, null, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attrs : " + attributeList);
            }
            List list = (List)ConfigServiceHelper.getAttributeValue(attributeList, this.descPropDataType);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "descProperties : " + list);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AttributeList attributeList2 = (AttributeList)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "descProperty : " + attributeList2);
                }
                ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList2), null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "matches[0] : " + objectNameArray[0]);
                }
                if (objectNameArray.length == 1) {
                    if (this.displayObjectName != null && this.displayObjectName.equals(Boolean.TRUE)) {
                        arrayList.add(objectNameArray[0]);
                        continue;
                    }
                    String[] stringArray = new String[]{CommandConstants.NAME, CommandConstants.VALUE, CommandConstants.TYPE};
                    arrayList.add(commandHelper.getDisplayAttrs(configService, session, objectNameArray, attributeList2, stringArray));
                    continue;
                }
                throw new InvalidParameterValueException(this.getName(), CommandConstants.PROPERTIES, attributeList2);
            }
            taskCommandResultImpl.setResult(arrayList);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

