/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.KeySet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifyKeySet
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ModifyKeySet.class, "SSL", "com.ibm.ws.ssl.commands");
    private String keySetName = null;
    private String aliasPrefix = null;
    private String password = null;
    private Integer maxKeyReferences = null;
    private String keyStoreName = null;
    private String keyStoreScopeName = null;
    private String scopeName = null;
    private Boolean deleteOldKeys = null;
    private String keyGenerationClass = null;
    private Boolean isKeyPair = null;
    private ObjectName keySetObjName = null;
    private ObjectName keyStoreObjName = null;
    private ObjectName scopeObjName = null;
    private boolean createMgmScope = false;

    public ModifyKeySet(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ModifyKeySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            super.validate();
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName = null;
            try {
                ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
                ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
                if (objectName3 != null) {
                    objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
                }
                this.keySetName = (String)this.getParameter(CommandConstants.NAME);
                this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
                this.aliasPrefix = (String)this.getParameter(CommandConstants.ALIAS_PREFIX);
                this.password = (String)this.getParameter(CommandConstants.PASSWORD);
                this.maxKeyReferences = (Integer)this.getParameter(CommandConstants.MAX_KEY_REFERENCES);
                this.deleteOldKeys = (Boolean)this.getParameter(CommandConstants.DELETE_OLD_KEYS);
                this.keyGenerationClass = (String)this.getParameter(CommandConstants.KEY_GENERATION_CLASS);
                this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
                this.keyStoreScopeName = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE_NAME);
                this.isKeyPair = (Boolean)this.getParameter(CommandConstants.IS_KEY_PAIR);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keySetName: " + this.keySetName);
                    Tr.debug(tc, "scopeName: " + this.scopeName);
                    Tr.debug(tc, "aliasPrefix: " + this.aliasPrefix);
                    Tr.debug(tc, "password: " + this.password);
                    Tr.debug(tc, "maxKeyReferences: " + this.maxKeyReferences);
                    Tr.debug(tc, "deleteOldKeys: " + (this.deleteOldKeys == null ? "null" : this.deleteOldKeys.toString()));
                    Tr.debug(tc, "keyGenerationClass: " + this.keyGenerationClass);
                    Tr.debug(tc, "keyStoreName: " + this.keyStoreName);
                    Tr.debug(tc, "keyStoreScopeName: " + this.keyStoreScopeName);
                    Tr.debug(tc, "isKeyPair: " + (this.isKeyPair == null ? "null" : this.isKeyPair.toString()));
                }
                CommandHelper commandHelper = new CommandHelper();
                if (this.scopeName == null) {
                    this.scopeName = commandHelper.defaultCellScope(objectName3);
                }
                if (this.keyStoreScopeName == null) {
                    this.keyStoreScopeName = commandHelper.defaultCellScope(objectName3);
                }
                AttributeList attributeList = new AttributeList();
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keySetName);
                this.keySetObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.KEY_SETS, attributeList, this.scopeName);
                attributeList.clear();
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
                this.scopeObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.MANAGEMENT_SCOPES, attributeList, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "scopeObjName: " + this.scopeObjName);
                }
                if (this.keyStoreName == null) break block14;
                attributeList.clear();
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keyStoreName);
                this.keyStoreObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.KEY_STORES, attributeList, this.keyStoreScopeName);
                AttributeList attributeList2 = configService.getAttributes(session, this.keyStoreObjName, null, true);
                if (attributeList2 != null) {
                    boolean bl = commandHelper.withInScope(configService, session, attributeList2, this.scopeName);
                    if (!bl) {
                        String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0600E", new Object[]{this.keySetName, this.scopeName}, this.keyStoreName + " does not exist within management scope " + this.scopeName);
                        throw new CommandValidationException(string);
                    }
                    break block14;
                }
                String string = "Attribute list for KeyStore is null.";
                throw new CommandValidationException(string);
            }
            catch (ConfigServiceException configServiceException) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error getting configuration:", configServiceException.getMessage());
                }
                throw new CommandValidationException(configServiceException.getMessage());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.ssl.commands.modifyKeySet.validate", "200");
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error getting configuration:", exception.getMessage());
                }
                throw new CommandValidationException(exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        ObjectName objectName = null;
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keySetName);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName);
            if (this.aliasPrefix != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ALIAS_PREFIX, this.aliasPrefix);
            }
            if (this.password != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.PASSWORD, this.password);
            }
            if (this.maxKeyReferences != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.MAX_KEY_REFERENCES, this.maxKeyReferences);
            }
            if (this.deleteOldKeys != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.DELETE_OLD_KEYS, this.deleteOldKeys);
            }
            if (this.keyGenerationClass != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.KEY_GENERATION_CLASS, this.keyGenerationClass);
            }
            if (this.keyStoreObjName != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.KEY_STORE, this.keyStoreObjName);
            }
            if (this.isKeyPair != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.IS_KEY_PAIR, this.isKeyPair);
            }
            configService.setAttributes(session, this.keySetObjName, attributeList);
        }
        catch (Throwable throwable) {
            taskCommandResultImpl.setException(new CommandException(throwable, "ModifyKeySet command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

