/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.KeySetGroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.ipc.ssl.KeySet;
import com.ibm.websphere.models.config.ipc.ssl.KeySetGroup;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

public class GenerateKeyForKeySetGroup
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(GenerateKeyForKeySetGroup.class, "SSL", "com.ibm.ws.ssl.commands");
    private String keySetGroupName = null;
    private String scopeName = null;
    private Boolean updateRuntime = Boolean.FALSE;
    private Boolean saveConfig = Boolean.FALSE;
    ObjectName keySetGroupObjName = null;
    private KeySetGroup keySetGroup = null;
    protected ObjectName objName = null;

    public GenerateKeyForKeySetGroup(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public GenerateKeyForKeySetGroup(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.keySetGroupName = (String)this.getParameter(CommandConstants.KEY_SET_GROUP_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.KEY_SET_GROUP_SCOPE);
            this.updateRuntime = (Boolean)this.getParameter(CommandConstants.KEY_SET_GROUP_UPDATE_RUNTIME);
            this.saveConfig = (Boolean)this.getParameter(CommandConstants.KEY_SET_GROUP_SAVE_CONFIG);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keySetGroupName: " + this.keySetGroupName);
                Tr.debug(tc, "keySetGroupScope: " + this.scopeName);
                Tr.debug(tc, "keySetGroupUpdateRuntime: " + this.updateRuntime);
                Tr.debug(tc, "keySetGroupSaveConfig: " + this.saveConfig);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
                }
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keySetGroupName);
            this.keySetGroupObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.KEY_SET_GROUPS, attributeList, this.scopeName);
            if (this.keySetGroupObjName == null) {
                String string = this.keySetGroupObjName + " does not exists.";
                throw new CommandValidationException(string);
            }
            this.keySetGroup = (KeySetGroup)MOFUtil.convertToEObject(session, this.keySetGroupObjName);
            attributeList.clear();
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration:", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.ssl.commands.getKeySet.validate", "132");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration:", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            Object object;
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            EList eList = this.keySetGroup.getKeySet();
            HashMap hashMap = new HashMap();
            for (int i = 0; i < eList.size(); ++i) {
                object = (KeySet)eList.get(i);
                String string = object.getName();
                String string2 = object.getManagementScope().getScopeName();
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                AdminCommand adminCommand = commandMgr.createCommand("generateKeyForKeySet");
                adminCommand.setConfigSession(session);
                adminCommand.setParameter(CommandConstants.KEY_SET_NAME, string);
                adminCommand.setParameter(CommandConstants.KEY_SET_SCOPE, string2);
                adminCommand.execute();
                CommandResult commandResult = adminCommand.getCommandResult();
                if (commandResult.isSuccessful()) {
                    Map map = (Map)commandResult.getResult();
                    if (map == null) continue;
                    Iterator iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        Object k = entry.getKey();
                        Object v = entry.getValue();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Updating key map with alias: " + k);
                        }
                        hashMap.put(k, v);
                    }
                    continue;
                }
                throw commandResult.getException();
            }
            if (this.saveConfig != null && this.saveConfig.booleanValue()) {
                configService.save(session, true);
            }
            if (this.updateRuntime != null && this.updateRuntime.booleanValue()) {
                this.objName = this.getMBean();
                ObjectName objectName4 = new ObjectName("WebSphere:type=SecurityAdmin,*");
                object = AdminServiceFactory.getAdminService().queryNames(objectName4, null).iterator();
                while (object.hasNext()) {
                    try {
                        objectName4 = (ObjectName)object.next();
                        if (this.objName.equals(objectName4)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, " SecurityAdmin object name = " + objectName4);
                        }
                        AdminServiceFactory.getAdminService().invoke(objectName4, "updateRuntimeKeys", new Object[]{hashMap}, new String[]{"java.util.Map"});
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.GenerateKeyForKeySetGroup.beforeStepsExecuted", "271", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception on MBean call.", new Object[]{exception});
                        }
                        throw exception;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " SecurityAdmin object name (self) = " + this.objName);
                }
                AdminServiceFactory.getAdminService().invoke(this.objName, "updateRuntimeKeys", new Object[]{hashMap}, new String[]{"java.util.Map"});
            }
            taskCommandResultImpl.setResult(hashMap);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.ssl.commands.GenerateKeyForKeySetGroup.beforeStepsExecuted", "285", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred.", new Object[]{throwable});
            }
            taskCommandResultImpl.setException(new CommandException(throwable, "generateKeyForKeySetGroup command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private ObjectName getMBean() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBean");
        }
        if (this.objName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting MBean");
            }
            try {
                String string = AdminServiceFactory.getAdminService().getProcessName();
                this.objName = new ObjectName("WebSphere:type=SecurityAdmin,process=" + string + ",*");
                Iterator iterator = AdminServiceFactory.getAdminService().queryNames(this.objName, null).iterator();
                if (!iterator.hasNext()) {
                    Tr.error(tc, "security.ctr.nombean.error");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMBean");
                    }
                    throw new Exception("No SecurityAdmin MBean found: returning null");
                }
                this.objName = (ObjectName)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " SecurityAdmin object name = " + this.objName);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMBean");
                }
                return this.objName;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.GenerateKeyForKeySetGroup.getMBean", "317", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception on MBean call.", new Object[]{exception});
                }
                throw exception;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning MBean");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBean");
        }
        return this.objName;
    }
}

