/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.KeySetGroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListKeySetGroups
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListKeySetGroups.class, "ListKeySetGroups", "com.ibm.ws.ssl.commands");
    private String scopeName = null;
    private Boolean displayObjectName = null;

    public ListKeySetGroups(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ListKeySetGroups(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
        this.displayObjectName = (Boolean)this.getParameter(CommandConstants.DISPLAY_OBJECT_NAME);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scopeName: " + this.scopeName);
            Tr.debug(tc, "displayObjectName: " + this.displayObjectName);
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        ArrayList<Comparable<ObjectName>> arrayList = new ArrayList<Comparable<ObjectName>>();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            CommandHelper commandHelper = new CommandHelper();
            List list = (List)configService.getAttribute(session, objectName, CommandConstants.KEY_SET_GROUPS);
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName3);
            }
            String[] stringArray = new String[]{CommandConstants.NAME, CommandConstants.MANAGEMENT_SCOPE};
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AttributeList attributeList = (AttributeList)iterator.next();
                ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList), null);
                if (objectNameArray.length == 1) {
                    if (this.scopeName != null) {
                        boolean bl = commandHelper.withInScope(configService, session, attributeList, this.scopeName);
                        if (!bl) continue;
                        if (this.displayObjectName != null && this.displayObjectName.equals(Boolean.TRUE)) {
                            arrayList.add(objectNameArray[0]);
                            continue;
                        }
                        arrayList.add(commandHelper.getDisplayAttrs(configService, session, objectNameArray, attributeList, stringArray));
                        continue;
                    }
                    if (this.displayObjectName != null && this.displayObjectName.equals(Boolean.TRUE)) {
                        arrayList.add(objectNameArray[0]);
                        continue;
                    }
                    arrayList.add(commandHelper.getDisplayAttrs(configService, session, objectNameArray, attributeList, stringArray));
                    continue;
                }
                throw new InvalidParameterValueException(this.getName(), CommandConstants.KEY_SET_GROUPS, attributeList);
            }
            taskCommandResultImpl.setResult(arrayList);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        this.setCommandResult(taskCommandResultImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

