/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.KeySetGroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifyKeySetGroup
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ModifyKeySetGroup.class, "ModifyKeySetGroup", "com.ibm.ws.ssl.commands");
    private String keySetGroupName = null;
    private Boolean autoGenerate = null;
    private String keySetObjNames = null;
    private String wsScheduleName = null;
    private String scopeName = null;
    private ObjectName keySetGroupObjName = null;
    private List keySetObjNameList = null;
    private ObjectName wsScheduleObjName = null;
    private ObjectName scopeObjName = null;

    public ModifyKeySetGroup(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ModifyKeySetGroup(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.keySetGroupName = (String)this.getParameter(CommandConstants.NAME);
            this.autoGenerate = (Boolean)this.getParameter(CommandConstants.AUTO_GENERATE);
            this.wsScheduleName = (String)this.getParameter(CommandConstants.WS_SCHEDULE_NAME);
            this.keySetObjNames = (String)this.getParameter(CommandConstants.KEY_SET_OBJECT_NAMES);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name: " + this.keySetGroupName);
                Tr.debug(tc, "autoGenerate: " + (this.autoGenerate == null ? "null" : this.autoGenerate.toString()));
                Tr.debug(tc, "wsScheduleName: " + this.wsScheduleName);
                Tr.debug(tc, "keySetObjNames: " + this.keySetObjNames);
                Tr.debug(tc, "scopeName: " + this.scopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName3);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keySetGroupName);
            this.keySetGroupObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.KEY_SET_GROUPS, attributeList, this.scopeName);
            attributeList.clear();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
            this.scopeObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.MANAGEMENT_SCOPES, attributeList, null);
            if (this.wsScheduleName != null) {
                attributeList.clear();
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.wsScheduleName);
                this.wsScheduleObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.WS_SCHEDULES, attributeList, null);
            }
            if (this.keySetObjNames != null) {
                String[] stringArray = this.keySetObjNames.split(":");
                this.keySetObjNameList = new ArrayList();
                for (int i = 0; i < stringArray.length; ++i) {
                    ObjectName objectName4;
                    if (stringArray[i] == null) continue;
                    String string = stringArray[i];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "keySets[i]: " + stringArray[i]);
                    }
                    if (stringArray[i].indexOf("(") != -1 && stringArray[i].indexOf(")") != -1) {
                        string = stringArray[i].substring(stringArray[i].indexOf("(") + 1, stringArray[i].indexOf(")"));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "id: " + string);
                        }
                    }
                    if ((objectName4 = commandHelper.getObjectWithinScope(configService, session, "KeySet", string, this.scopeName)) == null) continue;
                    this.keySetObjNameList.add(objectName4);
                }
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.modifyKeySetGroup.validate", "207", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keySetGroupName);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName);
            if (this.autoGenerate != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.AUTO_GENERATE, this.autoGenerate);
            }
            if (this.wsScheduleObjName != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.WS_SCHEDULE, this.wsScheduleObjName);
            }
            if (this.keySetObjNameList != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.KEY_SET, this.keySetObjNameList);
            }
            configService.setAttributes(session, this.keySetGroupObjName, attributeList);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

