/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.ProfileCreation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.ProfileCreation.PrepareKeysUtility;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class PrepareKeysForCellProfile
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(PrepareKeysForCellProfile.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    public static boolean generatedLTPA = false;
    private PrepareKeysUtility pku = new PrepareKeysUtility();
    private String nodeName = null;
    private String appServerNodeName = null;
    private String cellName = null;
    private String dmgrProfileRoot = null;
    private String nodeProfileRoot = null;
    List keyStores = null;
    private boolean nodeProfileExists = false;
    private boolean dmgrProfileExists = false;
    ConfigService cs = null;
    Session session = null;

    public PrepareKeysForCellProfile(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public PrepareKeysForCellProfile(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            Object object;
            this.cs = ConfigServiceFactory.getConfigService();
            if (this.cs == null) {
                object = new Properties();
                ((Properties)object).put("location", "local");
                this.cs = ConfigServiceFactory.createConfigService(true, (Properties)object);
            }
            this.session = this.getConfigSession();
            this.dmgrProfileRoot = (String)this.getParameter(CommandConstants.DMGR_PROFILE_ROOT);
            this.nodeProfileRoot = (String)this.getParameter(CommandConstants.NODE_PROFILE_ROOT);
            this.cellName = (String)this.getParameter(CommandConstants.CELL_NAME);
            if (this.dmgrProfileRoot == null) {
                object = "The dmgr profile root is not specified for the task parameter " + CommandConstants.DMGR_PROFILE_ROOT + ".";
                throw new CommandValidationException((String)object);
            }
            if (this.nodeProfileRoot == null) {
                object = "The node profile root is not specified for the task parameter " + CommandConstants.NODE_PROFILE_ROOT + ".";
                throw new CommandValidationException((String)object);
            }
            if (this.cellName == null) {
                object = "The cell name is not specified for the task parameter " + CommandConstants.CELL_NAME + ".";
                throw new CommandValidationException((String)object);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigService exception: ", new Object[]{configServiceException});
            }
            throw new CommandValidationException(configServiceException, configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred in validate: ", new Object[]{exception});
            }
            throw new CommandValidationException(exception, exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void afterStepsExecuted() {
        Object object;
        TaskCommandResultImpl taskCommandResultImpl;
        block30: {
            List list;
            List list2;
            String string;
            block32: {
                String string2;
                block31: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "afterStepsExecuted");
                    }
                    super.afterStepsExecuted();
                    taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
                    if (!taskCommandResultImpl.isSuccessful()) {
                        if (!tc.isEntryEnabled()) return;
                        Tr.exit(tc, "afterStepsExecuted");
                        return;
                    }
                    try {
                        ObjectName objectName = null;
                        ObjectName objectName2 = null;
                        ObjectName objectName3 = null;
                        Security security2 = null;
                        String string3 = System.getProperty("file.separator");
                        this.dmgrProfileExists = this.pku.checkForProfileExistance(this.dmgrProfileRoot, this.cellName);
                        this.nodeProfileExists = this.pku.checkForProfileExistance(this.nodeProfileRoot, this.cellName);
                        String string4 = "(cell):" + this.cellName;
                        objectName = ConfigServiceHelper.createObjectName(null, "Security");
                        objectName2 = this.cs.resolve(this.session, "Cell=")[0];
                        if (objectName2 != null) {
                            objectName3 = this.cs.queryConfigObjects(this.session, objectName2, objectName, null)[0];
                            security2 = (Security)MOFUtil.convertToEObject(this.session, objectName3);
                        }
                        CommandHelper commandHelper = new CommandHelper();
                        string = this.dmgrProfileRoot + "/config";
                        string2 = this.nodeProfileRoot + "/config";
                        if (this.dmgrProfileExists && !this.nodeProfileExists) {
                            object = this.getKeyStoreList(objectName3, commandHelper, this.dmgrProfileRoot, "dmgr");
                            KeyStoreManager keyStoreManager = KeyStoreManager.getInstance();
                            if (object == null) {
                                String string5 = "Could not get KeyStore list during Cell profile creation, SSL/LTPA keys not shared.";
                                taskCommandResultImpl.setResult(string5);
                                if (!tc.isEntryEnabled()) return;
                                Tr.exit(tc, "afterStepsExecuted");
                                return;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "create DM keystores");
                            }
                            this.pku.createLTPAKeysIfNecessary(security2);
                            generatedLTPA = true;
                            this.pku.createAllKeyStores((List)object, string4, security2, this.dmgrProfileRoot, null);
                            break block30;
                        }
                        if (this.nodeProfileExists && !this.dmgrProfileExists) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "create Node keystores");
                            }
                            object = this.getKeyStoreList(objectName3, commandHelper, this.nodeProfileRoot, "node");
                            KeyStoreManager keyStoreManager = KeyStoreManager.getInstance();
                            if (object == null) {
                                String string6 = "Could not get KeyStore list during Node profile creation, SSL/LTPA keys not shared.";
                                taskCommandResultImpl.setResult(string6);
                                if (!tc.isEntryEnabled()) return;
                                Tr.exit(tc, "afterStepsExecuted");
                                return;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Node profile exists, DM does not - create node keystores");
                            }
                            this.pku.createLTPAKeysIfNecessary(security2);
                            generatedLTPA = true;
                            this.pku.createAllKeyStores((List)object, string4, security2, this.nodeProfileRoot, null);
                            break block30;
                        }
                        if (this.dmgrProfileExists && this.nodeProfileExists) {
                            object = KeyStoreManager.getInstance();
                            list2 = this.getKeyStoreList(objectName3, commandHelper, this.dmgrProfileRoot, "dmgr");
                            list = this.getKeyStoreList(objectName3, commandHelper, this.nodeProfileRoot, "node");
                            this.pku.createAllKeyStores(list, string4, security2, this.nodeProfileRoot, null);
                            this.pku.createAllKeyStores(list2, string4, security2, this.dmgrProfileRoot, null);
                            ((KeyStoreManager)object).loadKeyStores(security2);
                            if (list2 != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "copy DM keystore to Node keystore location");
                                }
                                this.pku.createLTPAKeysIfNecessary(security2);
                                break block31;
                            }
                            if (list == null) {
                                String string7 = "Both Node and DM Keystores are null, although the profiles appear to exist.";
                                taskCommandResultImpl.setResult(string7);
                                if (!tc.isEntryEnabled()) return;
                                Tr.exit(tc, "afterStepsExecuted");
                                return;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "copy Node keystore to DM keystore location");
                            }
                            this.pku.createLTPAKeysIfNecessary(security2);
                            break block32;
                        }
                        String string8 = "Could not get KeyStore list during Cell profile creation, SSL/LTPA keys not shared.";
                        taskCommandResultImpl.setResult(string8);
                        if (!tc.isEntryEnabled()) return;
                        Tr.exit(tc, "afterStepsExecuted");
                        return;
                    }
                    catch (ConfigServiceException configServiceException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ConfigService exception: ", new Object[]{configServiceException});
                        }
                        taskCommandResultImpl.setException(new CommandException(configServiceException, configServiceException.getMessage()));
                        return;
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception occurred in validate: ", new Object[]{exception});
                        }
                        taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
                    }
                    return;
                }
                for (int i = 0; i < list2.size(); ++i) {
                    File file;
                    File file2;
                    File file3;
                    File file4;
                    String string9;
                    KeyStore keyStore = (KeyStore)list2.get(i);
                    String string10 = keyStore.getManagementScope().getScopeType();
                    if (string10 != null && string10.equals("cell") && keyStore.getName().endsWith("DefaultKeyStore") && keyStore.isFileBased()) {
                        for (int j = 0; j < list.size(); ++j) {
                            KeyStore keyStore2 = (KeyStore)list.get(j);
                            string9 = keyStore2.getManagementScope().getScopeType();
                            if (string9 == null || string9.equals("cell") || !keyStore2.getName().endsWith("DefaultTrustStore") || !keyStore2.isFileBased()) continue;
                            ((KeyStoreManager)object).exchangeSigners(string2, keyStore, string2, keyStore2);
                            file4 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, keyStore.getLocation()));
                            file3 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, keyStore.getLocation()));
                            file2 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, keyStore2.getLocation()));
                            file = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, keyStore2.getLocation()));
                            this.pku.copy(file4, file3);
                            this.pku.copy(file2, file);
                        }
                        continue;
                    }
                    if (string10 != null && string10.equals("cell") && keyStore.getName().endsWith("DefaultTrustStore") && keyStore.isFileBased()) {
                        for (int j = 0; j < list.size(); ++j) {
                            KeyStore keyStore3 = (KeyStore)list.get(j);
                            string9 = keyStore3.getManagementScope().getScopeType();
                            if (string9 == null || string9.equals("cell") || !keyStore3.getName().endsWith("DefaultKeyStore") || !keyStore3.isFileBased()) continue;
                            ((KeyStoreManager)object).exchangeSigners(string2, keyStore3, string2, keyStore);
                            file4 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, keyStore.getLocation()));
                            file3 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, keyStore.getLocation()));
                            file2 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, keyStore3.getLocation()));
                            file = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, keyStore3.getLocation()));
                            this.pku.copy(file4, file3);
                            this.pku.copy(file2, file);
                        }
                        continue;
                    }
                    if (!keyStore.getName().endsWith("LTPAKeys") || !keyStore.isFileBased()) continue;
                    File file5 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, keyStore.getLocation()));
                    File file6 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, keyStore.getLocation()));
                    this.pku.copy(file5, file6);
                }
                File file = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.dmgrProfileRoot, "/etc/key.p12"));
                File file7 = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.nodeProfileRoot, "/etc/key.p12"));
                this.pku.copy(file, file7);
                file = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.dmgrProfileRoot, "/etc/trust.p12"));
                File file8 = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.nodeProfileRoot, "/etc/trust.p12"));
                this.pku.copy(file, file8);
                break block30;
            }
            for (int i = 0; i < list.size(); ++i) {
                File file;
                File file9;
                File file10;
                File file11;
                String string11;
                KeyStore keyStore = (KeyStore)list.get(i);
                String string12 = keyStore.getManagementScope().getScopeType();
                if (string12 != null && string12.equals("cell") && keyStore.getName().endsWith("DefaultKeyStore") && keyStore.isFileBased()) {
                    for (int j = 0; j < list2.size(); ++j) {
                        KeyStore keyStore4 = (KeyStore)list2.get(j);
                        string11 = keyStore4.getManagementScope().getScopeType();
                        if (string11 == null || string11.equals("cell") || !keyStore4.getName().endsWith("DefaultTrustStore") || !keyStore4.isFileBased()) continue;
                        ((KeyStoreManager)object).exchangeSigners(string, keyStore, string, keyStore4);
                        file11 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, keyStore4.getLocation()));
                        file10 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, keyStore4.getLocation()));
                        file9 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, keyStore.getLocation()));
                        file = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, keyStore.getLocation()));
                        this.pku.copy(file11, file10);
                        this.pku.copy(file9, file);
                    }
                    continue;
                }
                if (string12 != null && string12.equals("cell") && keyStore.getName().endsWith("DefaultTrustStore") && keyStore.isFileBased()) {
                    for (int j = 0; j < list2.size(); ++j) {
                        KeyStore keyStore5 = (KeyStore)list2.get(j);
                        string11 = keyStore5.getManagementScope().getScopeType();
                        if (string11 == null || string11.equals("cell") || !keyStore5.getName().endsWith("DefaultKeyStore") || !keyStore5.isFileBased()) continue;
                        ((KeyStoreManager)object).exchangeSigners(string, keyStore5, string, keyStore);
                        ((KeyStoreManager)object).exchangeSigners(string, keyStore, string, keyStore5);
                        file11 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, keyStore5.getLocation()));
                        file10 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, keyStore5.getLocation()));
                        file9 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, keyStore.getLocation()));
                        file = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, keyStore.getLocation()));
                        this.pku.copy(file11, file10);
                        this.pku.copy(file9, file);
                    }
                    continue;
                }
                if (!keyStore.getName().endsWith("LTPAKeys") || !keyStore.isFileBased()) continue;
                File file12 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.nodeProfileRoot, keyStore.getLocation()));
                File file13 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(this.dmgrProfileRoot, keyStore.getLocation()));
                this.pku.copy(file12, file13);
            }
            File file = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.dmgrProfileRoot, "/etc/key.p12"));
            File file14 = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.nodeProfileRoot, "/etc/key.p12"));
            this.pku.copy(file14, file);
            file = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.dmgrProfileRoot, "/etc/trust.p12"));
            File file15 = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(this.nodeProfileRoot, "/etc/trust.p12"));
            this.pku.copy(file15, file);
        }
        object = "KeyStore creation and certificate exchange successful for Cell profile.";
        taskCommandResultImpl.setResult(object);
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "afterStepsExecuted");
    }

    public List getKeyStoreList(ObjectName objectName, CommandHelper commandHelper, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStoreList");
        }
        try {
            if (this.cs != null && this.session != null) {
                List list = (List)this.cs.getAttribute(this.session, objectName, CommandConstants.KEY_STORES);
                ArrayList<KeyStore> arrayList = new ArrayList<KeyStore>(list.size());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    AttributeList attributeList = (AttributeList)iterator.next();
                    ObjectName[] objectNameArray = this.cs.queryConfigObjects(this.session, null, ConfigServiceHelper.createObjectName(attributeList), null);
                    KeyStore keyStore = (KeyStore)MOFUtil.convertToEObject(this.session, objectNameArray[0]);
                    if (keyStore == null) continue;
                    keyStore.setLocation(PrepareKeysUtility.fixupLocationWithRepositoryRoot(string, keyStore.getLocation()));
                    String string3 = keyStore.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding keyStore name: " + keyStore.getName());
                    }
                    if (string3 != null && string2 == "dmgr" && string3.startsWith("Cell")) {
                        arrayList.add(keyStore);
                        continue;
                    }
                    if (string3 == null || string2 != "node" || !string3.startsWith("Node")) continue;
                    arrayList.add(keyStore);
                }
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getKeyStoreList");
                }
                return arrayList;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in getKeyStoreList: ", new Object[]{exception});
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStoreList");
        }
        return null;
    }
}

