/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.ProfileCreation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.ProfileCreation.PrepareKeysUtility;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class PrepareKeysForSingleProfile
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(PrepareKeysForSingleProfile.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private PrepareKeysUtility pku = new PrepareKeysUtility();
    private String cellName = null;
    private String profileRoot = null;
    List keyStores = null;
    private boolean profileExists = false;
    ConfigService cs = null;
    Session session = null;

    public PrepareKeysForSingleProfile(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public PrepareKeysForSingleProfile(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            Object object;
            this.cs = ConfigServiceFactory.getConfigService();
            if (this.cs == null) {
                object = new Properties();
                ((Properties)object).put("location", "local");
                this.cs = ConfigServiceFactory.createConfigService(true, (Properties)object);
            }
            this.session = this.getConfigSession();
            this.profileRoot = (String)this.getParameter(CommandConstants.PROFILE_ROOT);
            this.cellName = (String)this.getParameter(CommandConstants.CELL_NAME);
            if (this.profileRoot == null) {
                object = "The profile root is not specified for the task parameter " + CommandConstants.PROFILE_ROOT + ".";
                throw new CommandValidationException((String)object);
            }
            if (this.cellName == null) {
                object = "The cell name is not specified for the task parameter " + CommandConstants.CELL_NAME + ".";
                throw new CommandValidationException((String)object);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigService exception: ", new Object[]{configServiceException});
            }
            throw new CommandValidationException(configServiceException, configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred in validate: ", new Object[]{exception});
            }
            throw new CommandValidationException(exception, exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            String string;
            ObjectName objectName = null;
            ObjectName objectName2 = null;
            ObjectName objectName3 = null;
            Security security2 = null;
            this.profileExists = this.pku.checkForProfileExistance(this.profileRoot, this.cellName);
            if (this.profileExists) {
                CommandHelper commandHelper;
                List list;
                string = "(cell):" + this.cellName;
                objectName = ConfigServiceHelper.createObjectName(null, "Security");
                objectName2 = this.cs.resolve(this.session, "Cell=")[0];
                if (objectName2 != null) {
                    objectName3 = this.cs.queryConfigObjects(this.session, objectName2, objectName, null)[0];
                    security2 = (Security)MOFUtil.convertToEObject(this.session, objectName3);
                }
                if ((list = this.getKeyStoreList(objectName3, commandHelper = new CommandHelper(), this.profileRoot)) != null) {
                    this.pku.createLTPAKeysIfNecessary(security2);
                    this.pku.createAllKeyStores(list, string, security2, this.profileRoot, null);
                } else {
                    String string2 = "Could not get KeyStore list during Cell profile creation, SSL/LTPA keys not shared.";
                    taskCommandResultImpl.setResult(string2);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "afterStepsExecuted");
                    }
                    return;
                }
            }
            string = "KeyStore creation and certificate exchange successful for single profile.";
            taskCommandResultImpl.setResult(string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigService exception: ", new Object[]{configServiceException});
            }
            taskCommandResultImpl.setException(new CommandException(configServiceException, configServiceException.getMessage()));
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred in validate: ", new Object[]{exception});
            }
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
    }

    public List getKeyStoreList(ObjectName objectName, CommandHelper commandHelper, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStoreList");
        }
        try {
            if (this.cs != null && this.session != null) {
                List list = (List)this.cs.getAttribute(this.session, objectName, CommandConstants.KEY_STORES);
                ArrayList<KeyStore> arrayList = new ArrayList<KeyStore>(list.size());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    AttributeList attributeList = (AttributeList)iterator.next();
                    ObjectName[] objectNameArray = this.cs.queryConfigObjects(this.session, null, ConfigServiceHelper.createObjectName(attributeList), null);
                    KeyStore keyStore = (KeyStore)MOFUtil.convertToEObject(this.session, objectNameArray[0]);
                    if (keyStore == null) continue;
                    keyStore.setLocation(PrepareKeysUtility.fixupLocationWithRepositoryRoot(string, keyStore.getLocation()));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding keyStore name: " + keyStore.getName());
                    }
                    arrayList.add(keyStore);
                }
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getKeyStoreList");
                }
                return arrayList;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in getKeyStoreList: ", new Object[]{exception});
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStoreList");
        }
        return null;
    }
}

