/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.ProfileCreation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.certclient.util.PkSsCertFactory;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.LTPA;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.crypto.config.KeySetGroupManager;
import com.ibm.ws.crypto.config.KeySetManager;
import com.ibm.ws.crypto.config.WSKeySetGroup;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class PrepareKeysUtility {
    private static TraceComponent tc = Tr.register(PrepareKeysUtility.class, "SSL", "com.ibm.ws.ssl.commands.ProfileCreation");

    public void createAllKeyStores(List list, String string, Security security2, String string2, String string3) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAllKeyStores", new Object[]{list, string, string2, string3});
        }
        try {
            Property property;
            EList eList;
            String string4 = "default";
            String string5 = "cn=${hostname},o=IBM,c=US";
            String string6 = "5475";
            String string7 = "1024";
            String string8 = "IBMJCE";
            if (list != null && list.size() > 0) {
                eList = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)list.get(0);
                string8 = eList.getProvider();
            }
            if ((eList = security2.getProperties()) != null) {
                for (int i = 0; i < eList.size(); ++i) {
                    property = (Property)eList.get(i);
                    if (property.getName().equals("com.ibm.ssl.defaultCertReqAlias")) {
                        string4 = property.getValue();
                        continue;
                    }
                    if (property.getName().equals("com.ibm.ssl.defaultCertReqSubjectDN")) {
                        string5 = property.getValue();
                        continue;
                    }
                    if (property.getName().equals("com.ibm.ssl.defaultCertReqDays")) {
                        string6 = property.getValue();
                        continue;
                    }
                    if (!property.getName().equals("com.ibm.ssl.defaultCertReqKeySize")) continue;
                    string7 = property.getValue();
                }
            }
            string5 = KeyStoreManager.getInstance().expand(string5);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Creating certificate using: (keySize: " + string7 + "), (subjectDN: " + string5 + "), (validity: " + string6 + ")");
            }
            Date date = new Date();
            date.setTime(date.getTime() - 86400000L);
            property = PkSsCertFactory.newSsCert((int)Integer.parseInt(string7), (String)string5, (int)Integer.parseInt(string6), (Date)date, (boolean)true, (boolean)true, (String)string8);
            X509Certificate x509Certificate = property.getCertificate();
            PrivateKey privateKey = property.getKey();
            this.createClientKeyStores(string2, string3, x509Certificate, privateKey);
            try {
                Tr.audit(tc, "Self Signed Certificate: notBefore time: " + x509Certificate.getNotBefore().toString() + " notAfter time: " + x509Certificate.getNotAfter().toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (int i = 0; i < list.size(); ++i) {
                boolean bl;
                File file;
                Object[] objectArray;
                Object[] objectArray2;
                String string9;
                Serializable serializable;
                com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)list.get(i);
                if (keyStore == null) continue;
                if (keyStore.getName().endsWith("DefaultTrustStore")) {
                    boolean bl2 = KeyStoreHelper.createKeyStoreFile(keyStore);
                    if (bl2) {
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "KeyStore \"" + keyStore.getName() + "\" created -> " + bl2);
                        }
                        serializable = new WSKeyStoreRemotable(keyStore);
                        string9 = "setCertificateEntry";
                        objectArray2 = new Object[]{string4, x509Certificate};
                        ((WSKeyStoreRemotable)serializable).invokeKeyStoreCommand(string9, objectArray2);
                        if (string3 != null) {
                            objectArray = new File(keyStore.getLocation());
                            file = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(string3, keyStore.getLocation()));
                            this.copy((File)objectArray, file);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "Signer added to trust store.");
                        }
                    }
                } else if (keyStore.getName().endsWith("DefaultKeyStore") && (bl = KeyStoreHelper.createKeyStoreFile(keyStore))) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "KeyStore \"" + keyStore.getName() + "\" created -> " + bl);
                    }
                    serializable = new WSKeyStoreRemotable(keyStore);
                    string9 = keyStore.getPassword();
                    objectArray2 = "setKeyEntry";
                    objectArray = new Object[]{string4, privateKey, string9.toCharArray(), new X509Certificate[]{x509Certificate}};
                    ((WSKeyStoreRemotable)serializable).invokeKeyStoreCommand((String)objectArray2, objectArray);
                    if (string3 != null) {
                        file = new File(keyStore.getLocation());
                        File file2 = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(string3, keyStore.getLocation()));
                        this.copy(file, file2);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Personal certificate added to key store.");
                    }
                }
                if (!keyStore.getName().endsWith("LTPAKeys") || string3 == null) continue;
                File file3 = new File(keyStore.getLocation());
                serializable = new File(PrepareKeysUtility.fixupLocationWithRepositoryRoot(string3, keyStore.getLocation()));
                this.copy(file3, (File)serializable);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred.", new Object[]{exception});
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAllKeyStores");
        }
    }

    public boolean createClientKeyStores(String string, String string2, X509Certificate x509Certificate, Key key) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createClientKeyStores");
        }
        try {
            SSLConfigManager.getInstance().initializeClientSSL();
            String[] stringArray = KeyStoreManager.getInstance().getKeyStoreAliases();
            for (int i = 0; i < stringArray.length; ++i) {
                File file;
                Object object;
                String string3;
                String string4;
                String string5;
                Enumeration<String> enumeration;
                KeyStore keyStore;
                WSKeyStore wSKeyStore;
                if (stringArray[i] == null || (wSKeyStore = KeyStoreManager.getInstance().getKeyStore(stringArray[i])) == null || (keyStore = wSKeyStore.getKeyStore(false, false)) == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "aliases[" + i + "]: " + stringArray[i]);
                }
                if (stringArray[i].endsWith("DefaultTrustStore")) {
                    enumeration = keyStore.aliases();
                    while (enumeration.hasMoreElements()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting signer for trust store: " + stringArray[i]);
                        }
                        string5 = enumeration.nextElement();
                        this.addSignerToDummyClientTrustFile(string, string5, x509Certificate);
                        keyStore.deleteEntry(string5);
                        keyStore.setCertificateEntry(string5, x509Certificate);
                        wSKeyStore.store();
                        if (string2 == null) continue;
                        this.addSignerToDummyClientTrustFile(string2, string5, x509Certificate);
                        string4 = wSKeyStore.getProperty("com.ibm.ssl.keyStore");
                        string3 = wSKeyStore.getProperty("com.ibm.ssl.keyStore");
                        object = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(string, string4));
                        file = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(string2, string4));
                        if (string3.equals(((File)object).getPath())) {
                            this.copy((File)object, file);
                            continue;
                        }
                        this.copy(file, (File)object);
                    }
                    continue;
                }
                if (!stringArray[i].endsWith("DefaultKeyStore")) continue;
                enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting signer for key store: " + stringArray[i]);
                    }
                    string5 = enumeration.nextElement();
                    keyStore.deleteEntry(string5);
                    string4 = wSKeyStore.getProperty("com.ibm.ssl.keyStorePassword");
                    if (string4 == null) {
                        string4 = "WebAS";
                        wSKeyStore.setProperty("com.ibm.ssl.keyStorePassword", string4);
                    }
                    keyStore.setKeyEntry(string5, key, string4.toCharArray(), new Certificate[]{x509Certificate});
                    wSKeyStore.store();
                    if (string2 == null) continue;
                    string3 = wSKeyStore.getProperty("com.ibm.ssl.keyStore");
                    object = wSKeyStore.getProperty("com.ibm.ssl.keyStore");
                    file = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(string, string3));
                    File file2 = new File(PrepareKeysUtility.fixupClientLocationWithRepositoryRoot(string2, string3));
                    if (((String)object).equals(file.getPath())) {
                        this.copy(file, file2);
                        continue;
                    }
                    this.copy(file2, file);
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred.", new Object[]{exception});
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createClientKeyStores");
        }
        return true;
    }

    public void addSignerToDummyClientTrustFile(String string, String string2, X509Certificate x509Certificate) {
        block3: {
            try {
                String string3 = string + "/etc/DummyClientTrustFile.jks";
                String string4 = "WebAS";
                String string5 = "JKS";
                KeyStore keyStore = KeyStoreManager.getInstance().getKeyStore(null, string5, "IBMJCE", string3, string4, null, true, null);
                if (keyStore != null) {
                    keyStore.setCertificateEntry(string2, x509Certificate);
                    FileOutputStream fileOutputStream = new FileOutputStream(string3);
                    keyStore.store(fileOutputStream, string4.toCharArray());
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Exception occurred.", new Object[]{exception});
            }
        }
    }

    public boolean checkForProfileExistance(String string, String string2) {
        File file;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForProfileExistance", new Object[]{string, string2});
        }
        boolean bl = false;
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkForProfileExistance -> " + bl);
            }
            return bl;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(File.separatorChar);
        stringBuffer.append("config");
        stringBuffer.append(File.separatorChar);
        stringBuffer.append("cells");
        stringBuffer.append(File.separatorChar);
        stringBuffer.append(string2);
        stringBuffer.append(File.separatorChar);
        stringBuffer.append("security.xml");
        String string3 = stringBuffer.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "securityxmlpath -> " + string3);
        }
        if ((file = new File(string3)).exists()) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForProfileExistance -> " + bl);
        }
        return bl;
    }

    public String getNodeURIFromPath(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellURIFromPath", new Object[]{string});
        }
        String string2 = null;
        int n = string.indexOf("nodes/");
        string2 = n != -1 ? string.substring(n) : string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellURIFromPath");
        }
        return string2;
    }

    public String getScopeFromURI(String string) throws Exception {
        string = string.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getScopeFromURI", new Object[]{string});
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = string.indexOf("/cells/");
            int n2 = n + "/cells/".length();
            int n3 = string.indexOf("/nodes/");
            int n4 = string.indexOf("/servers/");
            String string2 = string.substring(n2, n3);
            String string3 = string.substring(n3 + "/nodes/".length(), n4);
            String string4 = string.substring(n4 + "/servers/".length(), string.lastIndexOf("/"));
            stringBuffer.append("(cell):");
            stringBuffer.append(string2);
            stringBuffer.append(":(node):");
            stringBuffer.append(string3);
            stringBuffer.append(":(server):");
            stringBuffer.append(string4);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getScopeFromURI exception is" + exception.getMessage());
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScopeFromURI -> " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public static String fixupLocationWithRepositoryRoot(String string, String string2) {
        string2 = string2.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixupLocationWithRepositoryRoot", new Object[]{string, string2});
        }
        int n = string2.indexOf("/config/cells");
        String string3 = string2;
        if (n != -1) {
            String string4 = string2.substring(n);
            string3 = string + string4;
        } else {
            n = string2.indexOf("/cells/");
            if (n != -1) {
                String string5 = string2.substring(n);
                string3 = string + "/config" + string5;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixupLocationWithRepositoryRoot -> " + string3);
        }
        return string3;
    }

    public static String fixupClientLocationWithRepositoryRoot(String string, String string2) {
        string2 = string2.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixupClientLocationWithRepositoryRoot", new Object[]{string, string2});
        }
        int n = string2.indexOf("/etc/");
        String string3 = string2;
        if (n != -1) {
            String string4 = string2.substring(n);
            string3 = string + string4;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixupClientLocationWithRepositoryRoot -> " + string3);
        }
        return string3;
    }

    public void createLTPAKeysIfNecessary(Security security2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createLTPAKeysIfNecessary");
        }
        try {
            if (security2.getActiveAuthMechanism() instanceof LTPA) {
                KeyStoreManager.getInstance().loadKeyStores(security2);
                KeySetManager.getInstance().initializeKeySets(security2, true);
                KeySetGroupManager.getInstance().initializeKeySetGroups(security2, true);
                String string = ((LTPA)security2.getActiveAuthMechanism()).getKeySetGroup().getName();
                WSKeySetGroup wSKeySetGroup = KeySetGroupManager.getInstance().getKeySetGroup(string);
                if (wSKeySetGroup != null) {
                    wSKeySetGroup.getLatestKeys();
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createLTPAKeysIfNecessary -> success");
                }
                return;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createLTPAKeysIfNecessary -> LTPA not enabled.");
            }
            return;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception creating LTPA keys: ", new Object[]{exception});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createLTPAKeysIfNecessary -> failed");
            }
            throw exception;
        }
    }

    void copy(File file, File file2) throws IOException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copy");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "source = " + file.getPath() + " destination = " + file2.getPath());
        }
        if (file.compareTo(file2) == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "copy: source and destination equal");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "copy");
            }
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[1024];
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        if (fileInputStream != null) {
            ((InputStream)fileInputStream).close();
        }
        if (fileOutputStream != null) {
            ((OutputStream)fileOutputStream).close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copy");
        }
    }
}

