/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfig;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateSSLConfigProperty
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateSSLConfigProperty.class, "SSL", "com.ibm.ws.ssl.commands");
    private String sslConfigAliasName = null;
    private String propertyName = null;
    private String propertyValue = null;
    private String scopeName = null;
    private ObjectName sslConfigObjName = null;

    public CreateSSLConfigProperty(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public CreateSSLConfigProperty(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            boolean bl;
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.sslConfigAliasName = (String)this.getParameter(CommandConstants.SSL_CONFIG_ALIAS_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.propertyName = (String)this.getParameter(CommandConstants.PROPERTY_NAME);
            this.propertyValue = (String)this.getParameter(CommandConstants.PROPERTY_VALUE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLConfig sslConfigAliasName : " + this.sslConfigAliasName);
                Tr.debug(tc, "scopeName : " + this.scopeName);
                Tr.debug(tc, "propertyName : " + this.propertyName);
                Tr.debug(tc, "propertyValue : " + this.propertyValue);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName3);
            } else if (!ManagementScopeHelper.validScopeName(session, configService, this.scopeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                }
                String string = "Management scope is not valid: " + this.scopeName;
                throw new CommandValidationException(string);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ALIAS, this.sslConfigAliasName);
            this.sslConfigObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.REPERTOIRE, attributeList, this.scopeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sslConfigObjName: " + this.sslConfigObjName);
            }
            if (bl = commandHelper.propertyExists(configService, session, objectName, this.sslConfigAliasName, this.propertyName, this.scopeName)) {
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.property.already.exist.CWPKI0667E", new Object[]{this.propertyName}, "Property named \"" + this.propertyName + "\" already exists in the SSL Configuration.");
                throw new CommandValidationException(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.ssl.commands.createSSLConfigProperty.validate", "155");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "beforeStepsExecuted");
            }
            super.beforeStepsExecuted();
            ObjectName objectName = null;
            TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
            if (!taskCommandResultImpl.isSuccessful()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beforeStepsExecuted");
                }
                return;
            }
            try {
                ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
                ConfigService configService = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
                if (objectName3 != null) {
                    objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
                }
                AttributeList attributeList = configService.getAttributes(session, this.sslConfigObjName, null, true);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "repertoire: " + attributeList);
                }
                if (attributeList == null) break block11;
                AttributeList attributeList2 = (AttributeList)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.SETTING);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting: " + attributeList2);
                }
                if (attributeList2.size() <= 0) break block11;
                ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList2), null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "matches: " + objectNameArray[0]);
                }
                if (objectNameArray.length == 1) {
                    AttributeList attributeList3 = new AttributeList();
                    ConfigServiceHelper.setAttributeValue(attributeList3, CommandConstants.NAME, this.propertyName);
                    ConfigServiceHelper.setAttributeValue(attributeList3, CommandConstants.VALUE, this.propertyValue);
                    configService.createConfigData(session, objectNameArray[0], CommandConstants.PROPERTIES, null, attributeList3);
                    break block11;
                }
                throw new InvalidParameterValueException(this.getName(), CommandConstants.SETTING, attributeList2);
            }
            catch (Exception exception) {
                taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

