/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfig;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteSSLConfig
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteSSLConfig.class, "SSL", "com.ibm.ws.ssl.commands");
    private String aliasName = null;
    private String scopeName = null;
    private ObjectName sslConfigObjName = null;

    public DeleteSSLConfig(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public DeleteSSLConfig(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            AttributeList attributeList;
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            boolean bl = false;
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.aliasName = (String)this.getParameter(CommandConstants.ALIAS);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLConfig aliasName: " + this.aliasName);
                Tr.debug(tc, "scopeName: " + this.scopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                bl = true;
                this.scopeName = commandHelper.defaultCellScope(objectName3);
            }
            AttributeList attributeList2 = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList2, CommandConstants.ALIAS, this.aliasName);
            try {
                this.sslConfigObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.REPERTOIRE, attributeList2, this.scopeName);
            }
            catch (Exception exception) {
                if (bl) {
                    this.sslConfigObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.REPERTOIRE, attributeList2, null);
                }
                throw exception;
            }
            AttributeList attributeList3 = commandHelper.getReference(configService, session, objectName, CommandConstants.SSL_CONFIG_GROUPS, CommandConstants.SSL_CONFIG, this.sslConfigObjName);
            AttributeList attributeList4 = new AttributeList();
            if (attributeList3.size() > 0) {
                attributeList4.addAll(attributeList3);
            }
            if ((attributeList = commandHelper.getReference(configService, session, objectName, CommandConstants.DYNAMIC_SSL_CONFIG_SELECTIONS, CommandConstants.SSL_CONFIG, this.sslConfigObjName)).size() > 0) {
                attributeList4.addAll(attributeList);
            }
            if (attributeList4.size() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < attributeList4.size(); ++i) {
                    Attribute attribute = (Attribute)attributeList4.get(i);
                    if (attribute.getValue() == null) continue;
                    String string = attribute.getName() + ":" + attribute.getValue();
                    arrayList.add(string);
                }
                String string = "This object is referenced by " + arrayList;
                throw new CommandValidationException(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.deleteSSLConfig.validate", "155", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            configService.deleteConfigData(session, this.sslConfigObjName);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

