/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfig;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteSSLConfigProperty
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteSSLConfigProperty.class, "SSL", "com.ibm.ws.ssl.commands");
    private String sslConfigAliasName = null;
    private String scopeName = null;
    private String propertyName = null;
    private ObjectName scopeObjName = null;
    private ObjectName sslConfigObjName = null;

    public DeleteSSLConfigProperty(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public DeleteSSLConfigProperty(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.sslConfigAliasName = (String)this.getParameter(CommandConstants.SSL_CONFIG_ALIAS_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.propertyName = (String)this.getParameter(CommandConstants.PROPERTY_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLConfig sslConfigAliasName : " + this.sslConfigAliasName);
                Tr.debug(tc, "propertyName : " + this.propertyName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName3);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ALIAS, this.sslConfigAliasName);
            this.sslConfigObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.REPERTOIRE, attributeList, this.scopeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sslConfigObjName: " + this.sslConfigObjName);
            }
            attributeList.clear();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
            this.scopeObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.MANAGEMENT_SCOPES, attributeList, null);
            boolean bl = commandHelper.propertyExists(configService, session, objectName, this.sslConfigAliasName, this.propertyName, this.scopeName);
            if (!bl) {
                String string = "Property name not found for this SSLConfig.";
                throw new CommandValidationException(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.ssl.commands.deleteSSLConfigProperty.validate", "161");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "beforeStepsExecuted");
            }
            super.beforeStepsExecuted();
            ObjectName objectName = null;
            TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
            if (!taskCommandResultImpl.isSuccessful()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beforeStepsExecuted");
                }
                return;
            }
            try {
                AttributeList attributeList;
                ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
                ConfigService configService = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
                if (objectName3 != null) {
                    objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
                }
                if ((attributeList = configService.getAttributes(session, this.sslConfigObjName, null, true)) == null) break block10;
                AttributeList attributeList2 = (AttributeList)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.SETTING);
                ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList2), null);
                if (objectNameArray.length == 1) {
                    List list = (List)ConfigServiceHelper.getAttributeValue(attributeList2, CommandConstants.PROPERTIES);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "propertyList : " + list);
                    }
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        AttributeList attributeList3 = (AttributeList)iterator.next();
                        String string = (String)ConfigServiceHelper.getAttributeValue(attributeList3, CommandConstants.NAME);
                        if (string == null || !string.equals(this.propertyName)) continue;
                        ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList3), null);
                        configService.deleteConfigData(session, objectNameArray2[0]);
                        break block10;
                    }
                    break block10;
                }
                throw new InvalidParameterValueException(this.getName(), CommandConstants.SETTING, attributeList2);
            }
            catch (Exception exception) {
                taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

