/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfig;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class GetInheritedSSLConfig
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(GetInheritedSSLConfig.class, "SSL", "com.ibm.ws.ssl.commands");
    private String direction = null;
    private String scopeName = null;
    private ObjectName sslConfigObjName = null;

    public GetInheritedSSLConfig(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public GetInheritedSSLConfig(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        try {
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName2 = configService.resolve(session, "Cell=:Security=")[0];
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.direction = (String)this.getParameter(CommandConstants.DIRECTION);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scopeName: " + this.scopeName);
                Tr.debug(tc, "direction: " + this.direction);
            }
            if (this.direction != null && !this.direction.equalsIgnoreCase("inbound") && !this.direction.equalsIgnoreCase("outbound")) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.SSLConfig.invalid.direction.CWPKI0614E", "Direction is not valid.  Should be inbound or outbound.");
                throw new CommandValidationException(string);
            }
            if (!ManagementScopeHelper.validScopeName(session, configService, this.scopeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                }
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                throw new CommandValidationException(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName = configService.resolve(session, "Cell=:Security=")[0];
            String string = this.getInheritedSSLConfig(configService, session, objectName, this.scopeName, this.direction);
            taskCommandResultImpl.setResult(string);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private String getInheritedSSLConfig(ConfigService configService, Session session, ObjectName objectName, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInheritedSSLConfig");
        }
        Object var6_6 = null;
        ObjectName objectName2 = null;
        String string3 = null;
        ManagementScopeData managementScopeData = new ManagementScopeData(string);
        if (managementScopeData != null) {
            String string4;
            Object object;
            Object object2;
            String string5 = managementScopeData.getScopeType();
            if (string5.equalsIgnoreCase("endpoint")) {
                object2 = managementScopeData.formProcessScope();
                objectName2 = this.getSSLConfigGrp(configService, session, objectName, string2, (String)object2);
                if (objectName2 == null) {
                    object = null;
                    object = this.getServersClusterName(configService, session, managementScopeData.getProcessName());
                    if (object != null) {
                        string4 = managementScopeData.formCellScope() + ":(cluster):" + (String)object;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cluster scope is " + string4);
                        }
                        objectName2 = this.getSSLConfigGrp(configService, session, objectName, string2, string4);
                    }
                    if (objectName2 == null && (objectName2 = this.getSSLConfigGrp(configService, session, objectName, string2, string4 = managementScopeData.formNodeScope())) == null) {
                        String string6 = managementScopeData.formCellScope();
                        objectName2 = this.getSSLConfigGrp(configService, session, objectName, string2, string6);
                    }
                }
            } else if (string5.equalsIgnoreCase("server")) {
                object2 = null;
                object2 = this.getServersClusterName(configService, session, managementScopeData.getProcessName());
                if (object2 != null) {
                    object = managementScopeData.formCellScope() + ":(cluster):" + (String)object2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cluster scope is " + (String)object);
                    }
                    objectName2 = this.getSSLConfigGrp(configService, session, objectName, string2, (String)object);
                }
                if (objectName2 == null && (objectName2 = this.getSSLConfigGrp(configService, session, objectName, string2, (String)(object = managementScopeData.formNodeScope()))) == null) {
                    String string7;
                    string4 = null;
                    string4 = this.getNodeNodeGroup(configService, session, managementScopeData.getNodeName());
                    if (string4 != null) {
                        string7 = managementScopeData.formCellScope() + ":(nodeGroup):" + string4;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Built node group scope is " + string7);
                        }
                        objectName2 = this.getSSLConfigGrp(configService, session, objectName, string2, string7);
                    }
                    if (objectName2 == null) {
                        string7 = managementScopeData.formCellScope();
                        objectName2 = this.getSSLConfigGrp(configService, session, objectName, string2, string7);
                    }
                }
            } else if (string5.equalsIgnoreCase("cluster")) {
                object2 = null;
                object2 = this.getClusterNodeGroup(configService, session, managementScopeData.getClusterName());
                if (object2 != null) {
                    object = managementScopeData.formCellScope() + ":(nodeGroup):" + (String)object2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Built node scope is " + (String)object);
                    }
                    objectName2 = this.getSSLConfigGrp(configService, session, objectName, string2, (String)object);
                }
                if (objectName2 == null) {
                    object = managementScopeData.formCellScope();
                    objectName2 = this.getSSLConfigGrp(configService, session, objectName, string2, (String)object);
                }
            } else if (string5.equalsIgnoreCase("node")) {
                object2 = null;
                object2 = this.getNodeNodeGroup(configService, session, managementScopeData.getNodeName());
                if (object2 != null) {
                    object = managementScopeData.formCellScope() + ":(nodeGroup):" + (String)object2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Built node scope is " + (String)object);
                    }
                    objectName2 = this.getSSLConfigGrp(configService, session, objectName, string2, (String)object);
                }
                if (objectName2 == null) {
                    object = managementScopeData.formCellScope();
                    objectName2 = this.getSSLConfigGrp(configService, session, objectName, string2, (String)object);
                }
            } else if (string5.equalsIgnoreCase("cell") || string5.equalsIgnoreCase("nodeGroup")) {
                object2 = managementScopeData.formCellScope();
                objectName2 = this.getSSLConfigGrp(configService, session, objectName, string2, (String)object2);
            }
            if (objectName2 != null) {
                object2 = null;
                object = (ObjectName)configService.getAttribute(session, objectName2, "sslConfig");
                if (object != null) {
                    object2 = (String)configService.getAttribute(session, (ObjectName)object, "alias");
                }
                string4 = (String)configService.getAttribute(session, objectName2, "certificateAlias");
                string3 = new String((String)object2 + "," + string4);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Inherited SSL Config is " + string3);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There seems to be no SSL config group so let's get the default SSL Config");
                }
                object2 = SSLConfigManager.getInstance().getDefaultSSLConfig();
                object = ((Properties)object2).getProperty("com.ibm.ssl.alias");
                string3 = new String((String)object);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Inherited SSL Config is " + string3);
                }
            }
        } else {
            String string8 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
            throw new Exception(string8);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInheritedSSLConfig");
        }
        return string3;
    }

    private ObjectName getSSLConfigGrp(ConfigService configService, Session session, ObjectName objectName, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLConfigGrp");
        }
        ObjectName objectName2 = null;
        CommandHelper commandHelper = new CommandHelper();
        AttributeList attributeList = new AttributeList();
        try {
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.DIRECTION, string);
            objectName2 = commandHelper.getObjectName(configService, session, objectName, CommandConstants.SSL_CONFIG_GROUPS, attributeList, string2);
        }
        catch (CommandValidationException commandValidationException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is no ssl config group for direction " + string + " and management scope " + string2);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLConfigGrp");
        }
        return objectName2;
    }

    private String getServersClusterName(ConfigService configService, Session session, String string) {
        String string2;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getServersClusterName");
            }
            string2 = null;
            try {
                ObjectName[] objectNameArray = configService.resolve(session, "ServerCluster=");
                if (objectNameArray.length > 0) {
                    block2: for (int i = 0; i < objectNameArray.length; ++i) {
                        List list = (List)configService.getAttribute(session, objectNameArray[i], "members");
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            AttributeList attributeList = (AttributeList)iterator.next();
                            String string3 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "memberName");
                            if (string.equalsIgnoreCase(string3)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Server found in cluster");
                                }
                                string2 = (String)configService.getAttribute(session, objectNameArray[i], "name");
                                continue block2;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "member is null");
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Exception while trying to find out if the server is in a cluster " + exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersClusterName");
        }
        return string2;
    }

    private String getClusterNodeGroup(ConfigService configService, Session session, String string) {
        String string2;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getClusterNodeGroup");
            }
            string2 = null;
            try {
                ObjectName objectName = configService.resolve(session, "ServerCluster=" + string)[0];
                if (objectName != null) {
                    string2 = (String)configService.getAttribute(session, objectName, "nodeGroupName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cluster's node group name is" + string2);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cluster not found");
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception while trying to find out the node group of the cluster " + exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterNodeGroup");
        }
        return string2;
    }

    private String getNodeNodeGroup(ConfigService configService, Session session, String string) {
        String string2;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getNodeNodeGroup");
            }
            string2 = null;
            try {
                ObjectName[] objectNameArray = configService.resolve(session, "NodeGroup=");
                if (objectNameArray.length > 0) {
                    block2: for (int i = 0; i < objectNameArray.length; ++i) {
                        List list = (List)configService.getAttribute(session, objectNameArray[i], "members");
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            AttributeList attributeList = (AttributeList)iterator.next();
                            String string3 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "nodeName");
                            if (!string.equalsIgnoreCase(string3)) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Node found in nodeGroup");
                            }
                            string2 = (String)configService.getAttribute(session, objectNameArray[i], "name");
                            continue block2;
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception while trying to find out nodeGroup of the node " + exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeNodeGroup");
        }
        return string2;
    }
}

