/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfig;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class GetSSLConfig
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(GetSSLConfig.class, "SSL", "com.ibm.ws.ssl.commands");
    private String aliasName = null;
    private String scopeName = null;
    private ObjectName sslConfigObjName = null;

    public GetSSLConfig(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public GetSSLConfig(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            super.validate();
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName = null;
            try {
                ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
                ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
                boolean bl = false;
                if (objectName3 != null) {
                    objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
                }
                this.aliasName = (String)this.getParameter(CommandConstants.ALIAS);
                this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SSLConfig aliasName: " + this.aliasName);
                    Tr.debug(tc, "scopeName: " + this.scopeName);
                }
                CommandHelper commandHelper = new CommandHelper();
                if (this.scopeName == null) {
                    bl = true;
                    this.scopeName = commandHelper.defaultCellScope(objectName3);
                }
                AttributeList attributeList = new AttributeList();
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ALIAS, this.aliasName);
                try {
                    this.sslConfigObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.REPERTOIRE, attributeList, this.scopeName);
                }
                catch (Exception exception) {
                    if (bl) {
                        this.sslConfigObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.REPERTOIRE, attributeList, null);
                        break block13;
                    }
                    throw exception;
                }
            }
            catch (ConfigServiceException configServiceException) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
                }
                throw new CommandValidationException(configServiceException.getMessage());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.ssl.commands.getSSLConfig.validate", "154");
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
                }
                throw new CommandValidationException(exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        Object var1_1 = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            String string;
            AttributeList attributeList;
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            AttributeList attributeList2 = configService.getAttributes(session, this.sslConfigObjName, null, true);
            AttributeList attributeList3 = attributeList = (AttributeList)ConfigServiceHelper.getAttributeValue(attributeList2, CommandConstants.SETTING);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting: " + attributeList);
            }
            String string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList2, CommandConstants.TYPE);
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList), null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "matches: " + objectNameArray[0]);
            }
            boolean bl = false;
            ObjectName objectName2 = null;
            AttributeList attributeList4 = configService.getAttributes(session, objectNameArray[0], new String[]{"properties"}, false);
            List list = (List)((Attribute)attributeList4.get(0)).getValue();
            Object object = list.iterator();
            while (object.hasNext()) {
                String string3;
                objectName2 = (ObjectName)object.next();
                string = (String)configService.getAttribute(session, objectName2, "name");
                if (string.equals("com.ibm.ssl.contextProvider")) {
                    string3 = (String)configService.getAttribute(session, objectName2, "value");
                    if (string3 != null) {
                        attributeList.add(new Attribute("jsseProvider", string3));
                    }
                    bl = true;
                }
                if (string.equals("com.ibm.ssl.protocol")) {
                    string3 = (String)configService.getAttribute(session, objectName2, "value");
                    if (string3 != null) {
                        attributeList.add(new Attribute("sslProtocol", string3));
                    }
                    bl = true;
                }
                if (!string.equals("was.com.ibm.ssl.sys.v3.timeout")) continue;
                string3 = (String)configService.getAttribute(session, objectName2, "value");
                if (string3 != null) {
                    attributeList.add(new Attribute("v3timeout", string3));
                }
                bl = true;
            }
            if (string2.equals("SSSL") && (object = (String)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.ENABLED_CIPHERS)) != null) {
                string = SSLConfigManager.getInstance().getSystemSSLList((String)object);
                attributeList.add(new Attribute(CommandConstants.ENABLED_CIPHERS, string));
                bl = true;
            }
            if (bl) {
                attributeList2.remove(new Attribute("setting", attributeList3));
                attributeList2.add(new Attribute("setting", attributeList));
            }
            taskCommandResultImpl.setResult(attributeList2);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

