/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfig;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifySSLConfig
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ModifySSLConfig.class, "SSL", "com.ibm.ws.ssl.commands");
    private String aliasName = null;
    private String clientKeyAlias = null;
    private String serverKeyAlias = null;
    private String scopeName = null;
    private Boolean clientAuthentication = null;
    private String securityLevel = null;
    private String enabledCiphers = null;
    private String jsseProvider = null;
    private Boolean clientAuthenticationSupported = null;
    private String sslProtocol = null;
    private String trustManagerObjNames = null;
    private String keyManagerName = null;
    private String keyManagerScopeName = null;
    private String keyStoreName = null;
    private String keyStoreScopeName = null;
    private String trustStoreName = null;
    private String trustStoreScopeName = null;
    private ObjectName sslConfigObjName = null;
    private ObjectName scopeObjName = null;
    private ObjectName trustStoreObjName = null;
    private ObjectName keyStoreObjName = null;
    private ObjectName keyManagerObjName = null;
    private List trustManagerObjNameList = null;
    private String keyFileName = null;
    private String SSLConfigType = "JSSE";
    private Integer timeout = null;

    public ModifySSLConfig(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ModifySSLConfig(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        boolean bl = false;
        ObjectName objectName = null;
        try {
            KeyStore keyStore;
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.aliasName = (String)this.getParameter(CommandConstants.ALIAS);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.clientKeyAlias = (String)this.getParameter(CommandConstants.CLIENT_KEY_ALIAS);
            this.serverKeyAlias = (String)this.getParameter(CommandConstants.SERVER_KEY_ALIAS);
            this.clientAuthentication = (Boolean)this.getParameter(CommandConstants.CLIENT_AUTHENTICATION);
            this.securityLevel = (String)this.getParameter(CommandConstants.SECURITY_LEVEL);
            this.enabledCiphers = (String)this.getParameter(CommandConstants.ENABLED_CIPHERS);
            this.jsseProvider = (String)this.getParameter(CommandConstants.JSSE_PROVIDER);
            this.clientAuthenticationSupported = (Boolean)this.getParameter(CommandConstants.CLIENT_AUTHENTICATION_SUPPORTED);
            this.sslProtocol = (String)this.getParameter(CommandConstants.SSL_PROTOCOL);
            this.trustManagerObjNames = (String)this.getParameter(CommandConstants.TRUST_MANAGER_OBJECT_NAMES);
            this.trustStoreName = (String)this.getParameter(CommandConstants.TRUST_STORE_NAME);
            this.trustStoreScopeName = (String)this.getParameter(CommandConstants.TRUST_STORE_SCOPE_NAME);
            this.keyManagerName = (String)this.getParameter(CommandConstants.KEY_MANAGER_NAME);
            this.keyManagerScopeName = (String)this.getParameter(CommandConstants.KEY_MANAGER_SCOPE_NAME);
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScopeName = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE_NAME);
            this.keyFileName = (String)this.getParameter(CommandConstants.SSSL_KEY_RING_NAME);
            this.timeout = (Integer)this.getParameter(CommandConstants.SSSL_V3_TIME_OUT);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLConfig aliasName:  " + this.aliasName);
                Tr.debug(tc, "scopeName:            " + this.scopeName);
                Tr.debug(tc, "clientKeyAlias:       " + this.clientKeyAlias);
                Tr.debug(tc, "serverKeyAlias:       " + this.serverKeyAlias);
                Tr.debug(tc, "clientAuthentication: " + this.clientAuthentication);
                Tr.debug(tc, "securityLevel:        " + this.securityLevel);
                Tr.debug(tc, "enabledCiphers:       " + this.enabledCiphers);
                Tr.debug(tc, "jsseProvider:         " + this.jsseProvider);
                Tr.debug(tc, "clientAuthSupported:  " + this.clientAuthenticationSupported);
                Tr.debug(tc, "sslProtocol:          " + this.sslProtocol);
                Tr.debug(tc, "trustManagerObjNames: " + this.trustManagerObjNames);
                Tr.debug(tc, "trustStoreName:       " + this.trustStoreName);
                Tr.debug(tc, "trustStoreScopeName:  " + this.trustStoreScopeName);
                Tr.debug(tc, "keyManagerName:       " + this.keyManagerName);
                Tr.debug(tc, "keyManagerScopeName:  " + this.keyManagerScopeName);
                Tr.debug(tc, "keyStoreName:         " + this.keyStoreName);
                Tr.debug(tc, "keyStoreScopeName:    " + this.keyStoreScopeName);
                Tr.debug(tc, "keyFileName:          " + this.keyFileName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName3);
                bl = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
                }
            }
            AttributeList attributeList = new AttributeList();
            try {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ALIAS, this.aliasName);
                this.sslConfigObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.REPERTOIRE, attributeList, this.scopeName);
            }
            catch (CommandValidationException commandValidationException) {
                if (bl) {
                    ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ALIAS, this.aliasName);
                    this.sslConfigObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.REPERTOIRE, attributeList, null);
                }
                throw commandValidationException;
            }
            if (this.sslConfigObjName != null) {
                this.SSLConfigType = (String)configService.getAttribute(session, this.sslConfigObjName, CommandConstants.TYPE);
            }
            if (this.securityLevel != null && !commandHelper.contains(CommandConstants.SSLSecurityLevel, this.securityLevel)) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.SSLConfig.invalid.securityLevel.CWPKI611E", "SSL security level is not valid.  Should be HIGH, MEDIUM, LOW, or CUSTOM.");
                throw new CommandValidationException(string);
            }
            if (this.sslProtocol != null && !commandHelper.contains(CommandConstants.SSLProtocol, this.sslProtocol)) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.SSLConfig.invalid.protocol.CWPKI612E", "SSL protocol is not valid.  Should be SSL_TLS, SSL, SSLv2, SSLv3, TLS, or TLSv1.");
                throw new CommandValidationException(string);
            }
            if (this.SSLConfigType.equalsIgnoreCase("JSSE")) {
                ObjectName objectName4;
                Object object;
                if (this.sslConfigObjName == null) {
                    String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0600E", new Object[]{this.aliasName, this.scopeName}, this.aliasName + " does not exist within management scope " + this.scopeName + ".");
                    throw new CommandValidationException(string);
                }
                if (this.keyManagerScopeName == null) {
                    this.keyManagerScopeName = commandHelper.defaultCellScope(objectName3);
                }
                if (this.keyStoreScopeName == null) {
                    this.keyStoreScopeName = commandHelper.defaultCellScope(objectName3);
                }
                if (this.trustStoreScopeName == null) {
                    this.trustStoreScopeName = commandHelper.defaultCellScope(objectName3);
                }
                attributeList.clear();
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
                this.scopeObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.MANAGEMENT_SCOPES, attributeList, null);
                if (this.trustManagerObjNames != null) {
                    keyStore = this.trustManagerObjNames.split(":");
                    this.trustManagerObjNameList = new ArrayList();
                    for (int i = 0; i < ((String[])keyStore).length; ++i) {
                        if (keyStore[i] == null) continue;
                        object = keyStore[i];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "trustManagers[i]: " + (String)keyStore[i]);
                        }
                        if (keyStore[i].indexOf("(") != -1 && keyStore[i].indexOf(")") != -1) {
                            object = keyStore[i].substring(keyStore[i].indexOf("(") + 1, keyStore[i].indexOf(")"));
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "id: " + (String)object);
                            }
                        }
                        if ((objectName4 = commandHelper.getObjectWithinScope(configService, session, "TrustManager", (String)object, this.scopeName)) == null) continue;
                        this.trustManagerObjNameList.add(objectName4);
                    }
                }
                if (this.keyManagerName != null) {
                    attributeList.clear();
                    ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keyManagerName);
                    this.keyManagerObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.KEY_MANAGERS, attributeList, this.keyManagerScopeName);
                }
                if (this.trustStoreName != null) {
                    attributeList.clear();
                    ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.trustStoreName);
                    this.trustStoreObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.KEY_STORES, attributeList, this.trustStoreScopeName);
                }
                if (this.keyStoreName != null) {
                    attributeList.clear();
                    ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keyStoreName);
                    this.keyStoreObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.KEY_STORES, attributeList, this.keyStoreScopeName);
                }
                if (this.clientKeyAlias != null && this.clientKeyAlias.length() > 0 || this.serverKeyAlias != null && this.serverKeyAlias.length() > 0) {
                    keyStore = null;
                    if (this.keyStoreObjName != null) {
                        keyStore = (KeyStore)MOFUtil.convertToEObject(session, this.keyStoreObjName);
                    } else {
                        AttributeList attributeList2 = configService.getAttributes(session, this.sslConfigObjName, null, true);
                        object = (AttributeList)ConfigServiceHelper.getAttributeValue(attributeList2, CommandConstants.SETTING);
                        objectName4 = (ObjectName)ConfigServiceHelper.getAttributeValue((AttributeList)object, CommandConstants.KEY_STORE);
                        keyStore = (KeyStore)MOFUtil.convertToEObject(session, objectName4);
                    }
                    if (this.clientKeyAlias != null && this.clientKeyAlias.length() > 0 && !PersonalCertificateHelper.isAliasInKeyStore(this.clientKeyAlias, keyStore)) {
                        String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.in.keystore.CWPKI0672E", new Object[]{this.clientKeyAlias, keyStore.getName()}, "Alias " + this.clientKeyAlias + " is not a personal certificate in key store " + keyStore.getName() + ".");
                        throw new CommandValidationException(string);
                    }
                    if (this.serverKeyAlias != null && this.serverKeyAlias.length() > 0 && !PersonalCertificateHelper.isAliasInKeyStore(this.serverKeyAlias, keyStore)) {
                        String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.in.keystore.CWPKI0672E", new Object[]{this.serverKeyAlias, keyStore.getName()}, "Alias " + this.serverKeyAlias + " is not a personal certificate in key store " + keyStore.getName() + ".");
                        throw new CommandValidationException(string);
                    }
                }
            }
            if (this.SSLConfigType.equalsIgnoreCase("SSSL")) {
                if (this.sslConfigObjName == null) {
                    keyStore = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0682E", new Object[]{this.aliasName}, this.aliasName + " does not exist.");
                    throw new CommandValidationException((String)keyStore);
                }
                if (this.timeout != null && (this.timeout < 1 || this.timeout > 86400)) {
                    keyStore = TraceNLSHelper.getInstance().getString("ssl.command.timeout.range.CWPKI0683E", "V3 time out range is between 1 and 86400.");
                    throw new CommandValidationException((String)keyStore);
                }
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.modifySSLConfig.validate", "311", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        block35: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "beforeStepsExecuted");
            }
            super.beforeStepsExecuted();
            ObjectName objectName = null;
            TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
            if (!taskCommandResultImpl.isSuccessful()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beforeStepsExecuted");
                }
                return;
            }
            try {
                ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
                ConfigService configService = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                objectName = configService.resolve(session, "Cell=:Security=")[0];
                AttributeList attributeList = new AttributeList();
                AttributeList attributeList2 = configService.getAttributes(session, this.sslConfigObjName, null, true);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "repertoire: " + attributeList2);
                }
                if (attributeList2.size() <= 0) break block35;
                AttributeList attributeList3 = (AttributeList)ConfigServiceHelper.getAttributeValue(attributeList2, CommandConstants.SETTING);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting: " + attributeList3);
                }
                ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList3), null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "matches: " + objectNameArray[0]);
                }
                if (objectNameArray.length == 1) {
                    Object object;
                    attributeList.clear();
                    if (this.clientAuthentication != null) {
                        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.CLIENT_AUTHENTICATION, this.clientAuthentication);
                    }
                    if (this.securityLevel != null) {
                        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SECURITY_LEVEL, this.securityLevel);
                    }
                    if (this.clientAuthenticationSupported != null) {
                        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.CLIENT_AUTHENTICATION_SUPPORTED, this.clientAuthenticationSupported);
                    }
                    if (this.SSLConfigType.equals("JSSE")) {
                        if (this.clientKeyAlias != null) {
                            if (this.clientKeyAlias.length() > 0) {
                                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.CLIENT_KEY_ALIAS, this.clientKeyAlias);
                            } else {
                                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.CLIENT_KEY_ALIAS, null);
                            }
                        }
                        if (this.serverKeyAlias != null) {
                            if (this.serverKeyAlias.length() > 0) {
                                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SERVER_KEY_ALIAS, this.serverKeyAlias);
                            } else {
                                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SERVER_KEY_ALIAS, null);
                            }
                        }
                        if (this.jsseProvider != null) {
                            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.JSSE_PROVIDER, this.jsseProvider);
                        }
                        if (this.sslProtocol != null) {
                            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SSL_PROTOCOL, this.sslProtocol);
                        }
                        if (this.trustManagerObjNameList != null) {
                            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.TRUST_MANAGER, this.trustManagerObjNameList);
                        }
                        if (this.trustStoreObjName != null) {
                            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.TRUST_STORE, this.trustStoreObjName);
                        }
                        if (this.keyManagerObjName != null) {
                            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.KEY_MANAGER, this.keyManagerObjName);
                        }
                        if (this.keyStoreObjName != null) {
                            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.KEY_STORE, this.keyStoreObjName);
                        }
                        if (this.enabledCiphers != null) {
                            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ENABLED_CIPHERS, this.enabledCiphers);
                        }
                    } else {
                        if (this.keyFileName != null) {
                            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SSSL_KEY_FILE_NAME, this.keyFileName);
                        }
                        if (this.enabledCiphers != null) {
                            object = SSLConfigManager.getInstance().convertCiphersList(this.enabledCiphers);
                            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ENABLED_CIPHERS, object);
                        }
                    }
                    configService.setAttributes(session, objectNameArray[0], attributeList);
                    if (this.SSLConfigType.equals("SSSL") && (this.sslProtocol != null || this.jsseProvider != null || this.timeout != null)) {
                        object = new AttributeList();
                        ObjectName objectName3 = null;
                        AttributeList attributeList4 = configService.getAttributes(session, objectNameArray[0], new String[]{"properties"}, false);
                        List list = (List)((Attribute)attributeList4.get(0)).getValue();
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            objectName3 = (ObjectName)iterator.next();
                            String string = (String)configService.getAttribute(session, objectName3, "name");
                            if (string.equals("com.ibm.ssl.contextProvider") && this.jsseProvider != null) {
                                configService.deleteConfigData(session, objectName3);
                                ((ArrayList)object).clear();
                                ((AttributeList)object).add(new Attribute(CommandConstants.NAME, "com.ibm.ssl.contextProvider"));
                                ((AttributeList)object).add(new Attribute(CommandConstants.VALUE, this.jsseProvider));
                                configService.createConfigData(session, objectNameArray[0], CommandConstants.PROPERTIES, null, (AttributeList)object);
                            }
                            if (string.equals("com.ibm.ssl.protocol") && this.sslProtocol != null) {
                                configService.deleteConfigData(session, objectName3);
                                ((ArrayList)object).clear();
                                ((AttributeList)object).add(new Attribute(CommandConstants.NAME, "com.ibm.ssl.protocol"));
                                ((AttributeList)object).add(new Attribute(CommandConstants.VALUE, this.sslProtocol));
                                configService.createConfigData(session, objectNameArray[0], CommandConstants.PROPERTIES, null, (AttributeList)object);
                            }
                            if (!string.equals("was.com.ibm.ssl.sys.v3.timeout") || this.timeout == null) continue;
                            configService.deleteConfigData(session, objectName3);
                            ((ArrayList)object).clear();
                            ((AttributeList)object).add(new Attribute(CommandConstants.NAME, "was.com.ibm.ssl.sys.v3.timeout"));
                            ((AttributeList)object).add(new Attribute(CommandConstants.VALUE, this.timeout.toString()));
                            configService.createConfigData(session, objectNameArray[0], CommandConstants.PROPERTIES, null, (AttributeList)object);
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting attrList: " + attributeList);
                    }
                    break block35;
                }
                throw new InvalidParameterValueException(this.getName(), CommandConstants.SETTING, attributeList3);
            }
            catch (Exception exception) {
                taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

