/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfigGroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.ManagementScopeData;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateSSLConfigGroup
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateSSLConfigGroup.class, "SSL", "com.ibm.ws.ssl.commands");
    private String name = null;
    private String direction = null;
    private String certificateAlias = null;
    private String scopeName = null;
    private String sslConfigAliasName = null;
    private String sslConfigScopeName = null;
    private ObjectName scopeObjName = null;
    private ObjectName sslConfigObjName = null;
    private boolean createMgmScope = false;

    public CreateSSLConfigGroup(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public CreateSSLConfigGroup(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.name = (String)this.getParameter(CommandConstants.NAME);
            this.direction = (String)this.getParameter(CommandConstants.DIRECTION);
            this.certificateAlias = (String)this.getParameter(CommandConstants.CERTIFICATE_ALIAS);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.sslConfigAliasName = (String)this.getParameter(CommandConstants.SSL_CONFIG_ALIAS_NAME);
            this.sslConfigScopeName = (String)this.getParameter(CommandConstants.SSL_CONFIG_SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLConfigGroup: " + this.name);
                Tr.debug(tc, "direction: " + this.direction);
                Tr.debug(tc, "scopeName: " + this.scopeName);
                Tr.debug(tc, "sslConfigScopeName: " + this.sslConfigScopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName3);
            } else if (!ManagementScopeHelper.validScopeName(session, configService, this.scopeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                }
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                throw new CommandValidationException(string);
            }
            if (this.sslConfigScopeName == null) {
                this.sslConfigScopeName = commandHelper.defaultCellScope(objectName3);
            }
            if (this.direction != null && !this.direction.equalsIgnoreCase("inbound") && !this.direction.equalsIgnoreCase("outbound")) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.SSLConfig.invalid.direction.CWPKI0614E", "Direction is not valid.  Should be inbound or outbound.");
                throw new CommandValidationException(string);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.name);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.DIRECTION, this.direction);
            boolean bl = commandHelper.exists(configService, session, objectName, CommandConstants.SSL_CONFIG_GROUPS, attributeList, this.scopeName);
            if (bl) {
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.SSLConfigGroup.already.exists.CWPKI0615E", new Object[]{this.name, this.direction, this.scopeName}, "SSL configuration group " + this.name + " in direction " + this.direction + " and management scope " + this.scopeName + " already exists.");
                throw new CommandValidationException(string);
            }
            attributeList.clear();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
            boolean bl2 = commandHelper.exists(configService, session, objectName, CommandConstants.MANAGEMENT_SCOPES, attributeList, null);
            if (!bl2) {
                this.createMgmScope = true;
            } else {
                this.scopeObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.MANAGEMENT_SCOPES, attributeList, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "scopeObjName: " + this.scopeObjName);
                }
            }
            if (this.sslConfigAliasName != null) {
                attributeList.clear();
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ALIAS, this.sslConfigAliasName);
                this.sslConfigObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.REPERTOIRE, attributeList, this.sslConfigScopeName);
                AttributeList attributeList2 = configService.getAttributes(session, this.sslConfigObjName, null, true);
                if (attributeList2 != null) {
                    boolean bl3 = commandHelper.withInScope(configService, session, attributeList2, this.scopeName);
                    if (!bl3) {
                        String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.SSLConfig.config.not.within.scope.CWPKI0616E", new Object[]{this.sslConfigAliasName}, "SSL Configuration " + this.sslConfigAliasName + " is not with in the same management scope as the SSL configuration group.");
                        throw new CommandValidationException(string);
                    }
                } else {
                    String string = "Attribute list for SSLConfig is null.";
                    throw new CommandValidationException(string);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sslConfigObjName: " + this.sslConfigObjName);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.createSSLConfigGroup.validate", "216", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            Object object;
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            AttributeList attributeList = new AttributeList();
            if (this.createMgmScope) {
                object = new ManagementScopeData(this.scopeName);
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_TYPE, ((ManagementScopeData)object).getScopeType());
                this.scopeObjName = configService.createConfigData(session, objectName, CommandConstants.MANAGEMENT_SCOPES, null, attributeList);
                attributeList.clear();
            }
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.name);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.DIRECTION, this.direction);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.CERTIFICATE_ALIAS, this.certificateAlias);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SSL_CONFIG, this.sslConfigObjName);
            object = configService.createConfigData(session, objectName, CommandConstants.SSL_CONFIG_GROUPS, null, attributeList);
            if (object != null) {
                taskCommandResultImpl.setResult(object);
            }
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

