/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.WSSchedule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.io.Serializable;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteWSSchedule
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteWSSchedule.class, "SSL", "com.ibm.ws.ssl.commands");
    private String wsScheduleName = null;
    private ObjectName wsScheduleObjName = null;

    public DeleteWSSchedule(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public DeleteWSSchedule(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            String string;
            Serializable serializable;
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.wsScheduleName = (String)this.getParameter(CommandConstants.NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsScheduleName: " + this.wsScheduleName);
            }
            CommandHelper commandHelper = new CommandHelper();
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.wsScheduleName);
            this.wsScheduleObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.WS_SCHEDULES, attributeList, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsScheduleObjName: " + this.wsScheduleObjName);
            }
            AttributeList attributeList2 = new AttributeList();
            AttributeList attributeList3 = (AttributeList)configService.getAttribute(session, objectName, CommandConstants.WS_CERT_EXP_MONITOR);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsCertExpMonitor: " + attributeList3);
            }
            if (attributeList3 != null) {
                serializable = (ObjectName)ConfigServiceHelper.getAttributeValue(attributeList3, CommandConstants.WS_SCHEDULE);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "schedule: " + serializable);
                }
                if (serializable != null && this.wsScheduleObjName.equals(serializable)) {
                    string = (String)ConfigServiceHelper.getAttributeValue(attributeList3, CommandConstants.NAME);
                    attributeList2.add(new Attribute(CommandConstants.WS_CERT_EXP_MONITOR, string));
                }
            }
            if (((ArrayList)(serializable = commandHelper.getReference(configService, session, objectName, CommandConstants.KEY_SET_GROUPS, CommandConstants.WS_SCHEDULE, this.wsScheduleObjName))).size() > 0) {
                attributeList2.addAll((AttributeList)serializable);
            }
            if (attributeList2.size() > 0) {
                string = "This object is referenced by " + attributeList2;
                throw new CommandValidationException(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.deleteWSSchedule.validate", "163", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            configService.deleteConfigData(session, this.wsScheduleObjName);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

