/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.certificateRequests;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import java.security.KeyFactory;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;

public class CertificateRequestHelper {
    private static TraceComponent tc = Tr.register(CertificateRequestHelper.class, "SSL", "com.ibm.ws.ssl.commands.certificateRequests");

    public static AttributeList certReqAttrlist(String string, X509Certificate x509Certificate, String string2) throws Exception {
        AttributeList attributeList = new AttributeList();
        attributeList.clear();
        if (string != null) {
            ConfigServiceHelper.setAttributeValue(attributeList, "alias", string);
        }
        if (string2 != null) {
            ConfigServiceHelper.setAttributeValue(attributeList, "filename", string2);
        }
        try {
            String string3;
            PublicKey publicKey = x509Certificate.getPublicKey();
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
            KeyFactory keyFactory = KeyFactory.getInstance(publicKey.getAlgorithm());
            int n = 0;
            PublicKey publicKey2 = keyFactory.generatePublic(x509EncodedKeySpec);
            n = publicKey2 instanceof RSAPublicKey ? ((RSAPublicKey)publicKey2).getModulus().bitLength() : ((DSAPublicKey)publicKey2).getY().bitLength();
            if (n % 2 != 0) {
                ++n;
            }
            ConfigServiceHelper.setAttributeValue(attributeList, "size", String.valueOf(n));
            ConfigServiceHelper.setAttributeValue(attributeList, "serialNumber", x509Certificate.getSerialNumber());
            Principal principal = x509Certificate.getIssuerDN();
            if (principal != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, "requestedBy", ((Object)principal).toString());
            }
            if ((string3 = KeyStoreManager.getInstance().generateDigest("SHA-1", x509Certificate)) != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, "fingerPrint", string3);
            }
            String string4 = x509Certificate.getSigAlgName();
            String string5 = x509Certificate.getSigAlgOID();
            if (string4 != null && string5 != null) {
                String string6 = new String(string4 + "(" + string5 + ")");
                ConfigServiceHelper.setAttributeValue(attributeList, "signatureAlgorithm", string6);
            }
        }
        catch (Exception exception) {
            throw new CommandValidationException(exception.getMessage());
        }
        return attributeList;
    }

    public static String isKeyCertReq(X509Certificate x509Certificate, String string) {
        String string2;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isKeyCertReq");
            }
            boolean bl = false;
            string2 = null;
            Object var4_4 = null;
            try {
                Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
                if (collection != null) {
                    Iterator<List<?>> iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        List<?> list = iterator.next();
                        Integer n = (Integer)list.get(0);
                        String string3 = (String)list.get(1);
                        if (n == 1) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Certreq id found for in cert for " + string);
                            }
                            if (string3.equals("certreq@us.ibm.com")) {
                                bl = true;
                            }
                        }
                        if (n != 6) continue;
                        string2 = string3;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Certreq file name, " + string2 + " found for " + string);
                    }
                    if (bl && string2 != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "This is a certificate request return the file name.");
                        }
                    } else {
                        bl = false;
                        string2 = null;
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "Exception checking to certificate.", new Object[]{exception});
            }
        }
        if (string2 != null) {
            string2 = string2.substring(string2.indexOf("file://") + 7);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKeyCertReq");
        }
        return string2;
    }
}

