/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyReferences;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.ipc.ssl.KeyReference;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateKeyReference
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateKeyReference.class, "SSL", "com.ibm.ws.ssl.commands");
    private String keySetName = null;
    private String keySetScope = null;
    private String keyAlias = null;
    private String keyPassword = null;
    private String keyPasswordVerify = null;
    private Integer version = null;
    private Boolean saveConfig = Boolean.FALSE;
    private ObjectName keySetObjName = null;

    public CreateKeyReference(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public CreateKeyReference(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        boolean bl = false;
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.keySetName = (String)this.getParameter(CommandConstants.KEY_SET_NAME);
            this.keySetScope = (String)this.getParameter(CommandConstants.KEY_SET_SCOPE);
            this.keyAlias = (String)this.getParameter(CommandConstants.KEY_ALIAS);
            this.keyPassword = (String)this.getParameter(CommandConstants.KEY_PASSWORD);
            this.keyPasswordVerify = (String)this.getParameter(CommandConstants.KEY_PASSWORD_VERIFY);
            this.version = (Integer)this.getParameter(CommandConstants.VERSION);
            this.saveConfig = (Boolean)this.getParameter(CommandConstants.KEY_REFERENCE_SAVE_CONFIG);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keySetName= " + this.keySetName + " keySetScope=" + this.keySetScope + " keyAlias=" + this.keyAlias + " version=" + this.version + " saveConfig=" + this.saveConfig);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keySetScope == null) {
                this.keySetScope = commandHelper.defaultCellScope(objectName3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell keySetScope: " + this.keySetScope);
                }
            }
            if (this.keyPassword != null && this.keyPasswordVerify == null || this.keyPassword == null && this.keyPasswordVerify != null) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.password.missing.CWPKI0632E", "Both password and verify password were not supplied.");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Both password and verify password were not supplied.");
                }
                throw new CommandValidationException(string);
            }
            if (this.keyPassword != null && !KeyStoreHelper.passwordVerify(this.keyPassword, this.keyPasswordVerify)) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.keyStore.password.not.confirm.CWPKI0619E", "Passwords do not match.");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Password did not verify.");
                }
                throw new CommandValidationException(string);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keySetName);
            this.keySetObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.KEY_SETS, attributeList, this.keySetScope);
            if (this.keySetObjName == null) {
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0600E", new Object[]{this.keySetName, this.keySetScope}, this.keySetName + " does not exists within scope " + this.keySetScope);
                throw new CommandValidationException(string);
            }
            attributeList.clear();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.KEY_ALIAS, this.keyAlias);
            boolean bl2 = commandHelper.exists(configService, session, this.keySetObjName, CommandConstants.KEY_REFERENCE, attributeList, null);
            if (bl2) {
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyReference.already.exists.CWPKI0618", new Object[]{this.keyAlias, this.keySetName}, "Key alias " + this.keyAlias + " already exist in key set " + this.keySetName + ".");
                throw new CommandValidationException(string);
            }
            attributeList.clear();
        }
        catch (ConfigServiceException configServiceException) {
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        boolean bl = false;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            List list;
            CommandResult commandResult;
            AdminCommand adminCommand;
            CommandMgr commandMgr;
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName2 = null;
            ObjectName objectName3 = configService.resolve(session, "Cell=:Security=")[0];
            AttributeList attributeList = new AttributeList();
            Integer n = (Integer)configService.getAttribute(session, this.keySetObjName, "maxKeyReferences");
            Boolean bl2 = (Boolean)configService.getAttribute(session, this.keySetObjName, "deleteOldKeys");
            if (this.version != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Version passed in: " + this.version);
                }
                ConfigServiceHelper.setAttributeValue(attributeList, "version", this.version);
            } else {
                commandMgr = CommandMgr.getCommandMgr();
                adminCommand = commandMgr.createCommand("listKeyReferences");
                adminCommand.setConfigSession(session);
                adminCommand.setParameter("keySetName", this.keySetName);
                adminCommand.setParameter("keySetScope", this.keySetScope);
                adminCommand.execute();
                commandResult = adminCommand.getCommandResult();
                if (commandResult.isSuccessful()) {
                    list = (List)commandResult.getResult();
                    int n2 = 0;
                    ObjectName objectName4 = null;
                    int n3 = 0;
                    for (int i = 0; i < list.size(); ++i) {
                        ObjectName objectName5 = (ObjectName)list.get(i);
                        KeyReference keyReference = (KeyReference)MOFUtil.convertToEObject(session, objectName5);
                        if (keyReference != null && keyReference.getVersion() > n2) {
                            n2 = keyReference.getVersion();
                        }
                        if (objectName4 != null && n3 <= keyReference.getVersion()) continue;
                        n3 = keyReference.getVersion();
                        objectName4 = objectName5;
                    }
                    this.version = new Integer(++n2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Version generated: " + this.version);
                    }
                    ConfigServiceHelper.setAttributeValue(attributeList, "version", this.version);
                    if (list.size() >= n && bl2.booleanValue()) {
                        if (objectName4 != null) {
                            configService.deleteConfigData(session, objectName4);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removing " + objectName4);
                        }
                    }
                } else {
                    throw commandResult.getException();
                }
            }
            if (this.keyAlias != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, "keyAlias", this.keyAlias);
            } else {
                commandMgr = CommandMgr.getCommandMgr();
                adminCommand = commandMgr.createCommand("getKeySet");
                adminCommand.setConfigSession(session);
                adminCommand.setParameter("name", this.keySetName);
                adminCommand.setParameter("scopeName", this.keySetScope);
                adminCommand.execute();
                commandResult = adminCommand.getCommandResult();
                if (commandResult.isSuccessful()) {
                    list = (AttributeList)commandResult.getResult();
                    String string = (String)ConfigServiceHelper.getAttributeValue((AttributeList)list, CommandConstants.ALIAS_PREFIX);
                    this.keyAlias = string + "_" + this.version;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "keyAlias generated: " + this.keyAlias);
                    }
                    ConfigServiceHelper.setAttributeValue(attributeList, "keyAlias", this.keyAlias);
                } else {
                    throw commandResult.getException();
                }
            }
            if (this.keyPassword != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, "password", this.keyPassword);
            }
            objectName2 = configService.createConfigData(session, this.keySetObjName, CommandConstants.KEY_REFERENCE, null, attributeList);
            if (this.saveConfig != null && this.saveConfig.booleanValue()) {
                configService.save(session, true);
            }
            taskCommandResultImpl.setResult(objectName2);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.ssl.commands.CreateKeyReference.beforeStepsExecuted", "345", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred.", new Object[]{throwable});
            }
            taskCommandResultImpl.setException(new CommandException(throwable, "CreateKeyReference command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

