/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyReferences;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteKeyReference
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteKeyReference.class, "DeleteKeyReference", "com.ibm.ws.ssl.commands");
    private String keySetName = null;
    private String keySetScope = null;
    private String keyAlias = null;
    private ObjectName keySetObjName = null;

    public DeleteKeyReference(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public DeleteKeyReference(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.keySetName = (String)this.getParameter(CommandConstants.KEY_SET_NAME);
            this.keySetScope = (String)this.getParameter(CommandConstants.KEY_SET_SCOPE);
            this.keyAlias = (String)this.getParameter(CommandConstants.KEY_ALIAS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keySetName=" + this.keySetName + " keySetScope=" + this.keySetScope + "keyAlias=" + this.keyAlias);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keySetScope == null) {
                this.keySetScope = commandHelper.defaultCellScope(objectName3);
                Tr.debug(tc, "Default cell keySetScope: " + this.keySetScope);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keySetName);
            this.keySetObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.KEY_SETS, attributeList, this.keySetScope);
            if (this.keySetObjName == null) {
                String string = this.keySetName + " object does not exist.";
                throw new CommandValidationException(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName4 = configService.resolve(session, "Cell=")[0];
            if (objectName4 != null) {
                objectName = configService.queryConfigObjects(session, objectName4, objectName3, null)[0];
            }
            CommandHelper commandHelper = new CommandHelper();
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.KEY_ALIAS, this.keyAlias);
            objectName2 = commandHelper.getObjectName(configService, session, this.keySetObjName, CommandConstants.KEY_REFERENCE, attributeList, null);
            if (objectName2 != null) {
                configService.deleteConfigData(session, objectName2);
            }
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, "DeleteKeyReference command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

