/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyReferences;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class GetKeyReference
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(GetKeyReference.class, "GetKeyReference", "com.ibm.ws.ssl.commands");
    private String keySetName = null;
    private String keySetScope = null;
    private String keyAlias = null;
    private ObjectName keySetObjName = null;

    public GetKeyReference(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public GetKeyReference(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        try {
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName2 = configService.resolve(session, "Cell=:Security=")[0];
            this.keySetName = (String)this.getParameter(CommandConstants.KEY_SET_NAME);
            this.keySetScope = (String)this.getParameter(CommandConstants.KEY_SET_SCOPE);
            this.keyAlias = (String)this.getParameter(CommandConstants.KEY_ALIAS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keySetName=" + this.keySetName + " keySetScope=" + this.keySetScope + " keyAlias=" + this.keyAlias);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keySetScope == null) {
                this.keySetScope = commandHelper.defaultCellScope(objectName2);
                Tr.debug(tc, "Default cell keySetScope: " + this.keySetScope);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keySetName);
            this.keySetObjName = commandHelper.getObjectName(configService, session, objectName2, CommandConstants.KEY_SETS, attributeList, this.keySetScope);
            if (this.keySetObjName == null) {
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0600E", new Object[]{this.keySetName, this.keySetScope}, this.keySetName + " does not exists within scope " + this.keySetScope);
                throw new CommandValidationException(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            Object var7_8 = null;
            List list = (List)configService.getAttribute(session, this.keySetObjName, CommandConstants.KEY_REFERENCE);
            boolean bl = false;
            Object object = list.iterator();
            while (object.hasNext()) {
                AttributeList attributeList = (AttributeList)object.next();
                String string = (String)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.KEY_ALIAS);
                if (!string.equals(this.keyAlias)) continue;
                String string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "password");
                if (string2 != null) {
                    attributeList.remove(new Attribute("password", string2));
                    attributeList.add(new Attribute("password", "*****"));
                }
                taskCommandResultImpl.setResult(attributeList);
                bl = true;
                break;
            }
            if (!bl) {
                object = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.key.reference.does.not.exist.CWPKI0631E", new Object[]{this.keyAlias, this.keySetName}, "Key reference \"" + this.keyAlias + "\" does not exist in key set \"" + this.keySetName + "\".");
                throw new CommandValidationException((String)object);
            }
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

