/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.cmskeystore.CMSLoadStoreParameterFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.CertificateManager;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

public class CreateCMSKeyStore
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateCMSKeyStore.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private String cmsKeyStoreURI = null;
    private String pluginHostName = null;
    private String keyStoreName = null;
    private String keyStoreLocation = null;
    private String workspaceKeyStoreLocation = null;
    private String nodeName = null;
    private String cellName = null;
    private String serverName = null;
    private String scopeName = null;
    private ObjectName mgmScopeObjName = null;
    private boolean createMgmScope = false;
    private String vmName = System.getProperty("java.vm.name");

    public CreateCMSKeyStore(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public CreateCMSKeyStore(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        ObjectName objectName3 = null;
        Object var6_6 = null;
        boolean bl = false;
        try {
            objectName = ConfigServiceHelper.createObjectName(null, "Security");
            objectName2 = configService.resolve(session, "Cell=")[0];
            if (objectName2 != null) {
                objectName3 = configService.queryConfigObjects(session, objectName2, objectName, null)[0];
            }
            this.cmsKeyStoreURI = (String)this.getParameter(CommandConstants.CMS_KEY_STORE_URI);
            this.pluginHostName = (String)this.getParameter(CommandConstants.PLUGIN_HOSTNAME);
            String string = System.getProperty("was.repository.root");
            String string2 = (System.getProperty("websphere.workspace.root") != null ? System.getProperty("websphere.workspace.root") : System.getProperty("user.install.root")) + File.separator + "wstemp";
            String string3 = null;
            String string4 = null;
            string4 = string != null ? string : KeyStoreManager.getInstance().expand("${CONFIG_ROOT}");
            string3 = string2 != null ? string2 + File.separator + session.toString() + "/workspace" : KeyStoreManager.getInstance().expand("${WORKSPACE_ROOT}/" + session.toString() + "/workspace");
            this.keyStoreLocation = CreateCMSKeyStore.fixupLocationWithRepositoryRoot(string4, this.cmsKeyStoreURI);
            this.workspaceKeyStoreLocation = CreateCMSKeyStore.fixupLocationWithRepositoryRoot(string3, this.cmsKeyStoreURI);
            this.scopeName = this.getScopeFromURI(this.keyStoreLocation);
            this.keyStoreName = "CMSKeyStore";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cmsKeyStoreURI=" + this.cmsKeyStoreURI + " pluginHostName=" + this.pluginHostName + " keyStoreName=" + this.keyStoreName + " keyStoreLocation=" + this.keyStoreLocation + " scope=" + this.scopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
                }
            } else if (!ManagementScopeHelper.validScopeName(session, configService, this.scopeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                }
                String string5 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                throw new CommandValidationException(string5);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keyStoreName);
            bl = commandHelper.exists(configService, session, objectName3, CommandConstants.KEY_STORES, attributeList, this.scopeName);
            if (bl) {
                String string6 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.already.exists.CWPKI0601E", new Object[]{this.keyStoreName, this.scopeName}, this.keyStoreName + " in the management scope " + this.scopeName + " already exists.");
                throw new CommandValidationException(string6);
            }
            attributeList.clear();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
            boolean bl2 = commandHelper.exists(configService, session, objectName3, CommandConstants.MANAGEMENT_SCOPES, attributeList, null);
            if (!bl2) {
                this.createMgmScope = true;
            } else {
                this.mgmScopeObjName = commandHelper.getObjectName(configService, session, objectName3, CommandConstants.MANAGEMENT_SCOPES, attributeList, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "mgmScopeObjName: " + this.mgmScopeObjName);
                }
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigService exception is" + configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException, configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + exception.getMessage());
            }
            throw new CommandValidationException(exception, exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    private String getNodeURIFromPath(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellURIFromPath", new Object[]{string});
        }
        String string2 = null;
        int n = string.indexOf("nodes/");
        string2 = n != -1 ? string.substring(n) : string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellURIFromPath");
        }
        return string2;
    }

    private String changeToStashURIPath(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeToStashURIPath", new Object[]{string});
        }
        int n = string.lastIndexOf(".");
        String string2 = null;
        if (n != -1) {
            String string3 = string.substring(0, n);
            string2 = string3 + ".sth";
        } else {
            string2 = string;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeToStashURIPath -> " + string2);
        }
        return string2;
    }

    private String getScopeFromURI(String string) throws CommandValidationException {
        string = string.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getScopeFromURI", new Object[]{string});
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = string.indexOf("/cells/");
            int n2 = n + "/cells/".length();
            int n3 = string.indexOf("/nodes/");
            int n4 = string.indexOf("/servers/");
            this.cellName = string.substring(n2, n3);
            this.nodeName = string.substring(n3 + "/nodes/".length(), n4);
            this.serverName = string.substring(n4 + "/servers/".length(), string.lastIndexOf("/"));
            stringBuffer.append("(cell):");
            stringBuffer.append(this.cellName);
            stringBuffer.append(":(node):");
            stringBuffer.append(this.nodeName);
            stringBuffer.append(":(server):");
            stringBuffer.append(this.serverName);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getScopeFromURI exception is" + exception.getMessage());
            }
            InvalidParameterValueException invalidParameterValueException = new InvalidParameterValueException(this.getName(), "cmsKeyStoreURI", string);
            throw new CommandValidationException(invalidParameterValueException, invalidParameterValueException.getMessage() + ".  Please put the KeyStore under <USER.INSTALL.ROOT>/config/cells/<cell_name>/nodes/<node_name>/servers/<server_name>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScopeFromURI -> " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        AttributeList attributeList = new AttributeList();
        ConfigService configService = null;
        Session session = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            String string;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "Security");
            configService = ConfigServiceFactory.getConfigService();
            session = this.getConfigSession();
            ObjectName objectName4 = configService.resolve(session, "Cell=")[0];
            if (objectName4 != null) {
                objectName2 = configService.queryConfigObjects(session, objectName4, objectName3, null)[0];
            }
            if (this.createMgmScope) {
                object4 = new ManagementScopeData(this.scopeName);
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_TYPE, ((ManagementScopeData)object4).getScopeType());
                this.mgmScopeObjName = configService.createConfigData(session, objectName2, CommandConstants.MANAGEMENT_SCOPES, null, attributeList);
                attributeList.clear();
            }
            object4 = null;
            String string2 = null;
            String string3 = "WebAS";
            if (PlatformHelperFactory.getPlatformHelper().isOS400() && this.vmName.equals("Classic VM")) {
                object4 = "IBMi5OSKeyStore";
                string2 = "IBMi5OSJSSEProvider";
            } else {
                object4 = "CMSKS";
                string2 = "IBMCMSProvider";
            }
            KeyStoreInfo keyStoreInfo = new KeyStoreInfo(this.keyStoreName, this.keyStoreLocation, string3, string2, (String)object4, Boolean.TRUE, null, this.scopeName, this.mgmScopeObjName, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, null, new Integer(0), Boolean.FALSE, null);
            objectName = KeyStoreHelper.createKeyStoreObjectName(session, keyStoreInfo);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.MANAGEMENT_SCOPE, this.mgmScopeObjName);
            configService.setAttributes(session, objectName, attributeList);
            attributeList.clear();
            com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)MOFUtil.convertToEObject(session, objectName);
            Object object5 = null;
            Object object6 = null;
            ManagementScopeData managementScopeData = new ManagementScopeData(this.scopeName);
            Security security2 = (Security)MOFUtil.convertToEObject(session, objectName2);
            EList eList = security2.getKeyStores();
            String string4 = KeyStoreManager.getInstance().expand("${CONFIG_ROOT}");
            for (int i = 0; i < eList.size(); ++i) {
                object3 = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)eList.get(i);
                object2 = CreateCMSKeyStore.fixupLocationWithRepositoryRoot(string4, object3.getLocation());
                object2 = KeyStoreManager.getInstance().expand((String)object2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Keystore location: " + (String)object2);
                }
                if (!((File)(object = new File((String)object2))).exists()) continue;
                if (object3.getName().endsWith("DefaultTrustStore")) {
                    object5 = object3;
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Using trust store name: " + object5.getName());
                    continue;
                }
                if (!object3.getName().endsWith("DefaultKeyStore")) continue;
                object6 = object3;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Using key store name: " + object6.getName());
            }
            KeyStoreInfo keyStoreInfo2 = PersonalCertificateHelper.getKsInfo(session, configService, object5.getName(), object5.getManagementScope().getScopeName());
            this.checkIfCMSKeyStoreExistsAndCreateIfNot((com.ibm.websphere.models.config.ipc.ssl.KeyStore)object6, (com.ibm.websphere.models.config.ipc.ssl.KeyStore)object5, keyStoreInfo2, this.workspaceKeyStoreLocation, keyStore, this.pluginHostName);
            PersonalCertificateHelper.setWorkspaceUpdated(session, keyStoreInfo2.getLocation());
            object3 = WorkSpaceManagerFactory.getManager().getWorkSpace(session.toString());
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "cellName = " + this.cellName);
            }
            object2 = new ManagementScopeData(object5.getManagementScope().getScopeName());
            object = object3.findContext("cells/" + ((ManagementScopeData)object2).getCellName());
            String string5 = this.getNodeURIFromPath(this.workspaceKeyStoreLocation);
            if (string5 != null) {
                object.notifyChanged(0, string5);
            }
            if ((string = this.changeToStashURIPath(string5)) != null) {
                object.notifyChanged(0, string);
            }
            taskCommandResultImpl.setResult(objectName);
        }
        catch (Exception exception) {
            try {
                if (objectName != null && configService != null && session != null) {
                    configService.deleteConfigData(session, objectName);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    private static String fixupLocationWithRepositoryRoot(String string, String string2) {
        string2 = string2.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixupLocationWithRepositoryRoot", new Object[]{string, string2});
        }
        int n = string2.indexOf("/cells/");
        String string3 = string2;
        if (n != -1) {
            String string4 = string2.substring(n);
            string3 = string + string4;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixupLocationWithRepositoryRoot -> " + string3);
        }
        return string3;
    }

    public void checkIfCMSKeyStoreExistsAndCreateIfNot(com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore, com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore2, KeyStoreInfo keyStoreInfo, String string, com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore3, String string2) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfCMSKeyStoreExistsAndCreateIfNot", new Object[]{keyStore3.getLocation(), string2});
        }
        try {
            int n;
            Object object;
            Certificate[] certificateArray;
            Object object2;
            Enumeration<String> enumeration;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            String string3;
            String string4;
            Object object7;
            Object object8;
            Object object9;
            boolean bl;
            boolean bl2 = false;
            JSSEProviderFactory.initializeIBMCMSProvider();
            String string5 = System.getProperty("was.repository.root");
            String string6 = null;
            string6 = string5 != null ? string5 : KeyStoreManager.getInstance().expand("${CONFIG_ROOT}");
            String string7 = keyStore3.getLocation();
            boolean bl3 = false;
            string7 = CreateCMSKeyStore.fixupLocationWithRepositoryRoot(string6, string7);
            KeyStore keyStore4 = null;
            KeyStore.LoadStoreParameter loadStoreParameter = null;
            File file = new File(string7);
            File file2 = new File(string);
            if (file.exists()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfCMSKeyStoreExistsAndCreateIfNot -> (exists)");
                }
                return;
            }
            if (keyStore3 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfCMSKeyStoreExistsAndCreateIfNot -> (exists)");
                }
                throw new SSLException("WCCM KeyStore object for CMS keystore is null.");
            }
            if (keyStore != null) {
                bl2 = keyStore.isReadOnly();
            }
            if (keyStore != null && !bl2) {
                bl = keyStore.isFileBased();
                object9 = keyStore.getLocation();
                object8 = keyStore.getType();
                object7 = keyStore.getProvider();
                string4 = keyStore.getPassword();
                string3 = keyStore.getManagementScope().getScopeName();
                object6 = keyStore.getName();
                object5 = keyStore.getManagementScope().getScopeType();
                if (object6 != null && ((String)object6).endsWith("DefaultKeyStore") && bl) {
                    object9 = CreateCMSKeyStore.fixupLocationWithRepositoryRoot(string6, object9);
                    object9 = KeyStoreManager.getInstance().expand((String)object9);
                    object4 = new File((String)object9);
                    if (!((File)object4).exists()) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "checkIfKeyStoreExistsAndCreateIfNot -> (does not exist)");
                        }
                        throw new SSLException("Cannot find Node's DefaultKeyStore named " + (String)object6 + " at location " + (String)object9);
                    }
                }
                object4 = KeyStoreManager.getInstance().getKeyStore(null, (String)object8, (String)object7, (String)object9, string4, string3, false, null);
                object3 = null;
                object3 = PlatformHelperFactory.getPlatformHelper().isOS400() && this.vmName.equals("Classic VM") ? "IBMi5OSKeyStore" : "CMSKS";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Extracting certificate from default KeyStore to use in CMS store.");
                }
                enumeration = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqAlias", "default");
                object2 = ((KeyStore)object4).getKey((String)((Object)enumeration), string4.toCharArray());
                certificateArray = ((KeyStore)object4).getCertificateChain((String)((Object)enumeration));
                object = ((KeyStore)object4).getCertificate((String)((Object)enumeration));
                if (object2 != null && certificateArray != null) {
                    keyStore4 = KeyStore.getInstance((String)object3, keyStore3.getProvider());
                    keyStore4.load(null, keyStore3.getPassword().toCharArray());
                    if (keyStore4 != null) {
                        keyStore4.setKeyEntry((String)((Object)enumeration), (Key)object2, keyStore3.getPassword().toCharArray(), certificateArray);
                        bl3 = true;
                    }
                }
            }
            if (!bl3) {
                Object object10;
                Class<?> clazz;
                Object object11;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default keystore is not found in repository, creating a new certificate for CMS store.");
                }
                String string8 = keyStore3.getName();
                object9 = keyStore3.getPassword();
                object8 = keyStore3.getType();
                object7 = keyStore3.getProvider();
                string4 = keyStore3.getManagementScope().getScopeName();
                boolean bl4 = keyStore3.isCreateStashFileForCMS();
                object6 = new Boolean(bl4);
                object5 = Boolean.TRUE;
                object4 = Boolean.FALSE;
                object3 = Boolean.TRUE;
                enumeration = new KeyStoreInfo(string8, string, (String)object9, (String)object7, (String)object8, (Boolean)object5, null, string4, null, (Boolean)object4, (Boolean)object3, (Boolean)object6, null, new Integer(0), Boolean.FALSE, null);
                object2 = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqKeySize", "1024");
                certificateArray = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqSubjectDN", "cn=${hostname},o=IBM,c=US");
                KeyStoreManager.getInstance();
                certificateArray = KeyStoreManager.expandHostNameVariable((String)certificateArray, string2);
                object = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqDays", "5475");
                n = new Integer((String)object2);
                int n2 = new Integer((String)object);
                String string9 = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqAlias", "default");
                CertReqInfo certReqInfo = new CertReqInfo(string9, n, (String)certificateArray, n2, (KeyStoreInfo)((Object)enumeration), null);
                Certificate certificate = CertificateManager.getInstance().selfSignedCertificateCreate(certReqInfo);
                if (!keyStore2.isReadOnly()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Add new signer certificate to trust store: " + keyStore2.getName());
                    }
                    object11 = new WSKeyStoreRemotable(keyStoreInfo);
                    clazz = "setCertificateEntry";
                    object10 = new Object[]{string9, certificate};
                    ((WSKeyStoreRemotable)object11).invokeKeyStoreCommand((String)((Object)clazz), (Object[])object10);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trust store is read only, unable to add new signer certificate to trust store: " + keyStore2.getName());
                }
                keyStore4 = KeyStore.getInstance((String)object8, (String)object7);
                if (PlatformHelperFactory.getPlatformHelper().isOS400() && this.vmName.equals("Classic VM")) {
                    try {
                        object11 = Thread.currentThread().getContextClassLoader();
                        clazz = null;
                        clazz = object11 != null ? ((ClassLoader)object11).loadClass("com.ibm.i5os.keystore.i5OSLoadStoreParameter") : Class.forName("com.ibm.i5os.keystore.i5OSLoadStoreParameter");
                        object10 = new KeyStore.PasswordProtection(keyStore3.getPassword().toCharArray());
                        Constructor<?> constructor = clazz.getConstructor(File.class, KeyStore.PasswordProtection.class);
                        loadStoreParameter = (KeyStore.LoadStoreParameter)constructor.newInstance(file2, object10);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, "com.ibm.ws.ssl.config.KeyStoreManager.checkIfKeyStoreExistsAndCreateIfNot", "712", this, new Object[]{exception});
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Could not load iSeries LoadStoreParameter to store the CMS keystore.", new Object[]{exception});
                        }
                        throw new SSLException(exception.getMessage(), exception);
                    }
                } else if (keyStore3.getType().equals("CMSKS") && keyStore3.isCreateStashFileForCMS()) {
                    loadStoreParameter = CMSLoadStoreParameterFactory.newCMSLoadParameter((File)file2, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(keyStore3.getPassword().toCharArray()));
                } else if (keyStore3.getType().equals("CMSKS")) {
                    loadStoreParameter = CMSLoadStoreParameterFactory.newCMSLoadParameter((File)file2, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(keyStore3.getPassword().toCharArray()));
                }
                if (loadStoreParameter != null) {
                    keyStore4.load(loadStoreParameter);
                } else {
                    object11 = KeyStoreManager.getInstance().getInputStream(string, false);
                    keyStore4.load((InputStream)object11, ((String)object9).toCharArray());
                    if (object11 != null) {
                        ((InputStream)object11).close();
                    }
                }
            }
            if (keyStore4 != null) {
                if (keyStore2 != null) {
                    bl = keyStore2.isFileBased();
                    object9 = keyStore2.getLocation();
                    object8 = keyStore2.getType();
                    object7 = keyStore2.getProvider();
                    string4 = keyStore2.getPassword();
                    string3 = keyStore2.getManagementScope().getScopeName();
                    object6 = keyStore2.getName();
                    object5 = keyStore2.getManagementScope().getScopeType();
                    bl2 = keyStore2.isReadOnly();
                    object4 = null;
                    if (object6 != null && ((String)object6).endsWith("DefaultTrustStore") && bl) {
                        object9 = CreateCMSKeyStore.fixupLocationWithRepositoryRoot(string6, (String)object9);
                        object4 = new File((String)object9);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trust store passed in is not default or file-based, not adding signers to CMS store.");
                    }
                    if (object4 != null && ((File)object4).exists() || bl2) {
                        object3 = KeyStoreManager.getInstance().getKeyStore(null, (String)object8, (String)object7, (String)object9, string4, string3, false, null);
                        if (object3 != null) {
                            enumeration = ((KeyStore)object3).aliases();
                            while (enumeration.hasMoreElements()) {
                                object2 = enumeration.nextElement();
                                if (!((KeyStore)object3).isCertificateEntry((String)object2)) continue;
                                certificateArray = (X509Certificate)((KeyStore)object3).getCertificate((String)object2);
                                boolean bl5 = KeyStoreManager.getInstance().checkIfSignerAlreadyExistsInTrustStore((X509Certificate)certificateArray, keyStore4);
                                if (!bl5 && !keyStore4.containsAlias((String)object2)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding alias \"" + (String)object2 + "\" to CMS keystore.");
                                    }
                                    keyStore4.setCertificateEntry((String)object2, (Certificate)certificateArray);
                                    bl3 = true;
                                    continue;
                                }
                                if (bl5) continue;
                                n = 1;
                                String string10 = null;
                                while (keyStore4.containsAlias(string10 = (String)object2 + "_" + n++)) {
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Adding alias \"" + string10 + "\" to CMS keystore.");
                                }
                                if (keyStore4.containsAlias(string10)) continue;
                                keyStore4.setCertificateEntry(string10, (Certificate)certificateArray);
                                bl3 = true;
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Could not load Java KeyStore from repository.  Not adding signers to CMS store.");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cannot find the default trust store on the file system.  Not adding signers to CMS store.");
                    }
                }
                if (bl3) {
                    if (loadStoreParameter == null) {
                        if (PlatformHelperFactory.getPlatformHelper().isOS400() && this.vmName.equals("Classic VM")) {
                            try {
                                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                                object9 = null;
                                object9 = classLoader != null ? classLoader.loadClass("com.ibm.i5os.keystore.i5OSLoadStoreParameter") : Class.forName("com.ibm.i5os.keystore.i5OSLoadStoreParameter");
                                object8 = new KeyStore.PasswordProtection(keyStore3.getPassword().toCharArray());
                                object7 = ((Class)object9).getConstructor(File.class, KeyStore.PasswordProtection.class);
                                loadStoreParameter = (KeyStore.LoadStoreParameter)((Constructor)object7).newInstance(file2, object8);
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException(exception, "com.ibm.ws.ssl.config.KeyStoreManager.checkIfKeyStoreExistsAndCreateIfNot", "848", this, new Object[]{exception});
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Could not load iSeries LoadStoreParameter to store the CMS keystore.", new Object[]{exception});
                                }
                                throw new SSLException(exception.getMessage(), exception);
                            }
                        } else if (keyStore3.getType().equals("CMSKS") && keyStore3.isCreateStashFileForCMS()) {
                            loadStoreParameter = CMSLoadStoreParameterFactory.newCMSStoreParameter((File)file2, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(keyStore3.getPassword().toCharArray()), (boolean)true);
                        } else if (keyStore3.getType().equals("CMSKS")) {
                            loadStoreParameter = CMSLoadStoreParameterFactory.newCMSStoreParameter((File)file2, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(keyStore3.getPassword().toCharArray()), (boolean)false);
                        }
                    }
                    if (loadStoreParameter != null) {
                        keyStore4.store(loadStoreParameter);
                    } else {
                        FileOutputStream fileOutputStream = new FileOutputStream(string);
                        keyStore4.store(fileOutputStream, keyStore3.getPassword().toCharArray());
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.ssl.config.KeyStoreManager.checkIfKeyStoreExistsAndCreateIfNot", "877", this, new Object[]{exception});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception creating CMS keystore.", new Object[]{exception});
            }
            if (exception instanceof SSLException) {
                throw (SSLException)exception;
            }
            throw new SSLException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfKeyStoreExistsAndCreateIfNot (success)");
        }
    }
}

