/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteKeyStore
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteKeyStore.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private String keyStoreName = null;
    private String scopeName = null;
    private Boolean removeKeyStoreFile = null;
    KeyStoreInfo ksInfo = null;
    private ObjectName keyStoreObjName = null;

    public DeleteKeyStore(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public DeleteKeyStore(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        ObjectName objectName3 = null;
        boolean bl = false;
        try {
            objectName = ConfigServiceHelper.createObjectName(null, "Security");
            objectName2 = configService.resolve(session, "Cell=")[0];
            if (objectName2 != null) {
                objectName3 = configService.queryConfigObjects(session, objectName2, objectName, null)[0];
            }
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.removeKeyStoreFile = (Boolean)this.getParameter(CommandConstants.REMOVE_KEY_STORE_FILE);
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName2);
                Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keyStoreName);
            boolean bl2 = commandHelper.exists(configService, session, objectName3, CommandConstants.KEY_STORES, attributeList, this.scopeName);
            if (!bl2) {
                String string = this.keyStoreName + "object name not found.";
                throw new CommandValidationException(string);
            }
            this.keyStoreObjName = commandHelper.getObjectName(configService, session, objectName3, CommandConstants.KEY_STORES, attributeList, this.scopeName);
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, configService, this.keyStoreName, this.scopeName);
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigService exception is" + configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is" + exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "beforeStepsExecuted");
            }
            super.afterStepsExecuted();
            ObjectName objectName = null;
            TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
            if (!taskCommandResultImpl.isSuccessful()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beforeStepsExecuted");
                }
                return;
            }
            try {
                ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
                ConfigService configService = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                Object var6_7 = null;
                objectName = configService.resolve(session, "Cell=:Security=")[0];
                if (!this.keyStoreIsReferenced(session, configService, objectName, this.keyStoreObjName)) {
                    if (this.deleteKeyStore(session, configService, this.keyStoreObjName)) {
                        String string = "KeyStore successfully deleted.";
                        taskCommandResultImpl.setResult(string);
                    }
                    break block8;
                }
                String string = "KeyStore " + this.keyStoreName + " is still being referenced by other objects.";
                throw new ConfigServiceException(string);
            }
            catch (Exception exception) {
                taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean deleteKeyStore(Session var1_1, ConfigService var2_2, ObjectName var3_3) throws Exception {
        var4_4 = false;
        var5_5 = null;
        var6_6 = null;
        var7_7 = null;
        var8_8 = null;
        if (DeleteKeyStore.tc.isEntryEnabled()) {
            Tr.entry(DeleteKeyStore.tc, "deleteKeyStore");
        }
        var5_5 = (String)var2_2.getAttribute(var1_1, var3_3, "location");
        var5_5 = KeyStoreManager.getInstance().expand(var5_5);
        var6_6 = this.ksInfo.getLocation();
        var6_6 = KeyStoreManager.getInstance().expand(var6_6);
        var7_7 = (Boolean)var2_2.getAttribute(var1_1, var3_3, "readOnly");
        var8_8 = (Boolean)var2_2.getAttribute(var1_1, var3_3, "createStashFileForCMS");
        try {
            var2_2.deleteConfigData(var1_1, var3_3);
        }
        catch (Exception var9_9) {
            throw new ConfigServiceException(var9_9.getMessage());
        }
        DeleteKeyStore.setWorkspaceUpdated(var1_1, var6_6);
        if (var8_8.booleanValue()) {
            var9_10 = null;
            var10_12 = var6_6.lastIndexOf(".");
            var9_10 = var10_12 != -1 ? var6_6.substring(0, var10_12 + 1) + "sth" : var6_6 + ".sth";
            if (var9_10 != null && (var11_13 = new File(var9_10)).isFile() && var11_13.canWrite()) {
                DeleteKeyStore.setWorkspaceUpdated(var1_1, var9_10);
            }
        }
        if (!var7_7.booleanValue() && this.removeKeyStoreFile.booleanValue()) {
            try {
                var9_10 = KeyStoreManager.getInstance().expand("${CONFIG_ROOT}");
                var10_12 = (int)var5_5.startsWith(var9_10);
                if (var10_12 == 0 && (var11_13 = new File(var5_5)).isFile() && var11_13.canWrite()) {
                    var11_13.delete();
                }
                var4_4 = true;
                if (!var8_8.booleanValue() || var10_12 != 0) ** GOTO lbl47
                var11_13 = null;
                var12_14 = var5_5.lastIndexOf(".");
                var11_13 = var12_14 != -1 ? var5_5.substring(0, var12_14 + 1) + "sth" : var5_5 + ".sth";
                if (var11_13 == null || !(var13_15 = new File((String)var11_13)).isFile() || !var13_15.canWrite()) ** GOTO lbl47
                var13_15.delete();
            }
            catch (Exception var9_11) {
                if (DeleteKeyStore.tc.isDebugEnabled()) {
                    Tr.debug(DeleteKeyStore.tc, "Exception recieved is " + var9_11.getMessage());
                }
                throw new Exception(var9_11);
            }
        } else {
            var4_4 = true;
        }
lbl47:
        // 4 sources

        if (DeleteKeyStore.tc.isEntryEnabled()) {
            Tr.exit(DeleteKeyStore.tc, "deleteKeyStore");
        }
        return var4_4;
    }

    private boolean keyStoreIsReferenced(Session session, ConfigService configService, ObjectName objectName, ObjectName objectName2) throws Exception {
        boolean bl = false;
        CommandHelper commandHelper = new CommandHelper();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keyStoreIsReferenced");
        }
        try {
            AttributeList attributeList = commandHelper.getReference(configService, session, objectName, CommandConstants.KEY_SETS, CommandConstants.KEY_STORE, objectName2);
            if (attributeList.size() > 0) {
                bl = true;
                return bl;
            }
            AttributeList attributeList2 = configService.getAttributes(session, objectName, new String[]{CommandConstants.REPERTOIRE}, false);
            List list = (List)((Attribute)attributeList2.get(0)).getValue();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName3 = (ObjectName)iterator.next();
                AttributeList attributeList3 = (AttributeList)configService.getAttribute(session, objectName3, CommandConstants.SETTING);
                ObjectName objectName4 = (ObjectName)ConfigServiceHelper.getAttributeValue(attributeList3, CommandConstants.KEY_STORE);
                if (objectName4 == null || !objectName4.equals(objectName2)) continue;
                bl = true;
                return bl;
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigServiceException recieved is " + configServiceException.getMessage());
            }
            throw new Exception(configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception recieved is " + exception.getMessage());
            }
            throw new Exception(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keyStoreIsRefenced");
        }
        return bl;
    }

    public static void setWorkspaceUpdated(Session session, String string) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setWorkspaceUpdated");
            }
            string = string.replace("\\", "/");
            try {
                String string2 = KeyStoreManager.getInstance().expand(string);
                WorkSpace workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.toString());
                String string3 = "cells/" + ManagementScopeManager.getInstance().getCellName();
                int n = string2.indexOf(string3);
                if (n != -1) {
                    string2 = string2.substring(n + string3.length() + 1);
                    RepositoryContext repositoryContext = workSpace.findContext(string3);
                    repositoryContext.notifyChanged(2, string2);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Exception while setting a workspace file to delete " + exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setWorkspaceUpdated");
        }
    }
}

